% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/lsgl_navigate.R
\name{features.lsgl}
\alias{features.lsgl}
\title{Nonzero features}
\usage{
\method{features}{lsgl}(object, ...)
}
\arguments{
\item{object}{a lsgl object}

\item{...}{ignored}
}
\value{
a list of of length \code{nmod(x)} containing the nonzero features (that is nonzero columns of the beta matrices)
}
\description{
Extracts the nonzero features for each model.
}
\examples{
set.seed(100) # This may be removed, it ensures consistency of the daily tests

## Simulate from Y=XB+E, the dimension of Y is N x K, X is N x p, B is p x K

N <- 100 #number of samples
p <- 50 #number of covariates
K <- 25  #number of groups

B<-matrix(sample(c(rep(1,p*K*0.1),rep(0, p*K-as.integer(p*K*0.1)))),nrow=p,ncol=K)

X<-matrix(rnorm(N*p,1,1),nrow=N,ncol=p)
Y<-X\%*\%B+matrix(rnorm(N*K,0,1),N,K)

lambda<-lsgl.lambda(X,Y, alpha=1, d = 25, lambda.min=.5, intercept=FALSE)
fit <-lsgl(X,Y, alpha=1, lambda = lambda, intercept=FALSE)

# the nonzero features of model 1, 10 and 25
features(fit)[c(1,10,25)]

# count the number of nonzero features in each model
sapply(features(fit), length)
}
\author{
Martin Vincent
}

