% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fuse.R
\name{fuse}
\alias{fuse}
\alias{fuse_}
\alias{fuse_.data.frame}
\alias{fuse_.tbl_df}
\title{Fuse multiple columns into one}
\usage{
fuse(.data, col, ..., fun = concat0, remove = TRUE)

fuse_(.data, col, from, fun = concat0, remove = TRUE)

\method{fuse_}{data.frame}(.data, col, from, fun = concat0, remove = TRUE)

\method{fuse_}{tbl_df}(.data, col, from, fun = concat0, remove = TRUE)
}
\arguments{
\item{.data}{A tbl or data.frame}

\item{col}{character. (Bare) name of column to add}

\item{...}{Specification of columns to fuse.}

\item{fun}{function. The function to be applied (\code{concat0} by default).}

\item{remove}{logical. If \code{TRUE} (the default), 
remove input columns from output data frame.}

\item{from}{character. A vector of the names of columns to fuse.}
}
\description{
\code{fuse} is a more flexible version of \code{\link[tidyr]{unite}} 
from package \pkg{tidyr}.
}
\note{
This function has been inspired by the issue raised at 
\url{https://github.com/tidyverse/tidyr/issues/203}.
}
\examples{
df <- data.frame(x = c(NA, "a", NA), 
                 y = c("b", NA, NA))
fuse(df, "z", x, y)

# To be compared with: 
tidyr::unite(df, "z", x, y, sep = "")
# The same
fuse(df, "z", x, y, fun = function(x) concat0(x, na.rm = FALSE))

}
\seealso{
\code{\link[tidyr]{unite}} and  
\code{\link[tidyr]{unite_}} from package \pkg{tidyr}; 

\code{\link[bazar]{concat0}} from package \pkg{bazar}.
}

