% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_nl_irfs.R
\name{plot_nl_irfs}
\alias{plot_nl_irfs}
\title{Compute and display plots of nonlinear impulse responses}
\usage{
plot_nl_irfs(results_nl)
}
\arguments{
\item{results_nl}{A \link{list}() with 3D arrays estimated in \link{lp_nl}().}
}
\value{
A list with (gg-)plots for nonlinear impulse responses.
}
\description{
Compute and display (nonlinear) impulse responses estimated with \link{lp_nl}().
}
\examples{
\donttest{
# Load package
  library(lpirfs)

# Load data
  data_set_df <- monetary_var_data

# Estimate model and save results
  results_nl <- lp_nl(data_set_df, lags_lin       = 4L,
                                   lags_nl        = 3L,
                                   lags_criterion = NaN,
                                   max_lags       = NaN,
                                   trend          = 0L,
                                   shock_type     = 1L,
                                   confint        = 1.96,
                                   hor            = 24L,
                                   switching      = data_set_df$FF,
                                   hp_filter      = 1L,
                                   lambda         = 1600,
                                   gamma          = 3)

# Make and save all plots
  nl_plots <- plot_nl_irfs(results_nl)

# Show all plots
  library(ggpubr)
  library(gridExtra)

# Save plots based on states
  s1_plots <- sapply(nl_plots$gg_s1, ggplotGrob)
  s2_plots <- sapply(nl_plots$gg_s2, ggplotGrob)

# Show first irf of each state
  plot(s1_plots[[1]])
  plot(s2_plots[[1]])

# Show all plots
  marrangeGrob(s1_plots, nrow = ncol(data_set_df), ncol = ncol(data_set_df), top = NULL)
  marrangeGrob(s2_plots, nrow = ncol(data_set_df), ncol = ncol(data_set_df), top = NULL)

 }
}
\author{
Philipp Adämmer
}
