% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tslphom_dual.R
\name{tslphom_dual}
\alias{tslphom_dual}
\title{Implements the tslphom_dual algorithm}
\usage{
tslphom_dual(
  votes_election1,
  votes_election2,
  integers = FALSE,
  solver = "lp_solve",
  ...
)
}
\arguments{
\item{votes_election1}{data.frame (or matrix) of order IxJ with the counts to be initially
mapped to rows. When estimating vote transfer matrices, the votes gained by
the \emph{J} political options competing on election 1 (or origin) in the \emph{I}
territorial units considered.  The sum by rows of \code{votes_election1} and
\code{votes_election2} must coincide.}

\item{votes_election2}{data.frame (or matrix) of order IxK with the counts to be initially mapped
to columns. When estimating vote transfer matrices, the votes gained by
the \emph{K} political options competing on election 2 (or destination) in the \emph{I}
territorial units considered. In general, The sum by rows of \code{votes_election1} and
\code{votes_election2} must coincide.}

\item{integers}{A TRUE/FALSE value that indicates whether the problem is solved in integer values
in both iterations: zero (lphom) and final (including unit) solutions. If TRUE, the LP matrices
are approximated to the closest integer solution solving the corresponding Integer Linear Program.
Default, FALSE.}

\item{solver}{A character string indicating the linear programming solver to be used, only
\code{lp_solve} and \code{symphony} are allowed. By default, \code{lp_solve}.}

\item{...}{Other arguments to be passed to the function. Not currently used.}
}
\value{
A list with the following components
\item{VTM.votes.w}{ The matrix of order JxK with the estimated cross-distribution of votes of elections 1 and 2,
attained weighting the two dual solutions using as weights the corresponding HTEe estimates.}
\item{VTM.votes.units.w}{ The array of order JxKxI with the local estimated cross-distributions of votes of elections 1 and 2 by unit,
attained weighting the two dual solutions using as weights the corresponding HTEe estimates.}
\item{VTM.votes.a}{ The matrix of order JxK with the estimated cross-distribution of votes of elections 1 and 2,
attained simple averaging the two dual solutions.}
\item{VTM.votes.units.a}{ The matrix of order JxKxI with the estimated cross-distributions of votes of elections 1 and 2 by unit,
attained weighting the two dual solutions using as weights the corresponding HTEe estimates.}
\item{HETe.w}{ Estimated heterogeneity index associated to the \code{VTM.votes.w} solution.}
\item{HETe.a}{ Estimated heterogeneity index associated to the \code{VTM.votes.a} solution.}
\item{VTM12.w}{ The matrix of order JxK with the estimated row-standardized proportions of vote transitions from election 1
to election 2 associated to the \code{VTM.votes.w} solution.}
\item{VTM21.w}{ The matrix of order KxJ with the estimated row-standardized proportions of vote transitions from election 2
to election 1 associated to the \code{VTM.votes.w} solution.}
\item{VTM12.a}{ The matrix of order JxK with the estimated row-standardized proportions of vote transitions from election 1
to election 2 associated to the \code{VTM.votes.a} solution.}
\item{VTM21.a}{ The matrix of order KxJ with the estimated row-standardized proportions of vote transitions from election 2
to election 1 associated to the \code{VTM.votes.a} solution.}
\item{tslphom.object.12}{ The output of the \code{\link{tslphom}} function attained solving the problem X --> Y,
that is, mapping \code{votes_election1} to rows and \code{votes_election2} to columns.}
\item{tslphom.object.21}{ The output of the \code{\link{tslphom}} function attained solving the problem Y --> X,
that is, mapping \code{votes_election2} to rows and \code{votes_election1} to columns.}
\item{inputs}{ A list containing all the objects with the values used as arguments by the function.}
}
\description{
Estimates RxC vote transfer matrices (ecological contingency tables) with tslphom_dual
}
\examples{
x <- France2017P[, 1:8]
y <- France2017P[, 9:12]
y[,1] <- y[,1]  - (rowSums(y) - rowSums(x))
mt <- tslphom_dual(x, y)
mt$VTM.votes.w
mt$HETe.w

}
\references{
Pavia, JM and Romero, R (2021). Symmetry estimating R×C vote transfer matrices from aggregate data, mimeo.
}
\seealso{
\code{\link{tslphom}} \code{\link{lphom_dual}} \code{\link{nslphom_dual}} \code{\link{lphom_joint}} \code{\link{tslphom_joint}} \code{\link{nslphom_joint}}

Other linear programing ecological inference functions: 
\code{\link{lclphom}()},
\code{\link{lphom_dual}()},
\code{\link{lphom_joint}()},
\code{\link{lphom}()},
\code{\link{nslphom_dual}()},
\code{\link{nslphom_joint}()},
\code{\link{nslphom}()},
\code{\link{tslphom_joint}()},
\code{\link{tslphom}()}
}
\author{
Jose M. Pavia, \email{pavia@uv.es}

Rafael Romero \email{rromero@eio.upv.es}
}
\concept{linear programing ecological inference functions}
