% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lori.R
\name{altmin}
\alias{altmin}
\title{Estimation algorithm for the LORI parameters.}
\usage{
altmin(Y, lambda1, lambda2, cov = NULL, rank.max = 5, thresh = 1e-06,
  maxit = 1000, trace.it = T, reff = T, ceff = T)
}
\arguments{
\item{Y}{[matrix, data.frame] count table (nxp).}

\item{lambda1}{[positive number] the regularization parameter for the interaction matrix.}

\item{lambda2}{[positive number] the regularization parameter for the covariate effects.}

\item{cov}{[matrix, data.frame] design matrix (np*q) in order row1xcol1,row2xcol2,..,rownxcol1,row1xcol2,row2xcol2,...,...,rownxcolp}

\item{rank.max}{[integer] maximum rank of interaction matrix (smaller than min(n-1,p-1))}

\item{thresh}{[positive number] convergence tolerance of algorithm, by default \code{1e-6}.}

\item{maxit}{[integer] maximum allowed number of iterations.}

\item{trace.it}{[boolean] whether convergence information should be printed}

\item{reff}{[boolean] whether row effects should be fitted, default value is TRUE}

\item{ceff}{[boolean] whether column effects should be fitted, default value is TRUE}
}
\description{
Estimation algorithm for the LORI parameters.
}
\examples{
\dontrun{
X = matrix(rnorm(50), 25)
Y <- matrix(rpois(25, 1:25), 5)
res <- altmin(Y, 100, 100, X)
}
}
