% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lori_plots.R
\name{plot_counts}
\alias{plot_counts}
\title{plot_counts}
\usage{
plot_counts(res_lori, r.cov = NULL, c.cov = NULL, rc.cov = NULL)
}
\arguments{
\item{res_lori}{lori output}

\item{r.cov}{a vector of indices indicating the indices of the row covariates}

\item{c.cov}{a vector of indices indicating the indices of the column covariates}

\item{rc.cov}{a vector of indices indicating the indices of the row-column covariates}
}
\description{
plot_counts
}
\examples{
Y <- matrix(rpois(9, lambda=1:9),nrow=3)
Y[sample(1:9, 2)] <- NA
cov <- matrix(rnorm(18), nrow=9)
colnames(cov) <- c("cov1","cov2")
res <- lori(Y,cov,1,1,rank.max=2,maxit=1)
plot_counts(res, r.cov=1:2)
}
