% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tune_regularization.R
\name{lambda_QUT}
\alias{lambda_QUT}
\title{Computes the threshold $lambda_{QUT}$ with parametric bootstrap when  NO covariates are available.
If you don't have any covariates, use this function instead of \code{lambda_QUT_covariates} which will be significantly slower.}
\usage{
lambda_QUT(Y, q = 0.95, n = 100)
}
\arguments{
\item{Y}{A matrix of counts (contingency table).}

\item{q}{A number between \code{0} and \code{1}. The quantile of the distribution of $lambda_{QUT}$ to take.}

\item{n}{An integer. The number of parametric bootstrap samples to draw.}
}
\value{
the value of $lambda_{QUT}$ to use in LoRI.
}
\description{
Computes the threshold $lambda_{QUT}$ with parametric bootstrap when  NO covariates are available.
If you don't have any covariates, use this function instead of \code{lambda_QUT_covariates} which will be significantly slower.
}
\examples{
{
X = matrix(rnorm(rep(0, 15)), 5)
Y = matrix(rpois(length(c(X)), exp(c(X))), 5)
lambda = lambda_QUT(Y, n=10)
\donttest{
   lambda = lambda_QUT(Y, n=100)
}
}
}
