### R code from vignette source 'lorentz.Rnw'
### Encoding: UTF-8

###################################################
### code chunk number 1: lorentz.Rnw:85-86
###################################################
library(lorentz)


###################################################
### code chunk number 2: lorentz.Rnw:115-117
###################################################
u <- as.3vel(c(0.3,-0.4,0.8))
u


###################################################
### code chunk number 3: lorentz.Rnw:124-125
###################################################
as.4vel(u)


###################################################
### code chunk number 4: lorentz.Rnw:130-131
###################################################
boost(u)


###################################################
### code chunk number 5: lorentz.Rnw:139-140
###################################################
boost(u) %*% c(4,5,-2,3)


###################################################
### code chunk number 6: lorentz.Rnw:147-150
###################################################
v <- as.3vel(c(0.4,0.2,-0.1))
L <- boost(u) %*% boost(v)
L


###################################################
### code chunk number 7: lorentz.Rnw:158-160
###################################################
(U <- orthog(L))
(P <- pureboost(L))


###################################################
### code chunk number 8: lorentz.Rnw:166-168
###################################################
crossprod(U) - diag(4)
P - t(P)


###################################################
### code chunk number 9: kickoff
###################################################
library(lorentz)
u <- as.3vel(c(-0.7,+0.2,-0.3))
v <- as.3vel(c(+0.3,+0.3,+0.4))
w <- as.3vel(c(+0.1,+0.3,+0.8))
x <- as.3vel(c(-0.2,-0.1,-0.9))
u


###################################################
### code chunk number 10: try
###################################################
u+v
v+u


###################################################
### code chunk number 11: lorentz.Rnw:234-235
###################################################
(u+v)-gyr(u,v,v+u)


###################################################
### code chunk number 12: funcid
###################################################
f <- gyrfun(u,v)
(u+v)-f(v+u)    # should be zero


###################################################
### code chunk number 13: vec9
###################################################
u9 <- r3vel(9)
u9


###################################################
### code chunk number 14: vecfun
###################################################
f <- gyrfun(u9,v)
f(x)


###################################################
### code chunk number 15: u9+x
###################################################
u9+x


###################################################
### code chunk number 16: nonass
###################################################
(u+v)+w
u+(v+w)


###################################################
### code chunk number 17: nonass1
###################################################
(u+(v+w)) - ((u+v)+gyr(u,v,w))
((u+v)+w) - (u+(v+gyr(v,u,w)))


###################################################
### code chunk number 18: viss
###################################################
u <- as.3vel(c(0.4,0,0))
v <- seq(as.3vel(c(0.4,-0.2,0)), as.3vel(c(-0.3,0.9,0)),len=20)
w <- as.3vel(c(0.8,-0.4,0))


###################################################
### code chunk number 19: comfail1_fig
###################################################
comm_fail1(u=u, v=v)


###################################################
### code chunk number 20: comfail2_fig
###################################################
comm_fail2(u=u, v=v)


###################################################
### code chunk number 21: assfail_fig
###################################################
ass_fail(u=u, v=v, w=w, bold=10)


###################################################
### code chunk number 22: defuvw
###################################################
 u <- as.3vel(c(+0.5,0.1,-0.2))
 v <- as.3vel(c(+0.4,0.3,-0.2))
 w <- as.3vel(c(-0.3,0.2,+0.2))


###################################################
### code chunk number 23: lorentz.Rnw:369-372
###################################################
jj1 <- u %>% add(v)
jj2 <- u+v
speed(jj1-jj2)


###################################################
### code chunk number 24: lorentz.Rnw:377-380
###################################################
jj1 <- u %>% add(v) %>% add(w)
jj2 <- (u+v)+w
speed(jj1-jj2)


###################################################
### code chunk number 25: lorentz.Rnw:387-390
###################################################
jj1 <- u %>% add(v %>% add(w))
jj2 <- u+(v+w)
speed(jj1-jj2)


###################################################
### code chunk number 26: funcnot
###################################################
u <- as.3vel(c(0, 0.8, 0))
v <- r3vel(5,0.9)
x <- as.3vel(c(0.7, 0, -0.7))
y <- as.3vel(c(0.1, 0.3, -0.6))


###################################################
### code chunk number 27: lorentz.Rnw:409-411
###################################################
f <- gyrfun(u,v)
f(w)


###################################################
### code chunk number 28: lorentz.Rnw:417-418
###################################################
prod3(f(x),f(y)) - prod3(x,y)


###################################################
### code chunk number 29: lorentz.Rnw:423-426
###################################################
f <- gyrfun(u,v)
g <- gyrfun(v,u)
f(g(x)) - g(f(x))


###################################################
### code chunk number 30: lorentz.Rnw:432-434
###################################################
x %<>% f %>% add(y)      # x <- f(x)+y
x


###################################################
### code chunk number 31: lorentz.Rnw:446-448
###################################################
sol(299792458)
sol()


###################################################
### code chunk number 32: lorentz.Rnw:457-459
###################################################
u <- as.3vel(c(100,200,300))
u


###################################################
### code chunk number 33: lorentz.Rnw:466-467
###################################################
gam(u)


###################################################
### code chunk number 34: lorentz.Rnw:472-473
###################################################
gam(u)-1


###################################################
### code chunk number 35: lorentz.Rnw:479-480
###################################################
gamm1(u)


###################################################
### code chunk number 36: lorentz.Rnw:485-486
###################################################
boost(u)


###################################################
### code chunk number 37: lorentz.Rnw:494-496
###################################################
sol(Inf)
boost(u)


###################################################
### code chunk number 38: lorentz.Rnw:502-506
###################################################
sol(299792458)
v <- as.3vel(c(400,-200,300))
boost(u) %*% boost(v)
boost(v) %*% boost(u)


###################################################
### code chunk number 39: lorentz.Rnw:607-609
###################################################
sol(1)
boost(as.3vel(c(0.6,0,0)))


###################################################
### code chunk number 40: lorentz.Rnw:660-663
###################################################
sol(299792458)
(B <- boost(as.3vel(c(1000,0,0))))  # 1km/s left to right
solve(B) %*% c(1,0,0,0)             # active transform ~= Galilean


###################################################
### code chunk number 41: lorentz.Rnw:673-675
###################################################
sol(10)
options(digits=3)


###################################################
### code chunk number 42: lorentz.Rnw:678-681
###################################################
u <- 1:7  # speed in the x-direction [c=10]
jj <- cbind(gam(u),gam(u)*u,0,0)
(U <- as.4vel(jj))


###################################################
### code chunk number 43: lorentz.Rnw:686-687
###################################################
(B <- boost(as.3vel(c(6,0,0))))  # 60% speed of light


###################################################
### code chunk number 44: lorentz.Rnw:697-698
###################################################
U %*% t(B)


###################################################
### code chunk number 45: lorentz.Rnw:703-704
###################################################
is.consistent.4vel(U %*% t(B))


###################################################
### code chunk number 46: lorentz.Rnw:711-712
###################################################
tcrossprod(U,B)


###################################################
### code chunk number 47: lorentz.Rnw:729-730
###################################################
solve(B)


###################################################
### code chunk number 48: lorentz.Rnw:735-736
###################################################
tcrossprod(U,solve(B))


###################################################
### code chunk number 49: lorentz.Rnw:743-744
###################################################
is.consistent.4vel(tcrossprod(U,solve(B)))


###################################################
### code chunk number 50: lorentz.Rnw:753-757
###################################################
sol(100)
B1 <- boost(r3vel(1)) %*% boost(r3vel(1))
B2 <- boost(r3vel(1)) %*% boost(r3vel(1)) 
(U <- r4vel(5))


###################################################
### code chunk number 51: lorentz.Rnw:763-767
###################################################
U %*% t(B1) %*% t(B2)
U %*% t(B2 %*% B1)    # note order of operations
tcrossprod(U, B2 %*% B1)
U %>% tcrossprod(B2 %*% B1)


###################################################
### code chunk number 52: lorentz.Rnw:776-781
###################################################
B1 <- boost(r3vel(1)) %*% boost(r3vel(1))
B2 <- boost(r3vel(1)) %*% boost(r3vel(1))
LHS <- transform_uu(transform_uu(dust(1),B1),B2)
RHS <- transform_uu(dust(1),B2 %*% B1)   # note order
LHS-RHS  # should be small


###################################################
### code chunk number 53: lorentz.Rnw:787-789
###################################################
perfectfluid(3,100) %>% transform_uu(B1) %>% transform_uu(B2)
perfectfluid(3,100) %>% transform_uu(B2 %*% B1)  # should match


###################################################
### code chunk number 54: lorentz.Rnw:798-799
###################################################
U %*% B  # Young Frankstein: Do Not Use This Brain!


###################################################
### code chunk number 55: lorentz.Rnw:809-811
###################################################
sol(1)
(A <- as.photon(as.3vel(cbind(0.9,1:5/40,5:1/40))))


###################################################
### code chunk number 56: lorentz.Rnw:819-820
###################################################
inner4(A)


###################################################
### code chunk number 57: lorentz.Rnw:827-828
###################################################
tcrossprod(A,boost(as.3vel(c(0.7,0,0))))


###################################################
### code chunk number 58: lorentz.Rnw:835-836
###################################################
tcrossprod(A,boost(as.3vel(c(-0.7,0,0))))


###################################################
### code chunk number 59: lorentz.Rnw:841-842
###################################################
tcrossprod(A,solve(boost(as.3vel(c(0.7,0,0)))))


###################################################
### code chunk number 60: lorentz.Rnw:859-861
###################################################
m <- c(1,1,1)
B <- boost(as.3vel(c(0.5,0,0)))


###################################################
### code chunk number 61: lorentz.Rnw:871-873
###################################################
A
(A <- as.4mom(A %*% t(B)))


###################################################
### code chunk number 62: lorentz.Rnw:880-881
###################################################
(A <- reflect(A,m))


###################################################
### code chunk number 63: lorentz.Rnw:890-891
###################################################
(A <- as.4mom(A %*% solve(t(B))))


###################################################
### code chunk number 64: lorentz.Rnw:902-904
###################################################
A <- as.photon(as.3vel(cbind(0.9,1:5/40,5:1/40)))
A %>% tcrossprod(B) %>% reflect(m) %>% tcrossprod(solve(B)) %>% as.4mom()


###################################################
### code chunk number 65: lorentz.Rnw:917-928
###################################################
sol(1)
light_start <- as.photon(as.3vel(cbind(0.9,1:5/40,5:1/40)))
m <- c(1,0,0)     # mirror normal to x-axis
B1 <- boost(as.3vel(c(-0.5, 0.1, 0.0)))
B2 <- boost(as.3vel(c( 0.2, 0.0, 0.0)))
B3 <- boost(as.3vel(c( 0.0, 0.0, 0.6)))
B <- B1 %*% B2 %*% B3   # matrix multiplication is associative!
light <- light_start %*% t(B)
light <- reflect(light,m)
light <- as.4mom(light %*% solve(t(B)))
light


###################################################
### code chunk number 66: lorentz.Rnw:935-936
###################################################
light_start %>% tcrossprod(B) %>% reflect(m) %>% tcrossprod(solve(B)) %>% as.4mom()


###################################################
### code chunk number 67: lorentz.Rnw:940-948
###################################################
sol(Inf)
light_start <- as.photon(as.3vel(cbind(0.9,1:5/40,5:1/40)))
B1 <- boost(as.3vel(c(-0.5, 0.1, 0.0)))
B2 <- boost(as.3vel(c( 0.2, 0.0, 0.0)))
B3 <- boost(as.3vel(c( 0.0, 0.0, 0.6)))
B <- B1 %*% B2 %*% B3
light_start
light_start %>% tcrossprod(B) %>% reflect(m) %>% tcrossprod(solve(B)) %>% as.4mom()


