% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gg_pipe.R
\name{gg_pipe}
\alias{gg_pipe}
\title{Pipe ggplot object}
\usage{
gg_pipe(data, ggObj)
}
\arguments{
\item{data}{a data frame to use for ggplot}

\item{ggObj}{a ggplot object to be passed though}
}
\value{
a \code{ggplot} evaluate object
}
\description{
Pack a \code{ggplot} object forward to \code{ggplot2loon} expressions
via a pipe-operator "\%>\%".
}
\details{
When "+" and "\%>\%" both appear in pipe operations, "\%>\%" takes the priority of "+",e.g:

\code{mtcars \%>\%
   ggplot(aes(mpg, wt, colour = cyl)) +
   geom_point() \%>\%
   ggplot2loon()},

error would occur. The reason is

\code{geom_point() \%>\% ggplot2loon()}

would run before

\code{ggplot(aes(mpg, wt, colour = cyl)) + geom_point()}.

Hence, we need a function \code{gg_pipe()} to pack the \code{ggplot} object and force operations happen in order.
}
\examples{
if(requireNamespace("magrittr") && interactive()) {
\dontrun{
 # Error
 g <- mtcars \%>\%
    ggplot(aes(mpg, wt, colour = cyl)) +
    geom_point() \%>\%
    ggplot2loon()
}
 g <- mtcars \%>\%
   gg_pipe(
     ggplot(aes(mpg, wt, colour = cyl)) + geom_point()
   ) \%>\%
   ggplot2loon()
}
}
