% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interactive-ggproto.R
\name{itemLabel}
\alias{itemLabel}
\title{Modify the \code{itemLabel} component}
\usage{
itemLabel(itemLabel = NULL, showItemLabels = NULL)
}
\arguments{
\item{itemLabel}{The customized querying information.}

\item{showItemLabels}{A logical value. Show item labels or not. Default is \code{FALSE}}
}
\value{
a \code{ggproto} object
}
\description{
Querying in interactive graphics
}
\examples{
if(interactive()) {

  l_ggplot(mpg, mapping = aes(x = displ, y = cty)) +
    geom_point(size = 4) +
    # push the states of scatter plot to the histogram
    itemLabel(itemLabel = with(mpg,
                 paste0("model: ", manufacturer, " ", model, "\n",
                 "year: ", year, "\n",
                 "drive way: ", drv, "\n",
                 "fuel type: ", fl)
              ),
              showItemLabels = TRUE
    )
    # hover the mouse on top of any point to check the information we set
}
}
\seealso{
\code{\link{linking}}, \code{\link{selecting}}, \code{\link{interactivity}}
}
