% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.R
\name{print.loo}
\alias{print.loo}
\title{Print method for 'loo' objects}
\usage{
\method{print}{loo}(x, digits = 1, plot_k = FALSE, ...)
}
\arguments{
\item{x}{A list with class \code{'loo'} (as returned by \code{\link{loo}} or
\code{\link{waic}}).}

\item{digits}{An integer passed to \code{\link[base]{round}}.}

\item{plot_k}{Logical. If \code{TRUE} the estimates of the Pareto shape
parameter \eqn{k} are plotted. Ignored if \code{x} was generated by
\code{\link{waic}}. To just plot \eqn{k} without printing use the
\code{\link[=pareto-k-diagnostic]{plot method}}.}

\item{...}{Arguments passed to \code{\link{plot.loo}} if \code{plot_k} is
\code{TRUE}.}
}
\value{
\code{x}, invisibly.
}
\description{
Print method for 'loo' objects
}
\seealso{
\code{\link{pareto-k-diagnostic}}
}
