% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.R
\name{print.loo}
\alias{plot.loo}
\alias{print.compare.loo}
\alias{print.loo}
\title{Print and plot methods}
\usage{
\method{print}{loo}(x, ..., digits = 1, warn = TRUE, plot_k = FALSE)

\method{print}{compare.loo}(x, ..., digits = 1)

\method{plot}{loo}(x, ..., label_points = FALSE)
}
\arguments{
\item{x}{A list with class \code{'loo'} (as returned by the \code{\link{loo}}
function or, for \code{print} only, the \code{\link{waic}} function). For
\code{print}, \code{x} can also have class \code{'compare.loo'} (as
returned by \code{\link{compare}}).}

\item{...}{For \code{plot}, arguments to pass to \code{\link[graphics]{text}}
if \code{label_points = TRUE}.}

\item{digits}{An integer passed to \code{\link[base]{round}}.}

\item{warn}{Logical. If \code{TRUE} (the default), a warning message will be
printed if any estimates of the Pareto shape parameter \eqn{k} are
problematic. See the PSIS-LOO section in \code{\link{loo-package}} for
details on the interpretation of \eqn{k}. Ignored if \code{x} was generated
by \code{\link{waic}}.}

\item{plot_k}{Logical. If \code{TRUE} the estimates of the Pareto shape
parameter \eqn{k} are plotted. Ignored if \code{x} was generated by
\code{\link{waic}}. To just plot \eqn{k} without printing use
\code{plot(x)}.}

\item{label_points}{Logical. If \code{TRUE} the observation numbers
corresponding to any values of \eqn{k} greater than 0.5 will be displayed
in the plot. Any arguments specified in \code{...} will be passed to
\code{\link[graphics]{text}} and can be used to control the appearance of
the labels.}
}
\value{
The \code{print} methods return \code{x} invisibly. The \code{plot}
  method is called for its side effect and does not return anything. If
  \code{x} is the result of a call to \code{\link{loo}}, \code{plot(x)}
  produces a plot of the estimates of the Pareto shape parameter \eqn{k}.
  There is no \code{plot} method for objects generated by a call to
  \code{\link{waic}}.
}
\description{
\code{print} and \code{plot} methods for objects of class \code{'loo'} and
\code{print} method for objects of class \code{'compare.loo'}.
}

