% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/doubletruncation.R
\name{fit_ditrunc_elife}
\alias{fit_ditrunc_elife}
\title{Fit excess lifetime models for doubly interval truncated data}
\usage{
fit_ditrunc_elife(
  time,
  ltrunc1 = NULL,
  rtrunc1 = NULL,
  ltrunc2 = NULL,
  rtrunc2 = NULL,
  thresh = 0,
  family = c("exp", "gp", "gomp", "gompmake", "weibull", "extgp", "gppiece",
    "extweibull", "perks", "beard", "perksmake", "beardmake"),
  weights = NULL,
  export = FALSE,
  start = NULL,
  restart = FALSE,
  arguments = NULL,
  ...
)
}
\arguments{
\item{time}{excess time of the event of follow-up time, depending on the value of event}

\item{ltrunc1}{lower truncation limit, default to \code{NULL}}

\item{rtrunc1}{upper truncation limit, default to \code{NULL}}

\item{ltrunc2}{lower truncation limit, default to \code{NULL}}

\item{rtrunc2}{upper truncation limit, default to \code{NULL}}

\item{thresh}{vector of thresholds}

\item{family}{string; choice of parametric family, either exponential (\code{exp}), Weibull (\code{weibull}), generalized Pareto (\code{gp}), Gompertz (\code{gomp}), Gompertz-Makeham (\code{gompmake}) or extended generalized Pareto (\code{extgp}).}

\item{weights}{weights for observations}

\item{export}{logical; should data be included in the returned object to produce diagnostic plots? Default to \code{FALSE}.}

\item{start}{vector of starting values for the optimization routine. If \code{NULL}, the algorithm attempts to find default values and returns a warning with
false convergence diagnostic if it cannot.}

\item{restart}{logical; should multiple starting values be attempted? Default to \code{FALSE}.}

\item{arguments}{a named list specifying default arguments of the function that are common to all \code{elife} calls}

\item{...}{additional arguments for optimization, currently ignored.}
}
\value{
an object of class \code{elife_par}
}
\description{
This function is a wrapper around constrained optimization
routines for different models with non-informative
censoring and truncation patterns.
}
\note{
The extended generalized Pareto model is constrained
to avoid regions where the likelihood is flat so \eqn{\xi \in [-1, 10]} in
the optimization algorithm.

The standard errors are obtained via the observed information matrix, calculated
using the hessian. In many instances, such as when the shape parameter is zero
or negative, the hessian is singular and no estimates are returned.
}
\keyword{internal}
