% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/longit_array.R
\name{longitudinal_array}
\alias{longitudinal_array}
\title{Generate a matrix with various lags from a dataframe}
\usage{
longitudinal_array(
  data,
  subj_var,
  vars,
  time_var,
  lags,
  label_length = 1,
  label_var = NULL,
  label_output = FALSE,
  time_var_output = FALSE
)
}
\arguments{
\item{data}{A data frame, data frame extension (e.g. a \code{tibble}).}

\item{subj_var}{A character string referring to the variable
that specifies the "subject" variable.}

\item{vars}{A character string referring to the variables
that contain the variable values.}

\item{time_var}{A character string referring to the variable
that contains the time variable values (e.g. visit day, minutes, years).
Important to get the sequences in the right order.}

\item{lags}{The length of each sliced sequence.}

\item{label_length}{How many values after are considered to be
the label? Default to 1. If \code{label_length} = 1, the label value
is always the value following the sliced sequence.}

\item{label_var}{A character string referring to the variables
that contain the label variable values.}

\item{label_output}{logical. if \code{TRUE} a list including the
matrix with the sliced sequences and a vector with the label is returned.}

\item{time_var_output}{logical. Is \code{time_var} to be included
in the final output. Default to \code{FALSE}.}
}
\value{
If \code{label_output} is \code{FALSE}, a 3D array with the
sliced sequences is returned. The array dimensions are
subject, time and variable.
If \code{label_output} is \code{TRUE}, a list with the array
and vector with the labels is returned.
}
\description{
Generate a matrix with various lags from a dataframe
}
\examples{
longitudinal_array(alsfrs_data, "subjid", c("p1", "p2", "p3"), 
                   "visdy", lags = 3, label_output = FALSE)
longitudinal_array(alsfrs_data, "subjid", c("p1", "p2", "p3"),
                   "visdy", lags = 3, label_output = FALSE)[1,,]
longitudinal_array(alsfrs_data, "subjid", c("p1", "p2", "p3"), 
                  "visdy", lags = 3, label_output = FALSE)[,1,]
longitudinal_array(alsfrs_data, "subjid", c("p1", "p2", "p3"),
                  "visdy", lags = 3, label_output = FALSE)[,,1]
}
