% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logr.R
\name{log_resume}
\alias{log_resume}
\title{Resume writing to a log}
\usage{
log_resume(file_name = NULL)
}
\arguments{
\item{file_name}{The name of the log file to resume.
If the \code{file_name} parameter is not supplied, the function will look
in the current session for the original name and path of the log.  If that
name and path is not found, an error will be generated.}
}
\value{
The path of the log.
}
\description{
A function to reopen and resume writing to a log file that has been suspended.
}
\examples{
library(logr)

# Create temp file location
tmp <- file.path(tempdir(), "test.log")

# Open log
lf <- log_open(tmp)

# Send message to log
log_print("Before suspend")

# Suspend log
log_suspend()

# View suspended log
writeLines(readLines(lf))

# Resume log
log_resume(lf)

# Print data to log
log_print("After suspend")

# Close log
log_close()

# View results
writeLines(readLines(lf))
}
\seealso{
\code{\link{log_suspend}} for suspending the log,
and \code{\link{log_close}} to close the log.
}
