% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logistf.mod.control.R
\encoding{UTF-8}
\name{logistf.mod.control}
\alias{logistf.mod.control}
\title{Controls additional parameters for \code{logistf}}
\usage{
logistf.mod.control(tau = 0.5, terms.fit = NULL)
}
\arguments{
\item{tau}{Penalization parameter (default = 0.5)}

\item{terms.fit}{A numeric vector of terms to fit. Intercept has to be included if needed.}
}
\value{
\item{tau}{Penalization parameter (default = 0.5)}
\item{terms.fit}{A numeric vector of terms to fit. Intercept has to be included if needed.}
}
\description{
Sets parameters for \code{logistf} calls.
}
\examples{
data(sexagg)
fit2<-logistf(case ~ age+oc+vic+vicl+vis+dia, data=sexagg, weights=COUNT, 
modcontrol=logistf.mod.control(terms.fit=c(1,2)))
summary(fit2)

}
