% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loggit.R
\name{loggit_dots}
\alias{loggit_dots}
\title{Internal logging function for custom log fields}
\usage{
loggit_dots(log_lvl, log_msg, ..., echo, logfile = get_logfile())
}
\arguments{
\item{log_lvl}{Log level. A atomic vector of length one (usually \code{character}). Will be coerced to \code{character}.}

\item{log_msg}{Log message. A atomic vector of length one (usually \code{character}). Will be coerced to \code{character}.}

\item{...}{Named arguments, each a atomic vector of length one, you wish to log. Will be coerced to \code{character}.
The names of the arguments are treated as column names in the log.}

\item{echo}{Should the log entry (json) be echoed to \code{stdout} as well?}

\item{logfile}{A \code{connection}, or a character string naming the file to write to.}
}
\value{
Invisible \code{NULL}.
}
\description{
This function is used internally by the \code{loggit} function to log messages, levels, and custom fields.
Similar to \code{loggit_internal}, but with additional custom fields, and checks on those fields.
}
\keyword{internal}
