\name{crit}
\alias{crit}
\title{
Compute critical values for confidence intervals.
}
\usage{
crit(fit, const = c(0, 1), d = 1, cov = 0.95, rdf = 0)
}
\arguments{
\item{fit}{
  \code{"locfit"} object. This is optional; if a fit is provided, defaults
  for the other arguments are taken from the critical value currently
  stored on this fit, rather than the usual values above.
  \code{crit(fit)} with no other arguments will just return the current
  critical value.
}
\item{const}{
  Tube formula constants for simultaneous bands (the default, \code{c(0,1)},
  produces pointwise coverage). Usually this is generated by the
  \code{\link{kappa0}} function and should not be provided by the user.
}
\item{d}{
  Dimension of the fit. Again, users shouldn't usually provide it.
}
\item{cov}{
Coverage Probability for critical values.
}
\item{rdf}{
  Residual degrees of freedom. If non-zero, the critical values are based
  on the Student's t distribution. When \code{rdf=0}, the normal distribution
  is used.
}
}
\description{
  Every \code{"locfit"} object contains a critical value object to be used in
  computing and ploting confidence intervals. By default, a 95% pointwise
  confidence level is used. To change the confidence level, the critical
  value object must be substituted using \code{\link{crit}} and
  \code{\link{crit<-}}.
}
\value{
  Critical value object.
}
\seealso{
\code{\link{locfit}}, \code{\link{plot.locfit}},
\code{\link{kappa0}}, \code{\link{crit<-}}.
}
\examples{
# compute and plot 99\% confidence intervals, with local variance estimate.
data(ethanol)
fit <- locfit(NOx~E,data=ethanol)
crit(fit) <- crit(fit,cov=0.99)
plot(fit,band="local")

# compute and plot 99\% simultaneous bands
crit(fit) <- kappa0(NOx~E,data=ethanol,cov=0.99)
plot(fit,band="local")
}
\keyword{smooth}
% Converted by Sd2Rd version 0.2-a5.
