% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/locStra.r
\name{grMatrix}
\alias{grMatrix}
\title{C++ implementation to compute the genomic relationship matrix (grm) for a (sparse) input matrix as defined in Yang et al. (2011).}
\usage{
grMatrix(m, useCpp = TRUE, sparse = TRUE, robust = TRUE)
}
\arguments{
\item{m}{A (sparse) matrix for which the genomic relationship matrix is sought. The input matrix is assumed to be oriented to contain the data for one individual per column.}

\item{useCpp}{Flag to switch between R or C++ implementations. Default is \code{useCpp=TRUE}.}

\item{sparse}{Flag to switch between purpose-built dense or sparse implementations. Default is \code{sparse=TRUE}.}

\item{robust}{Flag to indicate if the classic (\code{robust=FALSE}) or robust (\code{robust=TRUE}) version of the genomic relationship matrix is desired. Default is \code{robust=TRUE}.}
}
\value{
The genomic relationship matrix of \code{m}.
}
\description{
C++ implementation to compute the genomic relationship matrix (grm) for a (sparse) input matrix as defined in Yang et al. (2011).
}
\examples{
require(locStra)
require(Matrix)
m <- matrix(sample(0:1,15,replace=TRUE),ncol=3)
sparseM <- Matrix(m,sparse=TRUE)
print(grMatrix(sparseM))

}
\references{
Yang J, Lee SH, Goddard ME, Visscher PM (2011). GCTA: a tool for genome-wide complex trait analysis. Am J Hum Genet, 88(1):76-82.
}
