\name{parTLgld}
\alias{parTLgld}
\title{Estimate the Parameters of the Generalized Lambda Distribution using Trimmed L-moments (t=1)}
\description{
This function estimates the parameters of the Generalized Lambda distribution given
the trimmed L-moments (TL-moments) for \eqn{t=1} of the data in a TL-moment object with a trim
level of unity (\code{trim=1}). The relation between distribution parameters and TL-moments
is seen under \code{lmomTLgld}. There are no simple expressions for the parameters in terms of the L-moments. This function is considered EXPERIMENTAL and general details of the algorithm are provided below. Further, consider that multiple parameter solutions are possible with the Generalized Lambda so some expertise in the distribution and other aspects are needed.
}
\usage{
parTLgld(lmom,result='best',verbose=FALSE,extract=0,initkh=NULL)
}
\arguments{
  \item{lmom}{A TL-moment object created by \code{\link{TLmoms}}.}
  \item{result}{If \code{best}, then the minimum error solution is returned. If \code{dataframe}, then \code{data.frame} is returned with sequence of valid solutions sorted in ascending error order.}
  \item{verbose}{A logical switch on the verbosity of output.  Default is \code{verbose=FALSE}.}
  \item{extract}{If \code{result=dataframe} and \code{extract} greater than zero, then the \code{extract=n} returns the \code{n}th element of the \code{data.frame} as if that element was the \code{best} solution.}
  \item{initkh}{A vector of the initial guess of the \eqn{\kappa} and \eqn{h} parameters. No other regions of parameter space are consulted.}
}
\details{
Karian and Dudewicz (2000) summarize six regions of the \eqn{\kappa} and \eqn{h} space in
which the Generalized Lambda distribution is valid for suitably choosen \eqn{\alpha}. Numerical experimentation suggestions that the L-moments are not valid in Regions 1 and 2. However, initial guesses of the parameters within each region are used numerous six separate \code{optim} (the R function) efforts to perform a least sum-of-square errors on the following objective function.

 \deqn{(\hat{\tau}^{(1)}_3 - \tilde{\tau}^{(1)}_3)^2 + (\hat{\tau}^{(1)}_4 - \tilde{\tau}^{(1)}_4)^2 \mbox{, }}

where \eqn{\tilde{\tau}^{(1)}_r} is the L-moment ratio of the data, \eqn{\hat{\tau}^{(1)}_r} is the estimated value of the TL-moment ratio for the current pairing of \eqn{\kappa} and
\eqn{h} and \eqn{\tau^{(1)}_r} is the actual value of the L-moment ratio.

For each optimization a check on the validity of the parameters so produced is made--are the parameters consistent with the Generalized Lambda distribution and a second check is made on the validity of \eqn{\tau^{(1)}_3} and \eqn{\tau^{(1)}_4}. If both validity checks return \code{TRUE} then the optimization is retained if its sum-of-square error is less than the previous optimum value. It is possible for a given solution to be found outside the starting region of the initial guesses. The surface generated by the \eqn{\tau^{(1)}_3} and \eqn{\tau^{(1)}_4} equations seen in \code{\link{lmomTLgld}} is complex--different initial guesses within a given region can yield what appear to be radically different \eqn{\kappa} and \eqn{h}. Users are encouraged to \dQuote{play} with alternative solutions (see the \code{verbose} argument). A quick double check on the L-moments (not TL-moments) from the solved parameters using \code{\link{lmomTLgld}} is encouraged as well.
}
\value{
  An R \code{list} is returned if \code{result='best'}.

  \item{type}{The type of distribution: \code{gld}.}
  \item{para}{The parameters of the distribution.}
  \item{error}{Smallest sum of square error found.}
  \item{tau5diff}{Difference between true \eqn{\hat{\tau}^{(1)}_5} and the \eqn{\tilde{\tau}^{(1)}_5} of the fitted distribution.}
  \item{source}{The source of the parameters--\dQuote{pargld}.}

  An R \code{data.frame} is returned if \code{result='dataframe'}, which is sorted by ascending error.
  
  \item{attempt}{The attempt number that found valid TL-moments and parameters of GLD.}
  \item{x}{The location parameter of the distribution.}
  \item{a}{The scale parameter of the distribution.}
  \item{k}{The 1st shape parameter of the distribution.}
  \item{h}{The 2nd shape parameter of the distribution.}
  \item{tau5_diff}{The absolute difference between \eqn{\hat{\tau}^{(1)}_5} of data to \eqn{\tilde{\tau}^{(1)}_5} of the fitted distribution.}  
  \item{error}{The sum of square error found.}
  \item{initial_k}{The starting point of the \eqn{\kappa} parameter.}
  \item{initial_h}{The starting point of the \eqn{h} parameter.}
}
\note{
Although the underlying derivations of the TL-moments in terms of the parameters are sound and this function uses built-in functions of R for the optimization, this function should be considered experimental until further notice. The \dQuote{preferred} solution might not be appropriate. This function is not for production code. This is a cumbersome method of parameter solution and enhancements or total redesign of the algorithm is expected.
}
\source{
R hacking by W.H. Asquith in February 2006 with copy of Karian and Dudewicz (2000).
}
\references{
Karian, Z.A., and Dudewicz, E.J., 2000, Fitting statistical distributions---The generalized lambda distribution and generalized bootstrap methods: 
CRC Press, Boca Raton, FL, 438 p.
}
\author{ W.H. Asquith}
\seealso{\code{\link{TLmoms}}, \code{\link{lmomTLgld}}, \code{\link{cdfgld}}, \code{\link{quagld}},
\code{\link{pargld}}
}
\examples{
TL1 <- TLmoms(rnorm(200),trim=1)
p <- parTLgld(TL1)
TL2 <- lmomTLgld(p)
}
\keyword{distribution}
