% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcmc.R
\name{mcmc}
\alias{mcmc}
\title{MCMC inference for LMLS}
\usage{
mcmc(m, num_samples = 1000, num_warmup = 1000, target_accept = 0.8)
}
\arguments{
\item{m}{A location-scale regression model from the \code{\link[=lmls]{lmls()}} function.}

\item{num_samples}{The number of MCMC samples after the warm-up.
Defaults to 1000.}

\item{num_warmup}{The number of MCMC samples for the warm-up.
Defaults to 1000.}

\item{target_accept}{The target acceptance rate for the dual averaging
algorithm used for the warm-up. Defaults to 0.8.}
}
\value{
An \code{lmls} S3 object, see \code{\link[=lmls]{lmls()}}. The entry \code{mcmc} with the matrices
of MCMC samples is added to the object as a list with the names \code{location}
and \code{scale}.
}
\description{
A Markov chain Monte Carlo (MCMC) sampler for location-scale regression
models from the \code{\link[=lmls]{lmls()}} function. The sampler uses Gibbs updates for the
location coefficients and the Riemann manifold Metropolis-adjusted Langevin
algorithm (MMALA) from Girolami and Calderhead (2011) with the Fisher-Rao
metric tensor for the scale coefficients. The priors for the regression
coefficients are assumed to be flat.

To find the optimal step size for the MMALA updates, the dual averaging
algorithm from Nesterov (2009) is used during a warm-up phase.
}
\examples{
library(lmls)
m <- lmls(y ~ poly(x, 2), ~ x, data = abdom, light = FALSE)
m <- mcmc(m)
summary(m, type = "mcmc")
plot(m$mcmc$scale[, 2], type = "l")
}
\references{
Girolami, M. and Calderhead, B. (2011), Riemann manifold Langevin and
Hamiltonian Monte Carlo methods. Journal of the Royal Statistical Society:
Series B (Statistical Methodology), 73: 123-214.
\doi{10.1111/j.1467-9868.2010.00765.x}

Nesterov, Y. (2009), Primal-dual subgradient methods for convex problems.
Mathematical Programming, 120: 221–259. \doi{10.1007/s10107-007-0149-x}
}
