% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/site.R
\name{fuse_site}
\alias{fuse_site}
\title{Fuse R Markdown documents individually under a directory}
\usage{
fuse_site(input = ".")
}
\arguments{
\item{input}{The root directory of the site, or a vector of input file paths.}
}
\value{
Output file paths (invisibly).
}
\description{
Run \code{\link[=fuse]{fuse()}} on R Markdown documents individually to generate a website.
}
\details{
If a directory contains a config file \verb{_litedown.yml}, which has a YAML field
\code{site}, the directory will be recognized as a site root directory. The YAML
field \code{output} will be applied to all R Markdown files (an individual R
Markdown file can provide its own \code{output} field in YAML to override the
global config). For example:

\if{html}{\out{<div class="sourceCode yaml">}}\preformatted{---
site:
  rebuild: "outdated"
  pattern: "[.]R?md$"
output:
  html:
    meta:
      css: ["@default"]
      include_before: "[Home](/) [About](/about.html)"
      include_after: "&copy; 2024 | [Edit]($input$)"
---
}\if{html}{\out{</div>}}

The option \code{rebuild} determines whether to rebuild \code{.Rmd} files. Possible
values are:
\itemize{
\item \code{newfile}: Build an input file if it does not have a \code{.html} output file.
\item \code{outdated}: Rebuild an input file if the modification time of its \code{.html}
output file is newer than the input.
}
}
