% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expect_comparison_linter.R
\name{expect_comparison_linter}
\alias{expect_comparison_linter}
\title{Require usage of \code{expect_gt(x, y)} over \code{expect_true(x > y)} (and similar)}
\usage{
expect_comparison_linter()
}
\description{
\code{\link[testthat:comparison-expectations]{testthat::expect_gt()}}, \code{\link[testthat:comparison-expectations]{testthat::expect_gte()}}, \code{\link[testthat:comparison-expectations]{testthat::expect_lt()}},
\code{\link[testthat:comparison-expectations]{testthat::expect_lte()}}, and \code{\link[testthat:equality-expectations]{testthat::expect_equal()}} exist specifically
for testing comparisons between two objects. \code{\link[testthat:logical-expectations]{testthat::expect_true()}} can
also be used for such tests, but it is better to use the tailored function
instead.
}
\examples{
# will produce lints
lint(
  text = "expect_true(x > y)",
  linters = expect_comparison_linter()
)

lint(
  text = "expect_true(x <= y)",
  linters = expect_comparison_linter()
)

lint(
  text = "expect_true(x == (y == 2))",
  linters = expect_comparison_linter()
)

# okay
lint(
  text = "expect_gt(x, y)",
  linters = expect_comparison_linter()
)

lint(
  text = "expect_lte(x, y)",
  linters = expect_comparison_linter()
)

lint(
  text = "expect_identical(x, y == 2)",
  linters = expect_comparison_linter()
)

lint(
  text = "expect_true(x < y | x > y^2)",
  linters = expect_comparison_linter()
)

}
\seealso{
\link{linters} for a complete list of linters available in lintr.
}
\section{Tags}{
\link[=best_practices_linters]{best_practices}, \link[=package_development_linters]{package_development}
}
