% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/infix_spaces_linter.R
\name{infix_spaces_linter}
\alias{infix_spaces_linter}
\title{Infix spaces linter}
\usage{
infix_spaces_linter(exclude_operators = NULL, allow_multiple_spaces = TRUE)
}
\arguments{
\item{exclude_operators}{Character vector of operators to exlude from consideration for linting.
Default is to include the following "low-precedence" operators:
\code{+}, \code{-}, \code{~}, \code{>}, \code{>=}, \code{<}, \code{<=}, \code{==}, \code{!=}, \code{&}, \code{&&}, \code{|}, \code{||}, \verb{<-}, \verb{:=}, \verb{<<-}, \verb{->}, \verb{->>},
\code{=}, \code{/}, \code{*}, and any infix operator (exclude infixes by passing \code{"\%\%"}). Note that \verb{<-}, \verb{:=}, and \verb{<<-}
are included/excluded as a group (indicated by passing \code{"<-"}), as are \verb{->} and \verb{->>} (\emph{viz}, \code{"->"}),
and that \code{=} for assignment and for setting arguments in calls are treated the same.}

\item{allow_multiple_spaces}{Logical, default \code{TRUE}. If \code{FALSE}, usage like \code{x  =  2} will also be linted;
excluded by default because such usage can sometimes be used for better code alignment, as is allowed
by the style guide.}
}
\description{
Check that infix operators are surrounded by spaces. Enforces the corresponding Tidyverse style guide rule;
see \url{https://style.tidyverse.org/syntax.html#infix-operators}.
}
\seealso{
\link{linters} for a complete list of linters available in lintr. \cr
\url{https://style.tidyverse.org/syntax.html#infix-operators}
}
\section{Tags}{
\link[=default_linters]{default}, \link[=readability_linters]{readability}, \link[=style_linters]{style}
}
