% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parseOTB.R
\name{parseOTBFunction}
\alias{parseOTBFunction}
\title{Get OTB function argument list}
\usage{
parseOTBFunction(algo = NULL, gili = NULL)
}
\arguments{
\item{algo}{either the number or the plain name of the `OTB` algorithm that is wanted. Note the correct (of current/choosen version) information is probided by `parseOTBAlgorithms()`}

\item{gili}{optional list of avalailable `OTB` binaries if not provided `linkOTB()` is called}
}
\description{
retrieve the choosen function and returns a full argument list with the default settings
}
\examples{
\dontrun{
otbLink<-link2GI::linkOTB()
if (otbLink$exist) {

## parse all modules
algos<-parseOTBAlgorithms(gili = otbLink)


## take edge detection
cmdList<-parseOTBFunction(algo = algos[27],gili = otbLink)
## print the current command
print(cmdList)
}
}
##+##
}
