% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear.tools.R
\name{get_x_all}
\alias{get_x_all}
\title{a unique combinations of model vars, coeff vars and raw vars}
\usage{
get_x_all(model, data = NULL)
}
\arguments{
\item{model}{\code{lm} or \code{glm}}

\item{data}{NULL (default) or data.frame, a new dataset to evaluate the categorical variables.
If NULL, then use the data used in model itself.}
}
\value{
a data.frame, a unique combinations of model vars, coeff vars and raw vars
See \code{\link{get_x}} for the meaning of \code{model var}, \code{coeff var} or \code{raw var}.


The column \code{'n_raw_in_model'} is a numeric field showing how many raw variables are in the corresponding model variables.
For example, the model variable 'I(carat*table)' contains two raw variables: 'carat' and 'table'. See example code for details.
}
\description{
a unique combinations of model vars, coeff vars and raw vars
}
\details{
For the differences between raw var, model var, and coeff var: see \code{\link{get_x}}
}
\examples{

get_x_all(model = price~  I(carat^   2) + cut  + I(carat*table),data = ggplot2::diamonds)


#________ irregular formulas
model_dirty = lm(price~  I(carat^   2) + cut  - carat:table - cut ,ggplot2::diamonds)
test = get_x_all(model_dirty)

test
test$coeff
# ______  errors _______________

tryCatch(get_x_all(model = price~  I(carat^   2) + cut  + I(carat*table)),
         error = function(x){
           print(x)
         })

}

