% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear.tools.R
\name{get_y}
\alias{get_y}
\title{get y (right hand of var)}
\usage{
get_y(Formula, method = c("raw", "model", "coeff"))
}
\arguments{
\item{Formula}{a formula to be paste.}

\item{method}{either \code{'raw','model'}, or \code{'coeff'}, to decide what kind variables to show.
Default is 'raw'. See section Detials below.}
}
\value{
y in formula
}
\description{
get y (right hand of var)
}
\details{
What do 'raw' variable, 'model' variable, and 'coeff' variable mean?

\itemize{
\item raw var is the underlying variable without any calculation or transformation.
\item model var is the underlying variable with calculations or transformation.
\item coeff var is the coefficient variable in the model output. So only evaluated model has coeff var.
}

In the formula, \code{log(y) ~ x1 + x2}, we have:
'raw' variable for \code{y}: \code{y}
'model' variable for \code{y}: \code{log(y)}
'coeff' variable for \code{y}: \code{log(y)}

More examples see the sample code below.
}
\examples{

get_y(log(price) ~sdfsf + dsa )
get_y(log(price) ~ sdfsf + dsa, method = "model")
get_y(log(price) ~ sdfsf + dsa, method = "coeff") # same as model var in the get_y() case

# can deal with un-regular formula
get_y(log(price) ~sdfsf + dsa ~ dsad)
get_y(log(price) ~ sdfsf + dsa ~ dsad, method = "coeff")
get_y(log(price) ~ sdfsf + dsa ~ dsad, method = "model")

model_dirty = model = lm(price~  I(carat^   2) + cut  - carat:table - cut ,ggplot2::diamonds)
get_y(model_dirty)

}

