% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear.tools.R
\name{effect}
\alias{effect}
\title{evaluate the marginal effects of the selected raw variable on the dependent.}
\usage{
effect(model, data = NULL, focus_var_raw, focus_var_coeff = NULL,
  focus_var_model = NULL, focus_value = NULL, nonfocus_value = NULL,
  transform_y = NULL, PRINT = TRUE, PLOT = TRUE, Reverse = FALSE,
  bar_plot = NULL, intolerance_on_wrong_names = FALSE)
}
\arguments{
\item{model}{an output of lm or glm}

\item{data}{NULL (default) or a data.frame, a new dataset to evaluate the categorical variables.
If NULL, then use the data used in model itself.}

\item{focus_var_raw}{NULL or a character vector with maximum length of 2, in which you can choose \code{raw vars} you want to focus.
See \code{\link{get_x}} for the meaning of \code{raw var}.

\itemize{
\item If there is only one raw var in the vector \code{focus_var_raw}, then we will check the marginal impact of that raw var.
\item If there is only two raw vars in the vector \code{focus_var_raw}, then we
will check the marginal impact of the FIRST raw var (\code{focus_var_raw[1]}) under different values of SECOND raw var (\code{focus_var_raw[2]}).
}

See the example code for details.}

\item{focus_var_coeff}{NULL or a character vector. Must be \code{coeff vars} containing \code{focus_var_raw[1]}.
See \code{\link{get_x}} for the meaning of \code{coeff var}.
After you set up the \code{focus_var_raw}, you can also choose to focus on effects of \code{focus_var_raw[1]} through only certain coeff vars,
then all other unspecified coeff vars related \code{focus_var_raw[1]} will have coeff 0
by default, focus_var_coeff is null, which means we will check effect of \code{focus_var_raw[1]} on all coeff vars.

See the example code for details.}

\item{focus_var_model}{NULL or a character vector. Must be model vars containing \code{focus_var_raw[1]}.
See \code{\link{get_x}} for the meaning of \code{model var}.
Similar use as argument \code{focus_var_coeff}, except here you can specify which model vars you want to focus.

See the example code for details.}

\item{focus_value}{NULL or a list; each element of the list must have names in focus_var_raw.
By default, we will check marginal effects of \code{focus_var_raw[1]} through \code{seq(0.05,0.95,by = 0.05)} quantiles of its values in the modelling data.
But you can also specify the values you want to check here. See the sample code.}

\item{nonfocus_value}{NULL or a list; each element of the list must have names in non-focused raw vars (not show up in \code{focus_var_raw})
The meaning of non-focus var is: When we check the marginal effect of focus var on dependent, we let the focus var vary and fix the non-focus vars.
By default, for non-focused raw vars, we assume their values are fixed at mean (if numeric) or mode (if factor or character) in the modelling data.
But you can also specify the fixed values you want. See the sample code.}

\item{transform_y}{NULL or a function, used only for plot. Used as a function to recalculate y (a function on y (ex. log(y) )).}

\item{PRINT}{a boolean, whether to print messages AND to plot.}

\item{PLOT}{a bookean, whether to plot}

\item{Reverse}{a boolean,  whether to use reverse order in x-axis when plot. Default is FALSE.}

\item{bar_plot}{NULL or a boolean, choose bar plot or line plot. If NULL, we will choose automatically.}

\item{intolerance_on_wrong_names}{a boolean. If a name is wrong, either in focus_var_raw, focus_var_model, focus_var_coeff,
focus_value or nonfocus_value, whether we delete the wrong names and go on (default), or report an error.}
}
\value{
a list:
\itemize{
\item Focus_values: show the values of focus_var_raw we used to evaluate the marginal effects.
\item data_and_predict: full dataset used to evaluate the marginal effects.
\item summmary_glm: a summary of lm or glm model.
\item Monoton_Increase: whether the marginal impact is Monotonic Increase.
\item Monoton_Decrease: whether the marginal impact is Monotonic Decrease.
}
}
\description{
evaluate the marginal effects of the selected raw variable on the dependent.
}
\details{
This function will evaluate marginal impacts and show the monotonicity of marginal impacts of
a selected variable on the dependent.

Note that the marginal impacts is not simply the sign of coeff: In a model like \code{y~ x + x^2 + p + q},
marginal impacts of \code{x} on \code{y} requires an evaluation of both \code{x} and \code{x^2} at the same time.

Here the \code{focus_var_raw} is \code{x}, \code{focus_var_coeff} are \code{x} and \code{x^2}
\code{nonfocus_value} is \code{p} and \code{q}

Also the monotonicity of marginal impacts of \code{x} will be different for different range of \code{x}'s values.

Another interesting case is when \code{x} is interacting with other variables, then its marginal impacts will also
be dependent on the values of those interacted variables.

Level of marginal impacts: To make the level of marginal impacts of \code{x} realistic, by default we fixed all other right-hand-side variables
fixed at their mean (numeric) or mode (character or factor). You can also provide fixed values for them.
Also by default we let the interested variable (focused raw var) \code{x} to vary between its \code{seq(0.05,0.95,by = 0.05)} quantiles.

This function will take care those cases above and make evaluating marginal impacts easier.
}
\examples{

##___ unit test ____

# __________________  One Dimension: the most basic case ____________________

data_used = ggplot2::diamonds
diamond_lm3 = lm(price~ cut + carat + I(carat^2) +
                   I(carat^3) + I(carat  * depth) + cut:depth, data_used) # a GLM

# more carats, higher price.
effect(model = diamond_lm3,
       data = ggplot2::diamonds,
       focus_var_raw = c('carat'),
       Reverse = TRUE) # value in x-axis is reverse


# Deal with dirty formulas

diamond_lm_dirty = lm(price~ cut + carat- cut, data_used) # a GLM
# more carats, higher price.
effect(model = diamond_lm_dirty,
       data = ggplot2::diamonds,
       focus_var_raw = c('carat'),
       Reverse = TRUE) # value in x-axis is reverse




# focus on only 'I(carat^3)', which means we will make all other coeff,
# including 'carat' and 'I(carat^2)' into 0
effect(model = diamond_lm3,
       data = ggplot2::diamonds,
       focus_var_raw =c('carat'),
       focus_var_coeff = 'I(carat^3)')
# __________________  One Dimension: Categorical ____________________

# selected model-var to focus: here not focus on cut:depth, only focus on cut
effect(model = diamond_lm3,
       data = ggplot2::diamonds,
       focus_var_raw = c('cut'),
       focus_var_model = 'cut')

# selected model-var to focus: here not focus on cut:depth, only focus on cut
effect(model = diamond_lm3,
       data = ggplot2::diamonds,
       focus_var_raw = c('cut'),
       focus_var_model = 'cut:depth')

# __________________  Double Dimensions ____________________

# here focus_var_raw has two values: "carat" and "cut"
# that means we will evaluate impact of "carat" on "price" through different value of "cut"

effect(model = diamond_lm3,data = ggplot2::diamonds, focus_var_raw=c('carat',"cut"))


# other examples
effect(model = diamond_lm3,data = ggplot2::diamonds, focus_var_raw=c('carat',"depth"))
effect(model = diamond_lm3,data = ggplot2::diamonds, focus_var_raw=c("cut","carat"))


# __________________  Provide Values to Focused vars  ____________________

# when evaluating impacts,
# we can provide the range of values for key variables

effect(model = diamond_lm3,data = ggplot2::diamonds,
       focus_var_raw = c('carat',"cut"),
       focus_value = list(carat=seq(0.5,6,0.1)))

effect(model = diamond_lm3,data = ggplot2::diamonds,
       focus_var_raw = c('carat',"cut"),
       focus_value = list(carat=seq(0.5,6,0.1)))



effect(model = diamond_lm3,data = ggplot2::diamonds,
       focus_var_raw=c('carat',"cut"),
       focus_value = list(carat=seq(0.5,6,0.1),
                          cut = c('Ideal','Premium')
       ))

# __________________  Provide Values to Non-focus vars  ____________________

effect(model = diamond_lm3,data = ggplot2::diamonds,
       focus_var_raw=c('carat',"cut"),
       nonfocus_value = list(depth = 75) # Provide Values to Non-focus vars
)
# if non-key value not provided, the non-key value would be mean or mode,
# in this case: depth's mean is 61.7494
effect(model = diamond_lm3,data = ggplot2::diamonds,
       focus_var_raw=c('carat',"cut"))


# __________________  Provide Wrong Names  ____________________


effect(model = diamond_lm3,data = ggplot2::diamonds,
       focus_var_raw=c('carat','WRONGNAME'), # Provide Values to Non-focus vars
       nonfocus_value = list(depth = 75)
)


effect(model = diamond_lm3,data = ggplot2::diamonds,
       focus_var_raw=c('carat',"cut"),
       focus_value = list(WRONGNAME=seq(0.5,6,0.1),
                          WRONGNAME2 = c('Ideal','Premium')
       ))

}

