% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_run.R
\name{apply_normalisation}
\alias{apply_normalisation}
\title{apply_normalisation}
\usage{
apply_normalisation(
  raw_data = NULL,
  pool_var = NULL,
  dv = NULL,
  verbose = FALSE
)
}
\arguments{
\item{raw_data}{\code{data.frame} containing data for analysis}

\item{pool_var}{string specifying the pool variable name (e.g. 'country')}

\item{dv}{string specifying the dependent variable name}

\item{verbose}{A boolean to specify whether to print warnings}
}
\value{
\code{list} containing a \code{tibble} of normalised data and a \code{tibble} of pool means
}
\description{
Normalise data based on pool mean
}
\details{
Normalise data by dividing all values in each pool by that pool's mean
}
\examples{
pooled_data = read_xcsv(
 verbose = FALSE,
 file = "https://raw.githubusercontent.com/paladinic/data/main/pooled\%20data.csv")

norm_data = apply_normalisation(
 raw_data = pooled_data,
 pool_var = 'country',
 dv = 'amazon')
}
