% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/charting.R
\name{response_curves}
\alias{response_curves}
\title{response_curves}
\usage{
response_curves(
  model,
  x_min = -100,
  x_max = 100,
  y_min = -100,
  y_max = 100,
  interval = 0.1,
  trans_only = FALSE,
  colors = color_palette(),
  verbose = FALSE,
  table = FALSE
)
}
\arguments{
\item{model}{Model object}

\item{x_min}{number specifying horizontal axis min}

\item{x_max}{number specifying horizontal axis max}

\item{y_min}{number specifying vertical axis min}

\item{y_max}{number specifying vertical axis max}

\item{interval}{number specifying interval between points of the curve}

\item{trans_only}{a boolean specifying whether to display non-linear only \code{y = b*dim_rest(x)}}

\item{colors}{character vector of colors in hexadecimal notation}

\item{verbose}{A boolean to specify whether to print warnings}

\item{table}{A boolean to specify whether to return a \code{data.frame} of the response curves}
}
\value{
a \code{plotly} line chart of the model's response curves
}
\description{
Line chart of variable response curves
}
\details{
Line chart of variable response curves visualising the relationship of each independent variable with the dependent variable
}
\examples{
run_model(data = mtcars,dv = 'mpg',ivs = c('wt','cyl','disp')) \%>\%
   response_curves()
run_model(data = scale(mtcars) \%>\% data.frame(),dv = 'mpg',ivs = c('wt','cyl','disp')) \%>\%
   response_curves()
}
