% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_posterior.R
\name{getPosteriorSamples}
\alias{getPosteriorSamples}
\title{Draw samples from posterior distributions of fitted models}
\usage{
getPosteriorSamples(fit, nPosteriorSamples = 200L, overwrite = FALSE)
}
\arguments{
\item{fit}{A `limorhyde2' object containing posterior fits.}

\item{nPosteriorSamples}{Number of samples to draw from each posterior
distribution.}

\item{overwrite}{Logical indicating whether to recompute posterior samples if
they already exist.}
}
\value{
A \code{limorhyde2} object containing everything in \code{fit} with added or
updated element:
\itemize{
\item \code{mashPosteriorSamples}: a three-dimensional array of coefficients, with dim
1 corresponding to features, dim 2 to model terms, and dim 3 to posterior
samples.
}
}
\description{
This is an optional step in an analysis using \code{limorhyde2}, and is useful for
quantifying uncertainty in posterior estimates of fitted curves and rhythmic
statistics. The function calls \code{\link[mashr:mash_compute_posterior_matrices]{mashr::mash_compute_posterior_matrices()}}.
}
\examples{
library('data.table')

y = GSE54650$y
metadata = GSE54650$metadata

fit = getModelFit(y, metadata)
fit = getPosteriorFit(fit)
fit = getPosteriorSamples(fit, nPosteriorSamples = 10L)

rhyStatsSamps = getRhythmStats(
  fit, features = c('13170', '13869'), fitType = 'posterior_samples')
rhyStatsInts = getStatsIntervals(rhyStatsSamps)
}
\seealso{
\code{\link[=getPosteriorFit]{getPosteriorFit()}}, \code{\link[=getRhythmStats]{getRhythmStats()}}, \code{\link[=getExpectedMeas]{getExpectedMeas()}},
\code{\link[=getStatsIntervals]{getStatsIntervals()}}
}
