% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{model_support}
\alias{model_support}
\alias{predict_model}
\alias{model_type}
\title{Methods for extending limes model support}
\usage{
predict_model(x, newdata, type, ...)

model_type(x, ...)
}
\arguments{
\item{x}{A model object}

\item{newdata}{The new observations to predict}

\item{type}{Either \code{'raw'} to indicate predicted values, or \code{'prob'} to
indicate class probabilities}

\item{...}{passed on to \code{predict} method}
}
\value{
A data.frame in the case of \code{predict_model()}. If \code{type = 'raw'} it
will contain one column named \code{'Response'} holding the predicted values. If
\code{type = 'prob'} it will contain a column for each of the possible classes
named after the class, each column holding the probability score for class
membership. For \code{model_type()} a character string. Either \code{'regression'} or
\code{'classification'} is currently supported.
}
\description{
In order to have \code{lime} support for your model of choice \code{lime} needs to be
able to get predictions from the model in a standardised way, and it needs to
be able to know whether it is a classification or regression model. For the
former it calls the \code{predict_model()} generic which the user is free to
supply methods for without overriding the standard \code{predict()} method. For
the latter the model must respond to the \code{model_type()} generic. Out of the
box \code{lime} supports models from \code{caret} and \code{mlr} as well as \code{xgboost}. See
the details for how to provide compliant methods for other models.
}
\examples{
# Example of adding support for lda models (already available in lime)
predict_model.lda <- function(x, newdata, type, ...) {
  res <- predict(x, newdata = newdata, ...)
  switch(
    type,
    raw = data.frame(Response = res$class, stringsAsFactors = FALSE),
    prob = as.data.frame(res$posterior, check.names = FALSE)
  )
}

model_type.lda <- function(x, ...) 'classification'

}
