% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coregistration.R
\name{circle2Raster}
\alias{circle2Raster}
\title{Raster corresponding to circle extent}
\usage{
circle2Raster(X, Y, radius, resolution = 0.5, buffer = 0.5, ...)
}
\arguments{
\item{X}{numeric. easting coordinate of plot center in meters}

\item{Y}{numeric. northing coordinate of plot center in meters}

\item{radius}{numeric. plot radius in meters}

\item{resolution}{numeric. raster resolution in meters}

\item{buffer}{numeric. buffer to be added to plot radius in meters}

\item{...}{other parameters to pass to \code{\link[terra]{rast}} (e.g. crs)}
}
\value{
A SpatRaster object
}
\description{
Creates an empty raster which extents corresponds to the circle specified by 
center coordinates, radius and optional buffer size.
}
\examples{
circle2Raster(100, 100, 20, 1, 5)
}
