% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/common.R
\name{ellipses4Crown}
\alias{ellipses4Crown}
\title{Create elliptical polygons from centres and extensions in four directions}
\usage{
ellipses4Crown(x, y, n, s, e, w, id = NULL, step = pi/12, angle.offset = 0)
}
\arguments{
\item{x, y}{vectors of numerics. Coordinates of ellipses centers}

\item{n, s, e, w}{vectors of numerics. Coordinates of ellipses extention in the north, south, east and west directions}

\item{id}{vector of strings. id of each polygon}

\item{step}{numeric. Angular step for the modelling of ellipses}

\item{angle.offset}{numeric. Angle offset to tilt ellipses, positive values rotates clockwise}
}
\value{
a list of data.frame containing the coordinates of polygons
}
\description{
creates polygons from the union of four quarters of ellipses, specified by the ellipse center, and maximum extension in two directions
}
\examples{
# compute coordinates of ellipses
ellipses1 <- ellipses4Crown(c(0,10), c(0,10), c(2,2), c(3,4), c(2.5,3), c(2,3),
                            id=c("A", "B"))
ellipses1[["A"]]
# tilted ellipse
ellipses2 <- ellipses4Crown(c(0,10), c(0,10), c(2,2), c(3,4), c(2.5,3), c(2,3),
                            angle.offset=pi/6)
ellipses2[[2]]

# draw ellipses in black, tilted ellipses in red
plot(ellipses1[[1]],type="l", asp=1, xlim=c(-5,15), ylim=c(-5,15))
lines(ellipses1[[2]])
lines(ellipses2[[1]], col="red")
lines(ellipses2[[2]], col="red")
}
\seealso{
\code{\link{pointList2SPDF}}
}
