% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{stdTreeMetrics}
\alias{stdTreeMetrics}
\title{Computation of tree metrics}
\usage{
stdTreeMetrics(x, area.ha = NA)
}
\arguments{
\item{x}{data.frame containing the following columns for each line (segmented tree): \code{h} (height), \code{s} (crown surface), \code{v} (crown volume), typically returned by \code{\link{treeExtraction}}. \code{sp} (crown surface inside region of interest) and \code{vp} (crown volume in region of interest) are not used in this function.}

\item{area.ha}{numeric. area of region of interest in ha}
}
\value{
a data.frame with one line containing the following tree metrics:
\enumerate{
\item \code{Tree.meanH}: mean height of detected tree apices (m)
\item \code{Tree.sdH}: standard deviation of heights of detected tree apices (m)
\item \code{Tree.giniH}: Gini index of heights of detected tree apices
\item \code{Tree.density}: density of detected tree apices (/ha)
\item \code{TreeInf10.density}: density of detected trees apices with h<=10 (/ha)
\item \code{TreeSup10.density}: density of detected trees apices with h>10 (/ha)
\item \code{TreeSup20.density}: density of detected trees apices with h>20 (/ha)
\item \code{TreeSup30.density}: density of detected trees apices with h>30 (/ha)
\item \code{Tree.meanCrownSurface}: mean crown surface of detected trees
\item \code{Tree.meanCrownVolume}: mean volume of detected trees
\item \code{TreeCanopy.meanH}: mean height of union of crowns of detected trees
}
}
\description{
This function computes summary statistics from a data.frame containing tree-level information as returned by \code{\link{treeExtraction}}.
}
\examples{
# sample 50 height values
h <- runif(50, 5, 40)
# simulate tree data.frame
trees <- data.frame(h=h, s=h, sp=h*0.95, v=h*h*0.6, vp=h*h*0.55)
stdTreeMetrics(trees, area.ha=0.1)
}
\seealso{
\code{\link{treeExtraction}}
}
