% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree.detection.R
\name{cimg2Raster}
\alias{cimg2Raster}
\title{Cimg to RasterLayer conversion}
\usage{
cimg2Raster(cimg, rasterLayer = NULL)
}
\arguments{
\item{cimg}{raster object. raster of canopy height model, preferably filtered to avoid effect of holes on volume and surface computation}

\item{rasterLayer}{raster object. defines the extent and projection of conversion result}
}
\value{
A RasterLayer
}
\description{
converts a cimg object to a RasterLayer object
}
\examples{
data(chmchablais3)

# convert rasterLayer to cimg object
chm.cim <- raster2Cimg(chmchablais3)

# apply filtering
chm.cim.filt <- demFiltering(chm.cim,
                             nlFilter = "Closing",
                             nlSize = 3,
                             sigmap = 0)$non.linear.image

# convert to RasterLayer
chm.filt <- cimg2Raster(chm.cim.filt, chmchablais3)

# plot rasterLayer
raster::plot(chmchablais3)

# plot cimg object
plot(chm.cim)

# plot filtered cimg object
plot(chm.cim.filt)

# plot filtered rasterLayer
raster::plot(chm.filt)
}
\seealso{
\code{\link{raster2Cimg}}
}
