/* libsoc - Library to handle standardised output files
 * Copyright (C) 2015 Rikard Nordgren
 * 
 * This file was autogenerated and should not be edited
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 * 
 * his library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, see <http://www.gnu.org/licenses/>.
 */

#include <R.h>
#include <Rdefines.h>
#include <so.h>
#include "soc.h"

SEXP r_so_Estimates_new()
{
	so_Estimates *obj = so_Estimates_new();
	if (!obj) {
		error("Failed to create so_Estimates object");
	}
	return R_MakeExternalPtr(obj, R_NilValue, R_NilValue);
}

SEXP r_so_Estimates_copy(SEXP self)
{
	so_Estimates *obj = so_Estimates_copy(R_ExternalPtrAddr(self));
	if (!obj) {
		error("Failed to copy so_Estimates object");
	}
	return R_MakeExternalPtr(obj, R_NilValue, R_NilValue);
}

SEXP r_so_Estimates_free(SEXP self)
{
	so_Estimates_free(R_ExternalPtrAddr(self));
	return R_NilValue;
}

SEXP r_so_Estimates_ref(SEXP self)
{
	so_Estimates_ref(R_ExternalPtrAddr(self));
	return R_NilValue;
}

SEXP r_so_Estimates_unref(SEXP self)
{
	so_Estimates_unref(R_ExternalPtrAddr(self));
	return R_NilValue;
}

SEXP r_so_Estimates_get_Mean(SEXP self)
{
	so_Table *child = so_Estimates_get_Mean(R_ExternalPtrAddr(self));
	SEXP result = table2df(child);
	return result;
}

SEXP r_so_Estimates_set_Mean(SEXP self, SEXP child)
{
	so_Table *table = df2table(child);
	so_Estimates_set_Mean(R_ExternalPtrAddr(self), table);
	return R_NilValue;
}

SEXP r_so_Estimates_create_Mean(SEXP self)
{
	so_Table *child = so_Estimates_create_Mean(R_ExternalPtrAddr(self));
	return R_MakeExternalPtr(child, R_NilValue, R_NilValue);
}

SEXP r_so_Estimates_get_Median(SEXP self)
{
	so_Table *child = so_Estimates_get_Median(R_ExternalPtrAddr(self));
	SEXP result = table2df(child);
	return result;
}

SEXP r_so_Estimates_set_Median(SEXP self, SEXP child)
{
	so_Table *table = df2table(child);
	so_Estimates_set_Median(R_ExternalPtrAddr(self), table);
	return R_NilValue;
}

SEXP r_so_Estimates_create_Median(SEXP self)
{
	so_Table *child = so_Estimates_create_Median(R_ExternalPtrAddr(self));
	return R_MakeExternalPtr(child, R_NilValue, R_NilValue);
}

SEXP r_so_Estimates_get_Mode(SEXP self)
{
	so_Table *child = so_Estimates_get_Mode(R_ExternalPtrAddr(self));
	SEXP result = table2df(child);
	return result;
}

SEXP r_so_Estimates_set_Mode(SEXP self, SEXP child)
{
	so_Table *table = df2table(child);
	so_Estimates_set_Mode(R_ExternalPtrAddr(self), table);
	return R_NilValue;
}

SEXP r_so_Estimates_create_Mode(SEXP self)
{
	so_Table *child = so_Estimates_create_Mode(R_ExternalPtrAddr(self));
	return R_MakeExternalPtr(child, R_NilValue, R_NilValue);
}

SEXP r_so_Estimates_get_Samples(SEXP self)
{
	so_Table *child = so_Estimates_get_Samples(R_ExternalPtrAddr(self));
	SEXP result = table2df(child);
	return result;
}

SEXP r_so_Estimates_set_Samples(SEXP self, SEXP child)
{
	so_Table *table = df2table(child);
	so_Estimates_set_Samples(R_ExternalPtrAddr(self), table);
	return R_NilValue;
}

SEXP r_so_Estimates_create_Samples(SEXP self)
{
	so_Table *child = so_Estimates_create_Samples(R_ExternalPtrAddr(self));
	return R_MakeExternalPtr(child, R_NilValue, R_NilValue);
}

