% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AppenderDigest.R
\name{AppenderMail}
\alias{AppenderMail}
\title{Abstract class for email Appenders}
\value{
Abstract classes cannot be instantiated with \verb{$new()} and therefore
do not return anything. They are solely for developers that want to write
their own extension to \strong{lgr}.
}
\description{
\strong{Abstract classes}, only exported for package developers.
}
\seealso{
Other abstract classes: 
\code{\link{AppenderDigest}}

Other Digest Appenders: 
\code{\link{AppenderDigest}},
\code{\link{AppenderPushbullet}},
\code{\link{AppenderSendmail}}
}
\concept{Digest Appenders}
\concept{abstract classes}
\section{Super classes}{
\code{\link[lgr:Filterable]{lgr::Filterable}} -> \code{\link[lgr:Appender]{lgr::Appender}} -> \code{\link[lgr:AppenderMemory]{lgr::AppenderMemory}} -> \code{\link[lgrExtra:AppenderDigest]{lgrExtra::AppenderDigest}} -> \code{AppenderMail}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{to}}{\code{character} vector. The email addresses of the recipient}

\item{\code{from}}{\code{character} vector. The email address of the sender}

\item{\code{cc}}{\code{character} vector. The email addresses of the cc-recipients (carbon copy)}

\item{\code{bcc}}{\code{character} vector. The email addresses of bcc-recipients (blind carbon copy)}

\item{\code{html}}{\code{logical} scalar.  Send a html email message?
This does currently only format the log contents as monospace verbatim
text.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{AppenderMail$new()}}
\item \href{#method-set_to}{\code{AppenderMail$set_to()}}
\item \href{#method-set_from}{\code{AppenderMail$set_from()}}
\item \href{#method-set_cc}{\code{AppenderMail$set_cc()}}
\item \href{#method-set_bcc}{\code{AppenderMail$set_bcc()}}
\item \href{#method-set_html}{\code{AppenderMail$set_html()}}
\item \href{#method-format}{\code{AppenderMail$format()}}
}
}
\if{html}{
\out{<details ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="lgr" data-topic="Filterable" data-id="add_filter">}\href{../../lgr/html/Filterable.html#method-add_filter}{\code{lgr::Filterable$add_filter()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="lgr" data-topic="Filterable" data-id="filter">}\href{../../lgr/html/Filterable.html#method-filter}{\code{lgr::Filterable$filter()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="lgr" data-topic="Filterable" data-id="remove_filter">}\href{../../lgr/html/Filterable.html#method-remove_filter}{\code{lgr::Filterable$remove_filter()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="lgr" data-topic="Filterable" data-id="set_filters">}\href{../../lgr/html/Filterable.html#method-set_filters}{\code{lgr::Filterable$set_filters()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="lgr" data-topic="Appender" data-id="set_layout">}\href{../../lgr/html/Appender.html#method-set_layout}{\code{lgr::Appender$set_layout()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="lgr" data-topic="Appender" data-id="set_threshold">}\href{../../lgr/html/Appender.html#method-set_threshold}{\code{lgr::Appender$set_threshold()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="lgr" data-topic="AppenderMemory" data-id="append">}\href{../../lgr/html/AppenderMemory.html#method-append}{\code{lgr::AppenderMemory$append()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="lgr" data-topic="AppenderMemory" data-id="clear">}\href{../../lgr/html/AppenderMemory.html#method-clear}{\code{lgr::AppenderMemory$clear()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="lgr" data-topic="AppenderMemory" data-id="flush">}\href{../../lgr/html/AppenderMemory.html#method-flush}{\code{lgr::AppenderMemory$flush()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="lgr" data-topic="AppenderMemory" data-id="set_buffer_size">}\href{../../lgr/html/AppenderMemory.html#method-set_buffer_size}{\code{lgr::AppenderMemory$set_buffer_size()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="lgr" data-topic="AppenderMemory" data-id="set_flush_on_exit">}\href{../../lgr/html/AppenderMemory.html#method-set_flush_on_exit}{\code{lgr::AppenderMemory$set_flush_on_exit()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="lgr" data-topic="AppenderMemory" data-id="set_flush_on_rotate">}\href{../../lgr/html/AppenderMemory.html#method-set_flush_on_rotate}{\code{lgr::AppenderMemory$set_flush_on_rotate()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="lgr" data-topic="AppenderMemory" data-id="set_flush_threshold">}\href{../../lgr/html/AppenderMemory.html#method-set_flush_threshold}{\code{lgr::AppenderMemory$set_flush_threshold()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="lgr" data-topic="AppenderMemory" data-id="set_should_flush">}\href{../../lgr/html/AppenderMemory.html#method-set_should_flush}{\code{lgr::AppenderMemory$set_should_flush()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="lgr" data-topic="AppenderMemory" data-id="show">}\href{../../lgr/html/AppenderMemory.html#method-show}{\code{lgr::AppenderMemory$show()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="lgrExtra" data-topic="AppenderDigest" data-id="set_subject_layout">}\href{../../lgrExtra/html/AppenderDigest.html#method-set_subject_layout}{\code{lgrExtra::AppenderDigest$set_subject_layout()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AppenderMail$new(...)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-set_to"></a>}}
\if{latex}{\out{\hypertarget{method-set_to}{}}}
\subsection{Method \code{set_to()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AppenderMail$set_to(x)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-set_from"></a>}}
\if{latex}{\out{\hypertarget{method-set_from}{}}}
\subsection{Method \code{set_from()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AppenderMail$set_from(x)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-set_cc"></a>}}
\if{latex}{\out{\hypertarget{method-set_cc}{}}}
\subsection{Method \code{set_cc()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AppenderMail$set_cc(x)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-set_bcc"></a>}}
\if{latex}{\out{\hypertarget{method-set_bcc}{}}}
\subsection{Method \code{set_bcc()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AppenderMail$set_bcc(x)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-set_html"></a>}}
\if{latex}{\out{\hypertarget{method-set_html}{}}}
\subsection{Method \code{set_html()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AppenderMail$set_html(x)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-format"></a>}}
\if{latex}{\out{\hypertarget{method-format}{}}}
\subsection{Method \code{format()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AppenderMail$format(color = FALSE, ...)}\if{html}{\out{</div>}}
}

}
}
