% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/equidist.R
\name{equidist}
\alias{equidist}
\title{Return equidistant breaks}
\usage{
equidist(
  x,
  n,
  left = c("infinity", "same", "none"),
  right = c("infinity", "same", "none")
)
}
\arguments{
\item{x}{A numeric vector of input values}

\item{n}{The number of breaks of \code{x} to find (\code{n} must be at least 2)}

\item{left}{The left border of the returned vector of breaks: \code{"infinity"}, \code{"same"} or \code{"none"}
(see the description below)}

\item{right}{The right border of the returned vector of breaks: \code{"infinity"}, \code{"same"} or \code{"none"}
(see the description below)}
}
\value{
A vector of equidistant breaks, which can be used e.g. in \code{\link[=fcut]{fcut()}}
}
\description{
If both \code{left} and \code{right} equal to \code{"none"}, the function returns a vector of \code{n} values from \code{x}
that divide the range of values in \code{x} into \code{n - 1} equidistant intervals.
}
\details{
If the \code{left} (resp. \code{right}) argument equals to \code{"infinity"}, \code{-Inf} (resp. \code{Inf}) is prepended
(resp. appended) to the result. If it equals to \code{"same"}, the first (resp. last) value is doubled.
Such functionality is beneficial if using the result of this function with e.g. the \code{\link[=fcut]{fcut()}} function:
\code{Inf} values at the beginning (resp. at the end) of the vector of breaks means that the fuzzy set
partition starts with a fuzzy set with kernel going to negative (resp. positive) infinity; the doubled
value at the beginning (resp. end) results in half-cut (trimmed) fuzzy set.
}
\seealso{
\code{\link[=equifreq]{equifreq()}}, \code{\link[=fcut]{fcut()}}
}
\author{
Michal Burda
}
\keyword{models}
\keyword{robust}
