% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/farules.R
\name{c.farules}
\alias{c.farules}
\title{Take a sequence of instances of S3 class \code{\link[=farules]{farules()}} and combine them into a single
object. An error is thrown if some argument does not inherit from the \code{\link[=farules]{farules()}}
class.}
\usage{
\method{c}{farules}(..., recursive = FALSE)
}
\arguments{
\item{...}{A sequence of objects of class \code{\link[=farules]{farules()}} to be concatenated.}

\item{recursive}{This argument has currently no function and is added here
only for compatibility with generic \code{\link{c}} function.}
}
\value{
An object of class \code{\link[=farules]{farules()}} that is created by merging the
arguments together, i.e.  by concatenating the rules and row-binding the
statistics of given objects.
}
\description{
Take a sequence of instances of S3 class \code{\link[=farules]{farules()}} and combine them into a single
object. An error is thrown if some argument does not inherit from the \code{\link[=farules]{farules()}}
class.
}
\examples{
    ori1 <- farules(rules=list(letters[1:3],
                               letters[2:5]),
                    statistics=matrix(runif(16), nrow=2))
    ori2 <- farules(rules=list(letters[4],
                               letters[3:8]),
                    statistics=matrix(runif(16), nrow=2))
    res <- c(ori1, ori2)
    print(res)
}
\seealso{
\code{\link[=farules]{farules()}}, \code{\link[=searchrules]{searchrules()}}
}
\author{
Michal Burda
}
\keyword{models}
\keyword{robust}
