% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is.estimable.R
\name{is.estimable}
\alias{is.estimable}
\title{Verify estimability of function}
\usage{
is.estimable(ef, fe, R = NULL, nowarn = FALSE, keepdiff = FALSE,
  threshold = 500 * getOption("lfe.eps"))
}
\arguments{
\item{ef}{function.  The function to be verified.}

\item{fe}{list of factors.}

\item{R}{numeric.  Vector of residuals, if \code{NULL}, a random one is
created.}

\item{nowarn}{logical. Set to \code{TRUE} if \code{is.estimable} should not
throw a warning for non-estimable functions.}

\item{keepdiff}{logical. Return differences between two different runs of
the Kaczmarz method.}

\item{threshold}{numeric. Threshold for determining estimability.}
}
\value{
Returns a logical.
}
\description{
Verify that a function you have written for \code{\link{getfe}} is indeed
estimable.
}
\details{
When writing custom estimable functions for \code{\link{getfe}}, the
function \code{is.estimable} can be used to test it for estimability.
\code{is.estimable()} solves the sparse residual system with the Kaczmarz
method, using two different initial values. Then \code{ef()} is applied to
the two solutions. If the value of \code{ef()} differs by more than
\code{1e-5} in any coordinate, \code{FALSE} is returned, otherwise
\code{TRUE} is returned.  If \code{keepdiff=TRUE}, the vector of differences
is attached as an attribute \code{'diff'} to the returned logical value.  If
you have problems with estimability, it is a fair guess that those entries
with a difference in absolute values smaller than, say, \code{1e-5} are
estimable, whereas the others are not.
}
\examples{

oldopts <- options(lfe.threads=1)
## create individual and firm
id <- factor(sample(5000,50000,replace=TRUE))
firm <- factor(sample(3000,50000,replace=TRUE))

## create some estimable functions. It's faster to
## use numerical indices in ef rather than strings, and the input v
## to ef has no names, we have to add them when requested
ef <- function(v,addnames) {
  w <- c(v[6]-v[5],v[7000]+v[5],v[7000]-v[6000])
  if(addnames) names(w) <-c('id6-id5','f2k+id5','f2k-f1k')
  w
}
is.estimable(ef,list(id=id,firm=firm))

## Then make an error; in the last coordinate, sum two firms
ef <- function(v,addnames) {
  w <- c(v[6]-v[5],v[7000]+v[5],v[7000]+v[6000])
  if(addnames) names(w) <-c('id6-id5','f2k+id5','f2k-f1k')
  w
}
is.estimable(ef, list(id=id,firm=firm), keepdiff=TRUE)
options(oldopts)

}
\seealso{
\code{\link{getfe}}
}

