% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/str_functions.R
\name{str_delete_whitespace}
\alias{str_delete_leading_nonword}
\alias{str_delete_nonword}
\alias{str_delete_separators}
\alias{str_delete_space}
\alias{str_delete_whitespace}
\alias{str_expand_capwords}
\title{Common string transformations}
\usage{
str_delete_whitespace(string)

str_delete_separators(string)

str_delete_nonword(string)

str_expand_capwords(string)

str_delete_leading_nonword(string)

str_delete_space(string)
}
\arguments{
\item{string}{character vector

These function take a single character vector argument and return a character
vector that has had one or more functions applied to it. They are the
building blocks for building up case transformations.}
}
\value{
character vector
}
\description{
Perform common transformations on strings
}
\examples{
# TRANSFORMATIONS
  str_ucfirst( "abc def" )              # Abc Def
  str_expand_capwords( "AbcDef")        # Abc Def

# DELETION
  str_delete_whitespace( "ABC 123" )    # ABC123
  str_delete_separators( "A_B-C.123" )  # ABC123
  str_delete_nonword( "ABC & 123" )     # ABC123
}

