% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/lets_iucn.R
\name{lets.iucn}
\alias{lets.iucn}
\title{Download species' information from the IUCN RedList online database}
\usage{
lets.iucn(input, count = FALSE)
}
\arguments{
\item{input}{Character vector with one or more species names,
or an object of class \code{\link{PresenceAbsence}}.}

\item{count}{Logical, if \code{TRUE} a counting window will open.}
}
\value{
Returns a data frame with the Species Name, Family, Conservation Status,
Criteria used to estabilish the conservation status, Population Status, Year of
Description (only for animals), and the Countries where it occurs. If species do
not have information (i.e. have not been evaluated), the result is: NE (Not
evaluated).
}
\description{
Get species' information from the IUCN
website(\url{http://www.iucnredlist.org/}) for one or more species.
}
\details{
Note that you must be connected to the internet to use this function.
}
\examples{
\dontrun{
# Single species
lets.iucn("Pongo pygmaeus")

# Multiple species
sp <- c("Musonycteris harrisoni", "Ailuropoda melanoleuca",
        "Cebus flavius")
lets.iucn(sp)
}
}
\author{
Bruno Vilela
}
\seealso{
\code{\link{lets.iucn.ha}}

\code{\link{lets.iucn.his}}
}

