% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/lets_summaryze.R
\name{lets.summarizer}
\alias{lets.summarizer}
\title{Summarize variable(s) values in a presence-absence matrix within species' ranges}
\usage{
lets.summarizer(x, pos, xy=TRUE, fun=mean)
}
\arguments{
\item{x}{Presence-absence matrix with variables added.}

\item{pos}{Column position of the variables of interest.}

\item{xy}{Logical, if \code{TRUE} the input matrix contains geographic coordinates in the first two columns.}

\item{fun}{Function to be used to summarize the variable per species.}
}
\description{
Based on a Presence-Absence matrix with added variables (see \code{\link{lets.addvar}}), this function summarizes the values of such variable(s) per species (across the species' occupied cells. i.e. within their ranges).
}
\author{
Bruno Vilela & Fabricio Villalobos
}
\references{
Villalobos, F. and Arita, H.T. 2010. The diversity field of New World leaf-nosed bats (Phyllostomidae). Global Ecology and Biogeography. 19, 200-211.
}
\seealso{
\code{\link{lets.addvar}}

\code{\link{lets.addpoly}}

\code{\link{lets.field}}
}

