% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cld_content.R
\name{cld_content}
\alias{cld_content}
\title{List content of the CLD}
\usage{
cld_content(legislature = NULL)
}
\arguments{
\item{legislature}{An optional character string specifying one or more legislatures. Currently one of \sQuote{aut}, \sQuote{can}, \sQuote{cze}, \sQuote{esp}, \sQuote{fra}, \sQuote{deu}, \sQuote{irl}, \sQuote{sco}, \sQuote{gbr}, \sQuote{usa_house}, or \sQuote{usa_senate}. If NULL (the default), a list with all legislatures and sessions available in the CLD is returned.}
}
\value{
A list with names being three-letter country codes and with each element containing a vector that shows the sessions available for a legislature.
}
\description{
Returns a named list of legislatures and sessions available in the CLD. This provides a quick overview of the CLD's scope and valid three-letter country codes, and helps to conventiently loop/map over legislatures and sessions.
}
\examples{
# Get a list of three-letter country codes and available sessions for all countries
overview <- cld_content()
tibble::glimpse(overview)

# Get a list of available sessions for the French Assemblée and the Irish Dail
sessions <- cld_content(legislature = c("fra", "irl"))
tibble::glimpse(sessions)
}
