% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/primitive-ticks.R
\name{primitive_ticks}
\alias{primitive_ticks}
\title{Guide primitive: line}
\usage{
primitive_ticks(key = NULL, bidi = FALSE, theme = NULL, position = waiver())
}
\arguments{
\item{key}{A \link[=key_standard]{standard key} specification. See more information
in the linked topic.}

\item{bidi}{A \verb{<logical[1]>}: whether ticks should be drawn bidirectionally
(\code{TRUE}) or in a single direction (\code{FALSE}, default).}

\item{theme}{A \code{\link[ggplot2:theme]{<theme>}} object to style the guide individually or
differently from the plot's theme settings. The \code{theme} argument in the
guide overrides and is combined with the plot's theme.}

\item{position}{A \verb{<character[1]>} giving the location of the guide. Can be one of \code{"top"},
\code{"bottom"}, \code{"left"} or \code{"right"}.}
}
\value{
A \code{PrimitiveTicks} primitive guide that can be used inside other
guides.
}
\description{
This function constructs a ticks \link[=guide-primitives]{guide primitive}.
}
\section{Styling options}{
Below are the \link[ggplot2:theme]{theme} options that determine the styling of
this guide, which may differ depending on whether the guide is used in
an axis or in a legend context.

Common to both types is the following:
\subsection{As an axis guide}{
\itemize{
\item \verb{axis.ticks.\{x/y\}.\{position\}} an \code{\link[ggplot2:element]{<element_line>}}
for major tick lines.
\item \verb{axis.minor.ticks.\{x/y\}.\{position\}} an
\code{\link[ggplot2:element]{<element_line>}} for minor tick lines.
\item \code{legendry.axis.mini.ticks} an \code{\link[ggplot2:element]{<element_line>}}
internally inheriting from the minor ticks for the smallest ticks in e.g.
log axes.
\item \verb{axis.ticks.length.\{x/y\}.\{position\}} a \code{\link[grid:unit]{<unit>}} for the major
ticks length.
\item \verb{axis.minor.ticks.length.\{x/y\}.\{position\}} a \code{\link[grid:unit]{<unit>}} for the
minor ticks length.
\item \code{legendry.axis.mini.ticks.length} a \code{\link[grid:unit]{<unit>}} internally
inheriting from the minor tick length for the smallest ticks in e.g.
log axes.
}
}

\subsection{As a legend guide}{
\itemize{
\item \code{legend.ticks} an \code{\link[ggplot2:element]{<element_line>}} for major tick
lines.
\item \code{legendry.legend.minor.ticks} an \code{\link[ggplot2:element]{<element_line>}}
for minor tick lines.
\item \code{legendry.legend.mini.ticks} an \code{\link[ggplot2:element]{<element_line>}}
for the smallest ticks in e.g. log axes.
\item \code{legend.ticks.length} a \code{\link[grid:unit]{<unit>}} for the major ticks length.
\item \code{legendry.legend.minor.ticks.length} a \code{\link[grid:unit]{<unit>}} for the
minor ticks length.
\item \code{legendry.legend.mini.ticks.length} a \code{\link[grid:unit]{<unit>}} for the
smallest ticks in e.g. log axes.
}
}
}

\examples{
# A standard plot
p <- ggplot(mpg, aes(displ, hwy)) +
  geom_point()

# Adding as secondary guides
p + guides(x.sec = primitive_ticks(), y.sec = primitive_ticks())
}
\seealso{
Other primitives: 
\code{\link{primitive_box}()},
\code{\link{primitive_bracket}()},
\code{\link{primitive_fence}()},
\code{\link{primitive_labels}()},
\code{\link{primitive_line}()},
\code{\link{primitive_spacer}()},
\code{\link{primitive_title}()}
}
\concept{primitives}
