% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/guide_colring.R
\name{guide_colring}
\alias{guide_colring}
\title{Colour rings and arcs}
\usage{
guide_colring(
  title = waiver(),
  key = "auto",
  start = 0,
  end = NULL,
  outer_guide = "axis_base",
  inner_guide = "axis_base",
  nbin = 300,
  reverse = FALSE,
  show_labels = "outer",
  theme = NULL,
  vanilla = TRUE,
  position = waiver(),
  available_aes = c("colour", "fill"),
  ...
)
}
\arguments{
\item{title}{A \verb{<character[1]>} or \verb{<expression[1]>} indicating the title of
the guide. If \code{NULL}, the title is not shown. The default,
\code{\link[ggplot2:waiver]{waiver()}}, takes the name of the scale object or
the name specified in \code{\link[ggplot2:labs]{labs()}} as the title.}

\item{key}{A \link[=key_standard]{standard key} specification. Defaults to
\code{\link[=key_auto]{key_auto()}}.}

\item{start, end}{A \verb{<numeric[1]>} in radians specifying the offset of the
starting and end points from 12 o'clock. The \code{NULL} default for \code{end},
internally defaults to \code{start + 2 * pi}.}

\item{outer_guide, inner_guide}{Guides to display on the outside and inside
of the colour ring. Each guide can be specified using one of the following:
\itemize{
\item A \verb{<Guide>} class object.
\item A \verb{<function>} that returns a \verb{<Guide>} class object.
\item A \verb{<character>} naming such function, without the \code{guide_} or
\code{primitive_} prefix.
}}

\item{nbin}{A positive \verb{<integer[1]>} determining how many colours to display.}

\item{reverse}{A \verb{<logical[1]>} whether to reverse continuous guides.
If \code{TRUE}, guides like colour bars are flipped. If \code{FALSE} (default),
the original order is maintained.}

\item{show_labels}{A \verb{<character[1]>} indicating for which guide labels
should be shown. Can be one of \code{"outer"} (default), \code{"inner"}, \code{"both"} or
\code{"none"}. Note that labels can only be omitted if the related guide
has a label suppression mechanism.}

\item{theme}{A \code{\link[ggplot2:theme]{<theme>}} object to style the guide individually or
differently from the plot's theme settings. The \code{theme} argument in the
guide overrides and is combined with the plot's theme.}

\item{vanilla}{A \verb{<logical[1]>} whether to have the default style match
the vanilla \code{guide_colourbar()} (\code{TRUE}) or take the theme
verbatim (\code{FALSE}).}

\item{position}{A \verb{<character[1]>} giving the location of the guide. Can be one of \code{"top"},
\code{"bottom"}, \code{"left"} or \code{"right"}.}

\item{available_aes}{A \verb{<character>} vector listing the aesthetics for which this guide can
be build.}

\item{...}{Arguments forwarded to the \code{outer_guide} and \code{inner_guide} if
provided as functions or strings.}
}
\value{
A \verb{<Guide>} object.
}
\description{
Similar to \code{\link[ggplot2:guide_colourbar]{guide_colourbar()}}, this guide
displays continuous \code{colour} or \code{fill} aesthetics. Instead of a bar, the
gradient in shown in a ring or arc, which can be convenient for cyclical
palettes such as some provided in the \pkg{scico} package.
}
\examples{
# Rings works best with a cyclical palette
my_pal <- c("black", "tomato", "white", "dodgerblue", "black")

p <- ggplot(mpg, aes(displ, hwy, colour = cty)) +
  geom_point() +
  scale_colour_gradientn(colours = my_pal)

# Standard colour ring
p + guides(colour = "colring")

# As an arc
p + guides(colour = guide_colring(
  start = 1.25 * pi, end = 2.75 * pi
))

# Removing the inner tick marks
p + guides(colour = guide_colring(inner_guide = "none"))

# Include labels on the inner axis
p + guides(colour = guide_colring(show_labels = "both"))

# Passing an argument to inner/outer guides
p + guides(colour = guide_colring(angle = 0))
}
\seealso{
Other standalone guides: 
\code{\link{guide_axis_base}()},
\code{\link{guide_axis_nested}()},
\code{\link{guide_colbar}()},
\code{\link{guide_colsteps}()},
\code{\link{guide_legend_base}()},
\code{\link{guide_legend_cross}()},
\code{\link{guide_legend_group}()}
}
\concept{standalone guides}
