% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/popdyn.R
\name{ltre3.lefkoMat}
\alias{ltre3.lefkoMat}
\title{Conduct a Life Table Response Experiment of a lefkoMat Object}
\usage{
\method{ltre3}{lefkoMat}(
  mats,
  refmats = NA,
  ref = NA,
  stochastic = FALSE,
  steps = 10000,
  burnin = 3000,
  time_weights = NA,
  sparse = "auto",
  rseed = NA,
  append_mats = FALSE,
  ...
)
}
\arguments{
\item{mats}{An object of class \code{lefkoMat}.}

\item{refmats}{A reference lefkoMat object, or matrix, for use as the
control. If missing, then is set to the same object as \code{mats}.}

\item{ref}{A numeric value indicating which matrix or matrices in
\code{refmats} to use as the control. The numbers used must correspond to the
number of the matrices in the \code{labels} element of the associated
\code{lefkoMat} object. The default setting, NA, uses all entries in
\code{refmats}.}

\item{stochastic}{A logical value determining whether to conduct a
deterministic (FALSE) or stochastic (TRUE) elasticity analysis. Defaults to
FALSE.}

\item{steps}{The number of occasions to project forward in stochastic
simulation. Defaults to 10,000.}

\item{burnin}{The number of initial steps to ignore in stochastic projection
when calculating stochastic elasticities. Must be smaller than \code{steps}.
Defaults to 3000.}

\item{time_weights}{Numeric vector denoting the probabilistic weightings of
all matrices. Defaults to equal weighting among matrices.}

\item{sparse}{A string indicating whether to use sparse matrix encoding
(\code{"yes"}) or dense matrix encoding (\code{"no"}). Defaults to
\code{"auto"}.}

\item{rseed}{Optional numeric value corresponding to the random seed for
stochastic simulation.}

\item{append_mats}{A logical value denoting whether to include the original
A, U, and F matrices in the returned \code{lefkoLTRE} object. Defaults to
FALSE.}

\item{...}{Other parameters.}
}
\value{
This function returns an object of class \code{lefkoLTRE}. This
includes a list of LTRE matrices as object \code{ltre_det} if a deterministic
LTRE is called for, or a list of mean-value LTRE matrices as object
\code{ltre_mean} and a list of SD-value LTRE matrices as object
\code{ltre_sd} if a stochastic LTRE is called for. This is followed by the
stageframe as object \code{ahstages}, the order of historical stages as
object \code{hstages}, the age-by-stage order as object \code{agestages}, the
order of matrices as object \code{labels}, and, if requested, the original A,
U, and F matrices.
}
\description{
\code{ltre3.lefkoMat()} returns a set of matrices of one-way LTRE (life table
response experiment) or stochastic LTRE matrices contributions.
}
\section{Notes}{

Deterministic LTRE is one-way, fixed, and based on the sensitivities of the
matrix midway between each input matrix and the reference matrix, per Caswell
(2001, Matrix Population Models, Sinauer Associates, MA, USA). Stochastic
LTRE is simulated per Davison et al. (2010) Journal of Ecology 98:255-267
(doi: 10.1111/j.1365-2745.2009.01611.x).

Default behavior for stochastic LTRE uses the full population provided in
\code{mats} as the reference if no \code{refmats} and \code{ref} is provided.
If no \code{refmats} is provided but \code{ref} is, then the matrices noted
in \code{ref} are used as the reference matrix set. Year and patch order is
utilized from object \code{mats}, but not from object \code{refmats}, in
which each matrix is assumed to represent a different year from one
population. This function cannot currently handle multiple populations within
the same \code{mats} object (although such analysis is possible if these
populations are designated as patches instead).
}

\examples{
# Lathyrus example
data(lathyrus)

sizevector <- c(0, 100, 13, 127, 3730, 3800, 0)
stagevector <- c("Sd", "Sdl", "VSm", "Sm", "VLa", "Flo", "Dorm")
repvector <- c(0, 0, 0, 0, 0, 1, 0)
obsvector <- c(0, 1, 1, 1, 1, 1, 0)
matvector <- c(0, 0, 1, 1, 1, 1, 1)
immvector <- c(1, 1, 0, 0, 0, 0, 0)
propvector <- c(1, 0, 0, 0, 0, 0, 0)
indataset <- c(0, 1, 1, 1, 1, 1, 1)
binvec <- c(0, 100, 11, 103, 3500, 3800, 0.5)

lathframe <- sf_create(sizes = sizevector, stagenames = stagevector,
  repstatus = repvector, obsstatus = obsvector, matstatus = matvector,
  immstatus = immvector, indataset = indataset, binhalfwidth = binvec,
  propstatus = propvector)

lathvert <- verticalize3(lathyrus, noyears = 4, firstyear = 1988,
  patchidcol = "SUBPLOT", individcol = "GENET", blocksize = 9,
  juvcol = "Seedling1988", sizeacol = "Volume88", repstracol = "FCODE88",
  fecacol = "Intactseed88", deadacol = "Dead1988",
  nonobsacol = "Dormant1988", stageassign = lathframe, stagesize = "sizea",
  censorcol = "Missing1988", censorkeep = NA, censor = TRUE)

lathsupp3 <- supplemental(stage3 = c("Sd", "Sd", "Sdl", "Sdl", "Sd", "Sdl", "mat"),
  stage2 = c("Sd", "Sd", "Sd", "Sd", "rep", "rep", "Sdl"),
  stage1 = c("Sd", "rep", "Sd", "rep", "npr", "npr", "Sd"),
  eststage3 = c(NA, NA, NA, NA, NA, NA, "mat"),
  eststage2 = c(NA, NA, NA, NA, NA, NA, "Sdl"),
  eststage1 = c(NA, NA, NA, NA, NA, NA, "NotAlive"),
  givenrate = c(0.345, 0.345, 0.054, 0.054, NA, NA, NA),
  multiplier = c(NA, NA, NA, NA, 0.345, 0.054, NA),
  type = c(1, 1, 1, 1, 3, 3, 1), type_t12 = c(1, 2, 1, 2, 1, 1, 1),
  stageframe = lathframe, historical = TRUE)

ehrlen3 <- rlefko3(data = lathvert, stageframe = lathframe, year = "all", 
  stages = c("stage3", "stage2", "stage1"), supplement = lathsupp3,
  yearcol = "year2", indivcol = "individ")

ltre3(ehrlen3, stochastic = TRUE)

# Cypripedium example
data(cypdata)

sizevector <- c(0, 0, 0, 0, 0, 0, 1, 2.5, 4.5, 8, 17.5)
stagevector <- c("SD", "P1", "P2", "P3", "SL", "D", "XSm", "Sm", "Md", "Lg",
  "XLg")
repvector <- c(0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1)
obsvector <- c(0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1)
matvector <- c(0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1)
immvector <- c(0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0)
propvector <- c(1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)
indataset <- c(0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1)
binvec <- c(0, 0, 0, 0, 0, 0.5, 0.5, 1, 1, 2.5, 7)

cypframe_raw <- sf_create(sizes = sizevector, stagenames = stagevector,
  repstatus = repvector, obsstatus = obsvector, matstatus = matvector,
  propstatus = propvector, immstatus = immvector, indataset = indataset,
  binhalfwidth = binvec)

cypraw_v1 <- verticalize3(data = cypdata, noyears = 6, firstyear = 2004,
  patchidcol = "patch", individcol = "plantid", blocksize = 4,
  sizeacol = "Inf2.04", sizebcol = "Inf.04", sizeccol = "Veg.04",
  repstracol = "Inf.04", repstrbcol = "Inf2.04", fecacol = "Pod.04",
  stageassign = cypframe_raw, stagesize = "sizeadded", NAas0 = TRUE,
  NRasRep = TRUE)

cypsupp2r <- supplemental(stage3 = c("SD", "P1", "P2", "P3", "SL", "D", 
    "XSm", "Sm", "SD", "P1"),
  stage2 = c("SD", "SD", "P1", "P2", "P3", "SL", "SL", "SL", "rep",
    "rep"),
  eststage3 = c(NA, NA, NA, NA, NA, "D", "XSm", "Sm", NA, NA),
  eststage2 = c(NA, NA, NA, NA, NA, "XSm", "XSm", "XSm", NA, NA),
  givenrate = c(0.10, 0.20, 0.20, 0.20, 0.25, NA, NA, NA, NA, NA),
  multiplier = c(NA, NA, NA, NA, NA, NA, NA, NA, 0.5, 0.5),
  type =c(1, 1, 1, 1, 1, 1, 1, 1, 3, 3),
  stageframe = cypframe_raw, historical = FALSE)

cypmatrix2r <- rlefko2(data = cypraw_v1, stageframe = cypframe_raw, 
  year = "all", patch = "all", stages = c("stage3", "stage2", "stage1"),
  size = c("size3added", "size2added"), supplement = cypsupp2r,
  yearcol = "year2", patchcol = "patchid", indivcol = "individ")

ltre3(cypmatrix2r)

}
\seealso{
\code{\link{ltre3}()}

\code{\link{summary.lefkoLTRE}()}
}
