# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Create Vertical Structure for Horizontal Data Frame Input
#' 
#' Function \code{pfj()} powers the R function \code{\link{verticalize3}()},
#' creating the vertical structure and rearranging the data in that shape.
#' 
#' @param data The horizontal data file.
#' @param stageframe The stageframe object describing the life history model.
#' This should be the full stageframe.
#' @param noyears The number of years or observation periods in the dataset.
#' @param firstyear The first year or time of observation.
#' @param popidcol Column number corresponding to the identity of the
#' population for each individual.
#' @param patchidcol Column number corresponding to the identity of the patch
#' for each individual.
#' @param individcol Column number corresponding to the identity of each 
#' individual.
#' @param blocksize The number of variables corresponding to each time step in 
#' the input dataset designated in \code{data}.
#' @param xcol Vector of column numbers corresponding to the x coordinate of
#' each individual in Cartesian space.
#' @param ycol Vector of column numbers corresponding to the y coordinate of
#' each individual in Cartesian space.
#' @param juvcol Vector of column numbers that marks individuals in immature
#' stages within the dataset.
#' @param sizeacol Vector of column numbers corresponding to the first or main
#' size variable associated with the first year or observation time in the
#' dataset.
#' @param sizebcol Vector of column numbers corresponding to the second size
#' variable associated with the first year or observation time in the dataset.
#' @param sizeccol Vector of column numbers corresponding to the third size
#' variable associated with the first year or observation time in the dataset.
#' @param repstracol Vector of column numbers corresponding to the main 
#' variable coding the production of reproductive structures associated with
#' the first year or observation period in the input dataset.
#' @param repstrbcol Vector of column numbers corresponding to a second
#' variable coding the production of reproductive structures associated with
#' the first year or observation period in the input dataset.
#' @param fecacol Vector of column numbers corresponding to the main variable
#' coding for fecundity associated with the first year or observation period in
#' the dataset.
#' @param fecbcol Vector of column numbers corresponding to a second variable
#' coding for fecundity associated with the first year or observation period in
#' the dataset.
#' @param indcovacol Vector of column numbers corresponding to an individual
#' covariate.
#' @param indcovbcol Vector of column numbers corresponding to an individual
#' covariate.
#' @param indcovccol Vector of column numbers corresponding to an individual
#' covariate.
#' @param aliveacol Vector of column numbers that details whether an individual
#' is alive at a given time.
#' @param deadacol Vector of column numbers that details whether an individual
#' is dead at a given time.
#' @param obsacol Vector of column numbers that details whether an individual
#' is in an observable stage at a given time.
#' @param nonobsacol Vector of column numbers that details whether an
#' individual is in an unobservable stage at a given time.
#' @param censorcol Vector of column numbers corresponding to the first entry
#' of a censor variable.
#' @param stagecol Vector of column numbers corresponding to the first entry of
#' a column designating stages.
#' @param repstrrel This is a scalar modifier for that makes the variable in
#' \code{repstrbcol} equivalent to \code{repstracol}.
#' @param fecrel This is a scalar modifier for that makes the variable in
#' \code{fecbcol} equivalent to \code{fecacol}.
#' @param NAas0 If TRUE, then all NA entries for size and fecundity variables
#' will be set to 0.
#' @param NRasRep If TRUE, then will treat non-reproductive but mature
#' individuals as reproductive during stage assignment.
#' @param RepasObs If TRUE, then will treat individuals with size 0 as observed
#' if and only if they are reproductive. Otherwise, all individuals with size 0
#' are treated as not observed.
#' @param NOasObs If TRUE, then will treat unobserved individuals as observed
#' during stage assignment.
#' @param stassign A logical value indicating whether to assign stages.
#' @param stszcol Integer describing which size variable or combination of size
#' variables to use in stage estimation.
#' @param censorkeep The value of the censoring variable identifying data
#' that should be included in analysis. Defaults to 0, but may take any numeric
#' value including NA.
#' @param censbool A logical variable determining whether NA denotes the value
#' of the censoring variable identifying data to keep. If used, then will set
#' all NAs to 0 and all other values to 1, treating 0 as the value to keep.
#' @param censrepeat A logical value indicating whether censor variable is a
#' single static column, or whether censor variables repeat across blocks.
#' @param coordsrepeat A logical value indicating whether coordinate variables
#' are single static columns, or whether they repeat across blocks.
#' @param quiet A logical value indicating whether to silense warnings.
#' 
#' @return The output is currently a 7 element list, where each element is a
#' data frame with the same number of rows.
#' 
#' @keywords internal
#' @noRd
.pfj <- function(data, stageframe, noyears, firstyear, popidcol, patchidcol, individcol, blocksize, xcol, ycol, juvcol, sizeacol, sizebcol, sizeccol, repstracol, repstrbcol, fecacol, fecbcol, indcovacol, indcovbcol, indcovccol, aliveacol, deadacol, obsacol, nonobsacol, censorcol, stagecol, repstrrel, fecrel, NAas0, NRasRep, RepasObs, NOasObs, stassign, stszcol, censorkeep, censbool, censrepeat, coordsrepeat, quiet) {
    .Call('_lefko3_pfj', PACKAGE = 'lefko3', data, stageframe, noyears, firstyear, popidcol, patchidcol, individcol, blocksize, xcol, ycol, juvcol, sizeacol, sizebcol, sizeccol, repstracol, repstrbcol, fecacol, fecbcol, indcovacol, indcovbcol, indcovccol, aliveacol, deadacol, obsacol, nonobsacol, censorcol, stagecol, repstrrel, fecrel, NAas0, NRasRep, RepasObs, NOasObs, stassign, stszcol, censorkeep, censbool, censrepeat, coordsrepeat, quiet)
}

#' Create Historical Vertical Structure for Ahistorical Vertical Data Frame
#' 
#' Function \code{jpf()} is the core kernel for function
#' \code{\link{historicalize3}()}, creating the historical, vertical structure
#' and rearranging the data in that shape.
#'
#' @param data The horizontal data file.
#' @param stageframe The stageframe object identifying the life history model
#' being operationalized. This should be the full stageframe.
#' @param popidcol Column number corresponding to the identity of the
#' population for each individual.
#' @param patchidcol Column number corresponding to the identity of the patch
#' for each individual.
#' @param individcol Column number corresponding to the identity of each 
#' individual.
#' @param year2col Column number of year or occasion in time \emph{t}.
#' @param year3col Column number of year or occasion in time \emph{t}+1.
#' @param xcol Column number corresponding to the x coordinate of each
#' individual in Cartesian space.
#' @param ycol Column number corresponding to the y coordinate of each
#' individual in Cartesian space.
#' @param juv2col Column number coding for status as a juvenile in time
#' \emph{t}.
#' @param juv3col Column number coding for status as a juvenile in time
#' \emph{t}+1.
#' @param sizea2col Column number corresponding to the primary size variable in
#' time \emph{t}.
#' @param sizea3col Column number corresponding to the primary size variable in
#' time \emph{t}+1.
#' @param sizeb2col Column number corresponding to the secondary size variable
#' in time \emph{t}.
#' @param sizeb3col Column number corresponding to the secondary size variable
#' in time \emph{t}+1.
#' @param sizec2col Column number corresponding to the tertiary size variable
#' in time \emph{t}.
#' @param sizec3col Column number corresponding to the tertiary size variable
#' in time \emph{t}+1.
#' @param repstra2col Column number corresponding to the main variable coding
#' for the production of reproductive structures, such as flowers, in time
#' \emph{t}.
#' @param repstra3col Column number corresponding to the main variable coding
#' for the production of reproductive structures, such as flowers, in time
#' \emph{t}+1.
#' @param repstrb2col Column number corresponding to a second variable coding
#' for the production of reproductive structures, such as flowers, in time
#' \emph{t}.
#' @param repstrb3col Column number corresponding to a second variable coding
#' for the production of reproductive structures, such as flowers, in time
#' \emph{t}+1.
#' @param feca2col Column number corresponding to the main variable coding for
#' fecundity in time \emph{t}.
#' @param feca3col Column number corresponding to the main variable coding for
#' fecundity in time \emph{t}+1.
#' @param fecb2col Column number corresponding to a second variable coding for
#' fecundity in time \emph{t}.
#' @param fecb3col Column number corresponding to a second variable coding for
#' fecundity in time \emph{t}+1.
#' @param indcova2col Column number corresponding to an individual covariate in
#' time \emph{t}.
#' @param indcova3col Column number corresponding to an individual covariate in
#' time \emph{t}+1.
#' @param indcovb2col Column number corresponding to an individual covariate in
#' time \emph{t}.
#' @param indcovb3col Column number corresponding to an individual covariate in
#' time \emph{t}+1.
#' @param indcovc2col Column number corresponding to an individual covariate in
#' time \emph{t}.
#' @param indcovc3col Column number corresponding to an individual covariate in
#' time \emph{t}+1.
#' @param alive2col Column number detailing whether an individual is alive in 
#' time \emph{t}.
#' @param alive3col Column number detailing whether an individual is alive in 
#' time \emph{t}+1.
#' @param dead2col Column number detailing whether an individual is dead in 
#' time \emph{t}.
#' @param dead3col Column number detailing whether an individual is dead in 
#' time \emph{t}+1.
#' @param obs2col Column number detailing whether an individual is in an
#' observable stage in time \emph{t}.
#' @param obs3col Column number detailing whether an individual is in an
#' observable stage in time \emph{t}+1.
#' @param nonobs2col Column number detailing whether an individual is in an
#' unobservable stage in time \emph{t}.
#' @param nonobs3col Column number detailing whether an individual is in an
#' unobservable stage in time \emph{t}+1.
#' @param repstrrel This is a scalar multiplier for that makes the variable in
#' \code{repstrb2col} equivalent to \code{repstra2col}.
#' @param fecrel This is a scalar multiplier for that makes the variable in
#' \code{fecb2col} equivalent to \code{feca2col}.
#' @param stage2col Column number corresponding to life history stage in time
#' \emph{t}.
#' @param stage3col Column number corresponding to life history stage in time
#' \emph{t}+1.
#' @param censorcol Column number corresponding to a censor variable within the
#' dataset.
#' @param NAas0 If \code{TRUE}, then all \code{NA} entries for size and
#' fecundity variables will be set to 0.
#' @param NRasRep If \code{TRUE}, then non-reproductive but mature individuals
#' will be treated as reproductive during stage assignment.
#' @param NOasObs If TRUE, then will treat unobserved individuals as observed
#' during stage assignment.
#' @param stassign A logical value indicating whether to assign stages.
#' @param stszcol Integer describing which size variable to use in stage 
#' estimation. Numbers 1 through 8 are possible.
#' @param censorkeep Numeric value of censor variable, denoting elements to
#' keep. If \code{NA} is to be used, then set this variable to \code{0} and set
#' \code{censbool = TRUE}.
#' @param censbool A logical variable determining whether \code{NA} denotes the
#' value of the censoring variable identifying data to keep.
#' @param quiet A logical value indicating whether to silense warnings.
#' 
#' @return The output is currently a list coerced into the data frame class,
#' and is read as a data frame by R. It is secondarily in class \code{hfvdata}.
#' 
#' @keywords internal
#' @noRd
.jpf <- function(data, stageframe, popidcol, patchidcol, individcol, year2col, year3col, xcol, ycol, juv2col, juv3col, sizea2col, sizea3col, sizeb2col, sizeb3col, sizec2col, sizec3col, repstra2col, repstra3col, repstrb2col, repstrb3col, feca2col, feca3col, fecb2col, fecb3col, indcova2col, indcova3col, indcovb2col, indcovb3col, indcovc2col, indcovc3col, alive2col, alive3col, dead2col, dead3col, obs2col, obs3col, nonobs2col, nonobs3col, repstrrel, fecrel, stage2col, stage3col, censorcol, NAas0, NRasRep, NOasObs, stassign, stszcol, censorkeep, censbool, quiet) {
    .Call('_lefko3_jpf', PACKAGE = 'lefko3', data, stageframe, popidcol, patchidcol, individcol, year2col, year3col, xcol, ycol, juv2col, juv3col, sizea2col, sizea3col, sizeb2col, sizeb3col, sizec2col, sizec3col, repstra2col, repstra3col, repstrb2col, repstrb3col, feca2col, feca3col, fecb2col, fecb3col, indcova2col, indcova3col, indcovb2col, indcovb3col, indcovc2col, indcovc3col, alive2col, alive3col, dead2col, dead3col, obs2col, obs3col, nonobs2col, nonobs3col, repstrrel, fecrel, stage2col, stage3col, censorcol, NAas0, NRasRep, NOasObs, stassign, stszcol, censorkeep, censbool, quiet)
}

#' Estimate Radial Density in Cartesian Space
#' 
#' Function \code{.density3()} estimates radial density on the basis of
#' Cartesian coordinates and spacing information supplied as input. It is used
#' internally by \code{\link{historicalize3}()} and
#' \code{\link{verticalize3}()}.
#' 
#' @param data Demographic dataset in historical vertical format.
#' @param xcol Number of column in \code{data} corresponding to x position.
#' @param ycol Number of column in \code{data} corresponding to y position.
#' @param yearcol Number of column in \code{data} corresponding to occasion
#' \emph{t}.
#' @param spacing Resolution of density estimation, as a scalar numeric.
#' 
#' @return This function returns a vector counting the number of individuals
#' within the specified distance of each individual in the historically
#' formatted vertical dataset.
#' 
#' @section Notes:
#' The process used to estimate density is one in which the distances between
#' all pairs of individuals are calculated via the Pythagorean theorem, and
#' then individual density equals the number of these individuals with
#' distances within the number input as \code{spacing}, respectively for each
#' individual.
#' 
#' This function assumes that all individuals are alive in time \emph{t}, and
#' so data should be filtered appropriately beforehand. Any rows with NA in X
#' or Y will not be counted, and density is estimated specific to time \emph{t}.
#' 
#' @keywords internal
#' @noRd
.density3 <- function(data, xcol, ycol, yearcol, spacing) {
    .Call('_lefko3_density3', PACKAGE = 'lefko3', data, xcol, ycol, yearcol, spacing)
}

#' Create Element Index for Matrix Estimation
#' 
#' Function \code{.simplepizzle()} creates a data frame object used by function
#' \code{\link{hist_null}()} to provide an index for estimation of null
#' historical matrices from ahistorical MPM inputs.
#' 
#' @param StageFrame The stageframe object identifying the life history model
#' being operationalized.
#' @param format Integer indicating whether historical matrices should be in
#' (1) Ehrlen or (2) deVries format.
#' 
#' @return The output is composed of three elements:
#' \item{ahstages}{A new stageframe, which only differs from the input
#' stageframe in deVries format.}
#' \item{hstages}{A new historical stage-pair index for the new historical
#' matrices.}
#' \item{allstages}{A large data frame describing every element to be estimated
#' in the new historical matrices}.
#' 
#' @keywords internal
#' @noRd
.simplepizzle <- function(StageFrame, format) {
    .Call('_lefko3_simplepizzle', PACKAGE = 'lefko3', StageFrame, format)
}

#' Core Engine for cond_hmpm()
#' 
#' Creates a list of conditional ahistorical matrices in the style noted in
#' deVries and Caswell (2018).
#'
#' @param mainmat Historical matrix.
#' @param indices Data frame including the stages at times \emph{t}-1,
#' \emph{t}, and \emph{t}+1, asvwell as indices corresponding to elements in
#' the main historical matrix andvthe conditional matrices to be produced.
#' @param ahstages The number of stages in the stageframe.
#' @param stageframe The original stageframe for the input matrices.
#'
#' @return A list of ahistorical matrices.
#' 
#' @keywords internal
#' @noRd
.hoffmannofstuttgart <- function(mainmat, indices, ahstages, stagenames) {
    .Call('_lefko3_hoffmannofstuttgart', PACKAGE = 'lefko3', mainmat, indices, ahstages, stagenames)
}

#' Extract Conditional Ahistorical Matrices from Historical MPM
#' 
#' Function \code{cond_hmpm()} takes historical MPMs and decomposes them into 
#' ahistorical matrices conditional upon stage in time \emph{t}-1. In effect,
#' the function takes each historical matrix within a lefkoMat object, and
#' forms one ahistorical matrix for each stage in time \emph{t}-1.
#' 
#' @param hmpm A historical matrix projection model of class \code{lefkoMat}.
#' @param matchoice A character denoting whether to use A, U, or F matrices.
#' Defaults to \code{A} matrices.
#' @param err_check A logical value denoting whether to include a data frame
#' of element equivalence from the conditional matrices to the original
#' matrices. Used only for debugging purposes. Defaults to \code{FALSE}.
#' 
#' @return A \code{lefkoCondMat} object, with the following elements:
#' 
#' \item{Mcond}{A multi-level list holding the conditional A matrices derived
#' from the input \code{lefkoMat} object. The top level of the list corresponds
#' to each historical matrix in turn, and the lower level corresponds to each
#' stage in time \emph{t}-1, with individual conditional matrices named for the
#' latter.}
#' \item{hstages}{A data frame matrix showing the pairing of ahistorical stages
#' used to create historical stage pairs.}
#' \item{ahstages}{A data frame detailing the characteristics of associated
#' ahistorical stages.}
#' \item{labels}{A data frame showing the patch and year of each input full A 
#' matrix in order.}
#' 
#' @examples
#' data(cypdata)
#'  
#' sizevector <- c(0, 0, 0, 0, 0, 0, 1, 2.5, 4.5, 8, 17.5)
#' stagevector <- c("SD", "P1", "P2", "P3", "SL", "D", "XSm", "Sm", "Md",
#'   "Lg", "XLg")
#' repvector <- c(0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1)
#' obsvector <- c(0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1)
#' matvector <- c(0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1)
#' immvector <- c(0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0)
#' propvector <- c(1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)
#' indataset <- c(0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1)
#' binvec <- c(0, 0, 0, 0, 0, 0.5, 0.5, 1, 1, 2.5, 7)
#' 
#' cypframe_raw <- sf_create(sizes = sizevector, stagenames = stagevector,
#'   repstatus = repvector, obsstatus = obsvector, matstatus = matvector, 
#'   propstatus = propvector, immstatus = immvector, indataset = indataset,
#'   binhalfwidth = binvec)
#' 
#' cypraw_v1 <- verticalize3(data = cypdata, noyears = 6, firstyear = 2004,
#'   patchidcol = "patch", individcol = "plantid", blocksize = 4, 
#'   sizeacol = "Inf2.04", sizebcol = "Inf.04", sizeccol = "Veg.04", 
#'   repstracol = "Inf.04", repstrbcol = "Inf2.04", fecacol = "Pod.04",
#'   stageassign = cypframe_raw, stagesize = "sizeadded", NAas0 = TRUE, 
#'   NRasRep = TRUE)
#' 
#' cypsupp3r <- supplemental(stage3 = c("SD", "SD", "P1", "P1", "P2", "P3", "SL",
#'     "D", "XSm", "Sm", "D", "XSm", "Sm", "mat", "mat", "mat", "SD", "P1"),
#'   stage2 = c("SD", "SD", "SD", "SD", "P1", "P2", "P3", "SL", "SL", "SL", "SL",
#'     "SL", "SL", "D", "XSm", "Sm", "rep", "rep"),
#'   stage1 = c("SD", "rep", "SD", "rep", "SD", "P1", "P2", "P3", "P3", "P3",
#'     "SL", "SL", "SL", "SL", "SL", "SL", "mat", "mat"),
#'   eststage3 = c(NA, NA, NA, NA, NA, NA, NA, "D", "XSm", "Sm", "D", "XSm", "Sm",
#'     "mat", "mat", "mat", NA, NA),
#'   eststage2 = c(NA, NA, NA, NA, NA, NA, NA, "XSm", "XSm", "XSm", "XSm", "XSm",
#'     "XSm", "D", "XSm", "Sm", NA, NA),
#'   eststage1 = c(NA, NA, NA, NA, NA, NA, NA, "XSm", "XSm", "XSm", "XSm", "XSm",
#'     "XSm", "XSm", "XSm", "XSm", NA, NA),
#'   givenrate = c(0.1, 0.1, 0.2, 0.2, 0.2, 0.2, 0.25, NA, NA, NA, NA, NA, NA,
#'     NA, NA, NA, NA, NA),
#'   multiplier = c(NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
#'     NA, 0.5, 0.5),
#'   type = c(1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3),
#'   type_t12 = c(1, 2, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1),
#'   stageframe = cypframe_raw, historical = TRUE)
#' 
#' cypmatrix3r <- rlefko3(data = cypraw_v1, stageframe = cypframe_raw,
#'   year = "all", patch = "all", stages = c("stage3", "stage2", "stage1"),
#'   size = c("size3added", "size2added", "size1added"),
#'   supplement = cypsupp3r, yearcol = "year2", patchcol = "patchid",
#'   indivcol = "individ")
#' 
#' cypcondmats <- cond_hmpm(cypmatrix3r)
#' summary(cypcondmats)
#' 
#' @export cond_hmpm
cond_hmpm <- function(hmpm, matchoice = NULL, err_check = NULL) {
    .Call('_lefko3_cond_hmpm', PACKAGE = 'lefko3', hmpm, matchoice, err_check)
}

#' Extract Conditional Ahistorical Difference Matrices
#' 
#' Function \code{cond_diff()} takes a set of historical difference matrices
#' resulting from function \code{\link{diff_lM}()} and decomposes them into 
#' ahistorical difference matrices conditional upon stage in time \emph{t}-1.
#' 
#' @param lDiff An object of class \code{lefkoDiff}.
#' @param ref Choice of mpm to use as reference. Defaults to \code{1}, which
#' means that the \code{ahstages}, \code{hstages}, and \code{labels} elements
#' for mpm1 will be used for all calculations. Only \code{1} amd \code{2} are
#' possible inputs.
#' @param matchoice A character denoting whether to use A, U, or F matrices.
#' Defaults to \code{A} matrices.
#' @param err_check A logical value denoting whether to include a data frame
#' of element equivalence from the conditional matrices to the original
#' matrices. Used only for debugging purposes. Defaults to \code{FALSE}.
#' 
#' @return A \code{lefkoCondDiff} object, with the following elements:
#' 
#' \item{Mcond}{A multi-level list holding the conditional matrices derived
#' from the input \code{lefkoDiff} object. The top level of the list
#' corresponds to each historical difference matrix in turn, and the lower
#' level corresponds to each stage in time \emph{t}-1, with individual
#' conditional matrices named for the latter.}
#' \item{hstages}{A data frame matrix showing the pairing of ahistorical stages
#' used to create historical stage pairs.}
#' \item{ahstages}{A data frame detailing the characteristics of associated
#' ahistorical stages.}
#' \item{labels}{A data frame showing the patch and year of each input full A 
#' matrix in order.}
#' 
#' @examples
#' sizevector <- c(0, 0, 0, 0, 0, 0, 1, 3, 6, 11, 19.5)
#' stagevector <- c("SD", "P1", "P2", "P3", "SL", "D", "XSm", "Sm", "Md", "Lg",
#'   "XLg")
#' repvector <- c(0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1)
#' obsvector <- c(0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1)
#' matvector <- c(0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1)
#' immvector <- c(0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0)
#' propvector <- c(1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)
#' indataset <- c(0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1)
#' binvec <- c(0, 0, 0, 0, 0, 0.5, 0.5, 1.5, 1.5, 3.5, 5)
#' comments <- c("Dormant seed", "1st yr protocorm", "2nd yr protocorm",
#'   "3rd yr protocorm", "Seedling", "Dormant adult",
#'   "Extra small adult (1 shoot)", "Small adult (2-4 shoots)",
#'   "Medium adult (5-7 shoots)", "Large adult (8-14 shoots)",
#'   "Extra large adult (>14 shoots)")
#' cypframe_raw <- sf_create(sizes = sizevector, stagenames = stagevector, 
#'   repstatus = repvector, obsstatus = obsvector, matstatus = matvector,
#'   propstatus = propvector, immstatus = immvector, indataset = indataset, 
#'   binhalfwidth = binvec, comments = comments)
#' 
#' cypraw_v1 <- verticalize3(data = cypdata, noyears = 6, firstyear = 2004, 
#'   patchidcol = "patch", individcol = "plantid", blocksize = 4,
#'   sizeacol = "Inf2.04", sizebcol = "Inf.04", sizeccol = "Veg.04",
#'   repstracol = "Inf.04", repstrbcol = "Inf2.04", fecacol = "Pod.04",
#'   stageassign = cypframe_raw, stagesize = "sizeadded", NAas0 = TRUE,
#'   NRasRep = TRUE)
#' 
#' seeds_per_pod <- 5000
#' 
#' cypsupp2_raw <- supplemental(stage3 = c("SD", "P1", "P2", "P3", "SL", "SL", "D", 
#'     "XSm", "SD", "P1"),
#'   stage2 = c("SD", "SD", "P1", "P2", "P3", "SL", "SL", "SL", "rep", "rep"),
#'   eststage3 = c(NA, NA, NA, NA, NA, NA, "D", "XSm", NA, NA),
#'   eststage2 = c(NA, NA, NA, NA, NA, NA, "XSm", "XSm", NA, NA),
#'   givenrate = c(0.03, 0.15, 0.1, 0.1, 0.1, 0.05, NA, NA, NA, NA),
#'   multiplier = c(NA, NA, NA, NA, NA, NA, NA, NA, (0.5 * seeds_per_pod),
#'     (0.5 * seeds_per_pod)),
#'   type =c(1, 1, 1, 1, 1, 1, 1, 1, 3, 3),
#'   stageframe = cypframe_raw, historical = FALSE)
#' cypsupp3_raw <- supplemental(stage3 = c("SD", "SD", "P1", "P1", "P2", "P3", "SL",
#'     "D", "XSm", "Sm", "D", "XSm", "Sm", "mat", "mat", "mat", "SD", "P1"),
#'   stage2 = c("SD", "SD", "SD", "SD", "P1", "P2", "P3", "SL", "SL", "SL", "SL",
#'     "SL", "SL", "D", "XSm", "Sm", "rep", "rep"),
#'   stage1 = c("SD", "rep", "SD", "rep", "SD", "P1", "P2", "P3", "P3", "P3",
#'     "SL", "SL", "SL", "SL", "SL", "SL", "mat", "mat"),
#'   eststage3 = c(NA, NA, NA, NA, NA, NA, NA, "D", "XSm", "Sm", "D", "XSm", "Sm",
#'     "mat", "mat", "mat", NA, NA),
#'   eststage2 = c(NA, NA, NA, NA, NA, NA, NA, "XSm", "XSm", "XSm", "XSm", "XSm",
#'     "XSm", "D", "XSm", "Sm", NA, NA),
#'   eststage1 = c(NA, NA, NA, NA, NA, NA, NA, "XSm", "XSm", "XSm", "XSm", "XSm",
#'     "XSm", "XSm", "XSm", "XSm", NA, NA),
#'   givenrate = c(0.1, 0.1, 0.2, 0.2, 0.2, 0.2, 0.25, NA, NA, NA, NA, NA, NA,
#'     NA, NA, NA, NA, NA),
#'   multiplier = c(NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
#'     NA, 0.5, 0.5),
#'   type = c(1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3),
#'   type_t12 = c(1, 2, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1),
#'   stageframe = cypframe_raw, historical = TRUE)
#' 
#' cypmatrix2rp <- rlefko2(data = cypraw_v1, stageframe = cypframe_raw,
#'   year = "all", patch = "all", stages = c("stage3", "stage2"),
#'   size = c("size3added", "size2added"), supplement = cypsupp2_raw, 
#'   yearcol = "year2", patchcol = "patchid", indivcol = "individ")
#' 
#' cypmatrix2r <- rlefko2(data = cypraw_v1, stageframe = cypframe_raw,
#'   year = "all", stages = c("stage3", "stage2"),
#'   size = c("size3added", "size2added"), supplement = cypsupp2_raw, 
#'   yearcol = "year2", patchcol = "patchid", indivcol = "individ")
#' 
#' cypmatrix3rp <- rlefko3(data = cypraw_v1, stageframe = cypframe_raw,
#'   year = "all", patch = "all", stages = c("stage3", "stage2", "stage1"), 
#'   size = c("size3added", "size2added", "size1added"), supplement = cypsupp3_raw, 
#'   yearcol = "year2", patchcol = "patchid", indivcol = "individ")
#' 
#' cypmatrix3r <- rlefko3(data = cypraw_v1, stageframe = cypframe_raw,
#'   year = "all", stages = c("stage3", "stage2", "stage1"), 
#'   size = c("size3added", "size2added", "size1added"), supplement = cypsupp3_raw, 
#'   yearcol = "year2", patchcol = "patchid", indivcol = "individ")
#' 
#' cypmatrix2r_3 <- hist_null(cypmatrix2r)
#' cypmatrix2r_3 <- delete_lM(cypmatrix2r_3, year = 2004)
#' diff_r <- diff_lM(cypmatrix3r, cypmatrix2r_3)
#' 
#' cypmatrix2rp_3 <- hist_null(cypmatrix2rp)
#' cypmatrix2rp_3 <- delete_lM(cypmatrix2rp_3, year = 2004)
#' diff_rp <- diff_lM(cypmatrix3rp, cypmatrix2rp_3)
#' 
#' condr1 <- cond_diff(diff_r, ref = 1)
#' condr2 <- cond_diff(diff_r, ref = 2)
#' 
#' condrp1 <- cond_diff(diff_rp, matchoice = "U", ref = 1)
#' condrp2 <- cond_diff(diff_rp, matchoice = "F", ref = 2)
#' 
#' @export cond_diff
cond_diff <- function(lDiff, ref = 1L, matchoice = NULL, err_check = NULL) {
    .Call('_lefko3_cond_diff', PACKAGE = 'lefko3', lDiff, ref, matchoice, err_check)
}

#' Two-parameter Ricker function
#' 
#' Function \code{ricker3()} creates a vector of values produced by the two-
#' parameter Ricker function as applied with a user-specified time lag. The
#' two-parameter Ricker function is given as 
#' \eqn{\phi_{t+1} = \phi_t \alpha e^{-\beta n_t}}. Here, if no
#' \code{separate_N} vector is provided, then \eqn{n_t = \phi_t}.
#' 
#' @param start_value A positive number to start the return vector in time 0.
#' @param alpha The alpha parameter in the two-parameter Ricker function. Must
#' be non-negative.
#' @param beta The beta parameter in the two-parameter Ricker function.
#' @param time_steps The number of time steps to run the projection. Must be a
#' positive integer.
#' @param time_lag A positive integer denoting the number of time steps back
#' for the value of phi in the two-parameter Ricker function.
#' @param pre0_subs A logical value indicating whether to use a number other
#' than that given in \code{start_value} for values of phi lagged from times
#' prior to time 0.
#' @param pre0_value A positive number to use for phi lagged from times prior
#' to time 0. Only used if \code{pre0_subs = TRUE}.
#' @param substoch An integer value indicating the kind of substochasticity to
#' use. Values include: \code{0}, no substochasticity enforced (the default);
#' \code{1}, all numbers must be non-negative; and \code{2}, all numbers should
#' be forced to the interval [0, 1].
#' @param separate_N An optional numeric vector with values of N in each time,
#' if phi is to be treated as different from N in the two-parameter model.
#' 
#' @return A numeric vector of values showing values projected under the two-
#' parameter Ricker function.
#' 
#' @examples
#' trial_run1 <- ricker3(1, alpha = 0.5, beta = -0.009)
#' plot(trial_run1)
#' 
#' trial_run2 <- ricker3(1, alpha = 0.5, beta = 0.009)
#' plot(trial_run2)
#' 
#' trial_run3 <- ricker3(1, alpha = 1, beta = -0.009)
#' plot(trial_run3)
#' 
#' trial_run4 <- ricker3(1, alpha = 1, beta = 0.009)
#' plot(trial_run4)
#' 
#' trial_run5 <- ricker3(1, alpha = 5, beta = -0.009)
#' plot(trial_run5)
#' 
#' trial_run6 <- ricker3(1, alpha = 5, beta = 0.009)
#' plot(trial_run6)
#' 
#' used_Ns <- c(10, 15, 12, 14, 14, 150, 15, 1, 5, 7, 9, 14, 13, 16, 17, 19,
#'   25, 26)
#' trial_run7 <- ricker3(1, alpha = 1, beta = -0.009, separate_N = used_Ns)
#' plot(trial_run7)
#' 
#' @export ricker3
ricker3 <- function(start_value, alpha, beta, time_steps = 100L, time_lag = 1L, pre0_subs = FALSE, pre0_value = 0.0, substoch = 0L, separate_N = NULL) {
    .Call('_lefko3_ricker3', PACKAGE = 'lefko3', start_value, alpha, beta, time_steps, time_lag, pre0_subs, pre0_value, substoch, separate_N)
}

#' Two-parameter Beverton-Holt function
#' 
#' Function \code{beverton3()} creates a vector of values produced by the two-
#' parameter Beverton-Holt function as applied with a user-specified time lag.
#' The two-parameter Beverton-Holt function is given as 
#' \eqn{\phi_{t+1} = \phi_t \alpha / (1 + \beta n_t)}. Here, if no
#' \code{separate_N} vector is provided, then \eqn{n_t = \phi_t}.
#' 
#' @param start_value A positive number to start the return vector in time 0.
#' @param alpha The alpha parameter in the two-parameter Beverton-Holt
#' function. Must be non-negative.
#' @param beta The beta parameter in the two-parameter Beverton-Holt function.
#' Must be non-negative.
#' @param time_steps The number of time steps to run the projection. Must be a
#' positive integer.
#' @param time_lag A positive integer denoting the number of time steps back
#' for the value of phi in the two-parameter Beverton-Holt function.
#' @param pre0_subs A logical value indicating whether to use a number other
#' than that given in \code{start_value} for values of phi lagged from times
#' prior to time 0.
#' @param pre0_value A positive number to use for phi lagged from times prior
#' to time 0. Only used if \code{pre0_subs = TRUE}.
#' @param substoch An integer value indicating the kind of substochasticity to
#' use. Values include: \code{0}, no substochasticity enforced (the default);
#' \code{1}, all numbers must be non-negative; and \code{2}, all numbers should
#' be forced to the interval [0, 1].
#' @param separate_N An optional numeric vector with values of N in each time,
#' if phi is to be treated as different from N in the two-parameter model.
#' 
#' @return A numeric vector of values showing values projected under the two-
#' parameter Beverton-Holt function.
#' 
#' @examples
#' trial_run1 <- beverton3(1, alpha = 0.5, beta = 0.009)
#' plot(trial_run1)
#' 
#' trial_run2 <- beverton3(1, alpha = 0.5, beta = 0.9)
#' plot(trial_run2)
#' 
#' trial_run3 <- beverton3(1, alpha = 1, beta = 0.009)
#' plot(trial_run3)
#' 
#' trial_run4 <- beverton3(1, alpha = 1, beta = 0.9)
#' plot(trial_run4)
#' 
#' trial_run5 <- beverton3(1, alpha = 5, beta = 0.009)
#' plot(trial_run5)
#' 
#' trial_run6 <- beverton3(1, alpha = 5, beta = 0.9)
#' plot(trial_run6)
#' 
#' used_Ns <- c(10, 15, 12, 14, 14, 150, 15, 1, 5, 7, 9, 14, 13, 16, 17, 19,
#'   25, 26)
#' trial_run7 <- beverton3(1, alpha = 1, beta = 0.009, separate_N = used_Ns)
#' plot(trial_run7)
#' 
#' @export beverton3
beverton3 <- function(start_value, alpha, beta, time_steps = 100L, time_lag = 1L, pre0_subs = FALSE, pre0_value = 0.0, substoch = 0L, separate_N = NULL) {
    .Call('_lefko3_beverton3', PACKAGE = 'lefko3', start_value, alpha, beta, time_steps, time_lag, pre0_subs, pre0_value, substoch, separate_N)
}

#' Two-parameter Usher function
#' 
#' Function \code{usher3()} creates a vector of values produced by the two-
#' parameter Usher function as applied with a user-specified time lag.
#' The Usher function is given as 
#' \eqn{\phi_{t+1} = \phi_t / (1 + e^{\alpha n_t + \beta})}. Here,
#' if no \code{separate_N} vector is provided, then \eqn{n_t = \phi_t}.
#' 
#' @param start_value A positive number to start the return vector in time 0.
#' @param alpha The alpha parameter in the two-parameter Usher
#' function.
#' @param beta The beta parameter in the two-parameter Usher function.
#' @param time_steps The number of time steps to run the projection. Must be a
#' positive integer.
#' @param time_lag A positive integer denoting the number of time steps back
#' for the value of phi in the two-parameter Usher function.
#' @param pre0_subs A logical value indicating whether to use a number other
#' than that given in \code{start_value} for values of phi lagged from times
#' prior to time 0.
#' @param pre0_value A positive number to use for phi lagged from times prior
#' to time 0. Only used if \code{pre0_subs = TRUE}.
#' @param substoch An integer value indicating the kind of substochasticity to
#' use. Values include: \code{0}, no substochasticity enforced (the default);
#' \code{1}, all numbers must be non-negative; and \code{2}, all numbers should
#' be forced to the interval [0, 1].
#' @param separate_N An optional numeric vector with values of N in each time,
#' if phi is to be treated as different from N in the two-parameter model.
#' 
#' @return A numeric vector of values showing values projected under the two-
#' parameter Usher function.
#' 
#' @examples
#' trial_run1 <- usher3(1, alpha = -0.5, beta = 0.005)
#' plot(trial_run1)
#' 
#' trial_run2 <- usher3(1, alpha = 0.5, beta = 0.005)
#' plot(trial_run2)
#' 
#' trial_run3 <- usher3(1, alpha = -5, beta = 0.005)
#' plot(trial_run3)
#' 
#' trial_run4 <- usher3(1, alpha = 5, beta = 0.005)
#' plot(trial_run4)
#' 
#' trial_run5 <- usher3(1, alpha = -25, beta = 0.005)
#' plot(trial_run5)
#' 
#' trial_run6 <- usher3(1, alpha = 25, beta = 0.005)
#' plot(trial_run6)
#' 
#' used_Ns <- c(10, 15, 12, 14, 14, 150, 15, 1, 5, 7, 9, 14, 13, 16, 17, 19,
#'   25, 26)
#' trial_run7 <- usher3(1, alpha = -0.5, beta = 0.005, separate_N = used_Ns)
#' plot(trial_run7)
#' 
#' @export usher3
usher3 <- function(start_value, alpha, beta, time_steps = 100L, time_lag = 1L, pre0_subs = FALSE, pre0_value = 0.0, substoch = 0L, separate_N = NULL) {
    .Call('_lefko3_usher3', PACKAGE = 'lefko3', start_value, alpha, beta, time_steps, time_lag, pre0_subs, pre0_value, substoch, separate_N)
}

#' Two-parameter logistic function
#' 
#' Function \code{logistic3()} creates a vector of values produced by the
#' logistic function as applied with a user-specified time lag. The logistic
#' function is given as 
#' \eqn{\phi_{t+1} = \phi_t \lambda (1 - n_t / K)}. Here,
#' if no \code{separate_N} vector is provided, then \eqn{n_t = \phi_t}. If
#' \eqn{\lambda} is not provided, then it defaults to \code{1.0}.
#' 
#' @param start_value A positive number to start the return vector in time 0.
#' @param alpha The carrying capacity K.
#' @param beta If set to some positive number, then this number is the maximum
#' value of phi to enforce. Otherwise, equals \code{0} and enforces no limit.
#' @param lambda The value of the discrete population growth rate to use.
#' Equal to the natural logarithm of the instantaneous growth rate, r.
#' @param time_steps The number of time steps to run the projection. Must be a
#' positive integer.
#' @param time_lag A positive integer denoting the number of time steps back
#' for the value of phi in the logistic function.
#' @param pre0_subs A logical value indicating whether to use a number other
#' than that given in \code{start_value} for values of phi lagged from times
#' prior to time 0.
#' @param pre0_value A positive number to use for phi lagged from times prior
#' to time 0. Only used if \code{pre0_subs = TRUE}.
#' @param substoch An integer value indicating the kind of substochasticity to
#' use. Values include: \code{0}, no substochasticity enforced (the default);
#' \code{1}, all numbers must be non-negative; and \code{2}, all numbers should
#' be forced to the interval [0, 1].
#' @param separate_N An optional numeric vector with values of N in each time,
#' if phi is to be treated as different from N in the logistic model.
#' 
#' @return A numeric vector of values showing values projected under the-
#' logistic function.
#' 
#' @examples
#' trial_run1 <- logistic3(1, alpha = 5)
#' plot(trial_run1)
#' 
#' trial_run2 <- logistic3(1, alpha = 5, beta = 5)
#' plot(trial_run2)
#' 
#' trial_run3 <- logistic3(1, alpha = 100)
#' plot(trial_run3)
#' 
#' trial_run4 <- logistic3(1, alpha = 100, beta = 50)
#' plot(trial_run4)
#' 
#' trial_run5 <- logistic3(1, alpha = 500)
#' plot(trial_run5)
#' 
#' trial_run6 <- logistic3(1, alpha = 500, beta = 501)
#' plot(trial_run6)
#' 
#' used_Ns <- c(10, 15, 12, 14, 14, 150, 15, 1, 5, 7, 9, 14, 13, 16, 17, 19,
#'   25, 26)
#' trial_run7 <- logistic3(1, alpha = 500, beta = 501, separate_N = used_Ns)
#' plot(trial_run7)
#' 
#' @export logistic3
logistic3 <- function(start_value, alpha, beta = 0.0, lambda = 1.0, time_steps = 100L, time_lag = 1L, pre0_subs = FALSE, pre0_value = 0.0, substoch = 0L, separate_N = NULL) {
    .Call('_lefko3_logistic3', PACKAGE = 'lefko3', start_value, alpha, beta, lambda, time_steps, time_lag, pre0_subs, pre0_value, substoch, separate_N)
}

#' Main Formula Creation for Function \code{modelsearch()}
#'
#' Function \code{.stovokor()} creates formulae to be used as input in the
#' global model calls used in function \code{\link{modelsearch}()}.
#'
#' @param surv A vector of strings indicating the names of the variables coding
#' survival.
#' @param obs A vector of strings indicating the names of the variables coding
#' observation status.
#' @param size A vector of strings indicating the names of the variables coding
#' primary size.
#' @param sizeb A vector of strings indicating the names of the variables
#' coding secondary size.
#' @param sizec A vector of strings indicating the names of the variables
#' coding tertiary size.
#' @param repst A vector of strings indicating the names of the variables
#' coding reproductive status.
#' @param fec A vector of strings indicating the names of the variables coding
#' fecundity.
#' @param matstat A vector of strings indicating the names of the variables
#' coding for maturity status.
#' @param vitalrates A vector of strings indicating which vital rates will be
#' estimated.
#' @param historical A logical value indicating whether to create global models
#' with historical effects.
#' @param suite A string indicating the scope of independent factors included
#' in the global models. Options include \code{"full"}, \code{"main"},
#' \code{"size"}, \code{"rep"}, and \code{"const"}.
#' @param approach A string indicating whether to use mixed model encoding 
#' (\code{"mixed"}) or GLM encoding (\code{"glm"}).
#' @param nojuvs A logical value indicating that juvenile rates should be
#' estimated (\code{FALSE}) or not (\code{TRUE}).
#' @param age A string indicating the name of the variable coding age.
#' @param indcova A vector of strings indicating the names in times \emph{t}+1,
#' \emph{t}, and \emph{t}-1 of a specific individual covariate used in the
#' dataset.
#' @param indcovb A vector of strings indicating the names in times \emph{t}+1,
#' \emph{t}, and \emph{t}-1 of a specific individual covariate used in the
#' dataset.
#' @param indcovc A vector of strings indicating the names in times \emph{t}+1,
#' \emph{t}, and \emph{t}-1 of a specific individual covariate used in the
#' dataset.
#' @param indiv A string indicating the name of the variable coding individual
#' identity.
#' @param patch A string indicating the name of the variable coding patch
#' identity.
#' @param year A string indicating the name of the variable coding time
#' \emph{t}.
#' @param pasrand A logical value indicating whether to treat patch as a random
#' variable within mixed models.
#' @param yasrand A logical value indicating whether to treat year as a random
#' variable within mixed models.
#' @param iaasrand A logical value indicating whether to treat indcova as
#' random.
#' @param ibasrand A logical value indicating whether to treat indcovb as
#' random.
#' @param icasrand A logical value indicating whether to treat indcovc as
#' random.
#' @param fectime An integer indicating whether to use reproductive output in
#' time \emph{t} (2) or time \emph{t}+1 (3) as the response for fecundity.
#' @param juvsize A logical value indicating whether to include size terms in
#' juvenile models.
#' @param sizebused A logical value denoting if secondary size variables are to
#' be used.
#' @param sizecused A logical value denoting if tertiary size variables are to
#' be used.
#' @param grouptest A logical value indicating whether to test for group
#' effect.
#' @param densitycol The name of the density variable, or \code{"none"}.
#' @param densityused A logical value indicating whether the density variable
#' is to be used.
#' @param indcovaused Logical value indicating whether individual covariate a
#' is used.
#' @param indcovbused Logical value indicating whether individual covariate b
#' is used.
#' @param indcovcused Logical value indicating whether individual covariate c
#' is used.
#' 
#' @return Vector of 9 strings, each a formula to be used as input in function.
#' \code{modelsearch()}.
#'
#' @keywords internal
#' @noRd
.stovokor <- function(surv, obs, size, sizeb, sizec, repst, fec, matstat, vitalrates, historical, suite, approach, nojuvs, age, indcova, indcovb, indcovc, indiv, patch, year, pasrand, yasrand, iaasrand, ibasrand, icasrand, fectime, juvsize, sizebused, sizecused, grouptest, densitycol, densityused, indcovaused, indcovbused, indcovcused) {
    .Call('_lefko3_stovokor', PACKAGE = 'lefko3', surv, obs, size, sizeb, sizec, repst, fec, matstat, vitalrates, historical, suite, approach, nojuvs, age, indcova, indcovb, indcovc, indiv, patch, year, pasrand, yasrand, iaasrand, ibasrand, icasrand, fectime, juvsize, sizebused, sizecused, grouptest, densitycol, densityused, indcovaused, indcovbused, indcovcused)
}

#' Compares Two Strings Literally
#' 
#' This function compares two strings element by element. Returns \code{FALSE}
#' in case of any differences whatsoever.
#' 
#' @name stringcompare_hard
#' 
#' @param str1 The first string
#' @param str2 The second string
#' 
#' @return A logical value. In case of any difference at all, it will return
#' \code{FALSE}.
#' 
#' @keywords internal
#' @noRd
NULL

#' Compares Two Strings, Assessing Inclusion
#' 
#' This function compares two strings, and will assess whether \code{str2} is
#' contained within \code{str1}.
#' 
#' @name stringcompare_soft
#' 
#' @param str1 The first string
#' @param str2 The second string
#' 
#' @return A list of two values. The first is a logical value indicating
#' whether \code{str2} occurs within \code{str1}. The second element is an
#' integer indicating at what element of \code{str1} \code{str2} begins.
#' \code{FALSE}.
#' 
#' @keywords internal
#' @noRd
NULL

#' Compares Two Strings, Assessing Inclusion
#' 
#' This function compares two strings, and will assess whether \code{str2} is
#' contained within \code{str1}. It is a simpler version of 
#' \code{stringcompare_soft()} that yields only the logical result.
#' 
#' @name stringcompare_simple
#' 
#' @param str1 The first string
#' @param str2 The second string
#' @param lower A logical value indicating whether to change all inputs to
#' lower case before checking.
#' 
#' @return A logical value indicating whether \code{str2} occurs within
#' \code{str1}.
#' 
#' @keywords internal
#' @noRd
NULL

#' Compares Three Strings for Interaction Notation
#' 
#' This function compares checks to see if one string is composed of the other
#' two strings in R's interaction notation.
#' 
#' @name stringcompare_x
#' 
#' @param str1 The first string. Used for comparison.
#' @param str2 The second string. Will be incorporated into interaction format.
#' @param str3 The third string. Will be incorporated into interaction format.
#' 
#' @return A logical value. In case of any difference at all, it will return
#' \code{FALSE}.
#' 
#' @keywords internal
#' @noRd
NULL

#' Sort String Elements
#' 
#' This function is based on code obtained from R Bloggers
#' (see https://www.r-bloggers.com/2013/01/handling-strings-with-rcpp/). It
#' sorts the elements of a string vector in alphabetical order.
#' 
#' @name stringsort
#' 
#' @param string_input A string vector.
#' 
#' @return The sorted string vector.
#' 
#' @keywords internal
#' @noRd
NULL

#' Sort Integer Elements
#' 
#' This function is based on code obtained from the Rcpp Gallery by Ross
#' Bennett (see https://gallery.rcpp.org/articles/sorting/). It sorts the
#' elements of an integer vector.
#' 
#' @name int_sort
#' 
#' @param int_input An integer vector.
#' 
#' @return The sorted integer vector.
#' 
#' @keywords internal
#' @noRd
NULL

#' Function to Index a Numeric Vector According to a Reference Vector
#' 
#' Function \code{refsort_num()} takes a numeric matrix and replaces it with an
#' integer vector showing the position of each element in the input vector
#' within the reference vector.
#' 
#' @name refsort_num
#' 
#' @param vec The matrix to index
#' @param ref The vector to use as a reference
#' 
#' @return An integer vector with integers referring to elements in vector
#' \code{ref}.
#' 
#' @keywords internal
#' @noRd
NULL

#' Function to Index a Numeric Vector According to a Reference Vector
#' 
#' Function \code{refsort_str()} takes a string vector and replaces it with an
#' integer vector showing the position of each element in the input vector
#' within the reference vector.
#' 
#' @name refsort_str
#' 
#' @param vec The vector to index
#' @param ref The vector to use as a reference
#' 
#' @return An integer vector with integers referring to elements in vector
#' \code{ref}.
#' 
#' @keywords internal
#' @noRd
NULL

#' Create hstages Index Object
#' 
#' Function \code{hst_maker()} creates \code{hstages} index data frames from
#' \code{stageframe} inputs.
#' 
#' @name hst_maker
#' 
#' @param sframe The ahistorical stageframe used in MPM development.
#' 
#' @return A data frame with the following columns:
#' \item{stage_id_2}{Integer index of stage in time \emph{t}+1.}
#' \item{stage_id_1}{Integer index of stage in time \emph{t}.}
#' \item{stage_2}{String name of stage in time \emph{t}+1.}
#' \item{stage_1}{String name of stage in time \emph{t}.}
#' 
#' @keywords internal
#' @noRd
NULL

#' Create agestages Index Object
#' 
#' Function \code{age_maker()} creates \code{agestages} index data frames from
#' \code{stageframe} inputs.
#' 
#' @name age_maker
#' 
#' @param sframe The ahistorical stageframe used in MPM development.
#' 
#' @return A data frame with the following columns:
#' \item{stage_id}{Integer index of stage.}
#' \item{stage}{String name of stage.}
#' \item{age}{The age of stage in current time.}
#' 
#' @keywords internal
#' @noRd
NULL

#' Re-index Projection Matrix On Basis of Overwrite Table
#' 
#' Function \code{ovreplace()} takes matrix indices provided by functions
#' \code{\link{rlefko3}()}, \code{\link{rlefko2}()}, \code{\link{flefko3}()},
#' \code{\link{flefko2}()}, and \code{\link{aflefko2}()} and updates them with
#' information provided in the overwrite table used as input in that function.
#' 
#' @name ovreplace
#' 
#' @param allst321 Vector containing the original element-by-element matrix
#' index.
#' @param idx321old Vector containing the indices of matrix elements to be
#' updated.
#' @param idx321new Vector containing the replacement matrix element indices.
#' @param convtype Vector denoting survival transition (1), fecundity (2), or
#' fecundity multiplier (3).
#' @param eststag3 Vector of new stages in time \emph{t}+1.
#' @param gvnrate Vector of replacement transition values.
#' @param multipl Vector of fecundity multipliers.
#' 
#' @return A matrix. Column 1 is the given rate for a survival transitions,
#' Column 2 is the proxy transition to be used to estimate that transition.
#' Column 3 is the given rate for a fecundity transitions. Column 4 is the
#' proxy transition to be used to estimate that transition. Column 5 is a
#' vector of fecundity multipliers, in cases where no given rate or proxy is to
#' be used but fecundity is to be multiplied by some value. Column 6 is a
#' vector of survival transition multipliers. Column 7 is a vector of fecundity
#' transition multipliers.
#' 
#' @keywords internal
#' @noRd
NULL

#' Creates Matrices of Year and Patch Terms in Models
#' 
#' Function \code{revelations()} creates a matrix holding either the year or
#' patch coefficients from all vital rate models. This reduces memory load in
#' functions \code{\link{jerzeibalowski}()}, which may be important in some
#' systems or compilers.
#' 
#' @name revelations
#' 
#' @param survproxy The proxy vital rate model covering survival from the main
#' matrix estimator function.
#' @param obsproxy The proxy vital rate model covering observation status from
#' the main matrix estimator function.
#' @param sizeproxy The proxy vital rate model covering primary size from the
#' main matrix estimator function.
#' @param sizebproxy The proxy vital rate model covering secondary size from
#' the main matrix estimator function.
#' @param sizecproxy The proxy vital rate model covering tertiary size from the
#' main matrix estimator function.
#' @param repstproxy The proxy vital rate model covering reproductive status
#' from the main matrix estimator function.
#' @param fecproxy The proxy vital rate model covering fecundity from the main
#' matrix estimator function.
#' @param jsurvproxy The proxy vital rate model covering juvenile survival from
#' the main matrix estimator function.
#' @param jobsproxy The proxy vital rate model covering juvenile observation
#' status from the main matrix estimator function.
#' @param jsizeproxy The proxy vital rate model covering juvenile primary size
#' from the main matrix estimator function.
#' @param jsizebproxy The proxy vital rate model covering juvenile secondary
#' size from the main matrix estimator function.
#' @param jsizecproxy The proxy vital rate model covering juvenile tertiary
#' size from the main matrix estimator function.
#' @param jrepstproxy The proxy vital rate model covering juvenile reproductive
#' status from the main matrix estimator function.
#' @param jmatstproxy The proxy vital rate model covering juvenile probability
#' of becoming mature from the main matrix estimator function.
#' @param mat_switch An integer coding for year (\code{1}) or patch (\code{2}).
#' 
#' @return A matrix with 14 columns corresponding to the number of vital rates
#' and number of columns equal to the number of year or patches.
#' 
#' @keywords internal
#' @noRd
NULL

#' Creates a Summation of Most Terms Needed in Vital Rate Calculation
#' 
#' Function \code{rimeotam()} provides the majority of the work in creating
#' the linear model sum to be used in vital rate estimation in the MPM. Works
#' specifically with functions \code{\link{jerzeibalowski}()} and
#' \code{\link{motherbalowski}()}.
#' 
#' @name rimeotam
#' 
#' @param maincoefs The coefficients portion of the vital rate model proxy.
#' @param fl1_i Reproductive status in time \emph{t}*-1.
#' @param fl2n_i Reproductive status in time \emph{t}.
#' @param sz1_i Primary size in time \emph{t}-1.
#' @param sz2o_i Primary size in time \emph{t}.
#' @param szb1_i Secondary size in time \emph{t}-1.
#' @param szb2o_i Secondary size in time \emph{t}.
#' @param szc1_i Tertiary size in time \emph{t}-1.
#' @param szc2o_i Tertiary size in time \emph{t}.
#' @param aage2_i Used age in time \emph{t}.
#' @param inda_1 Value of numeric individual covariate a in time \emph{t}-1.
#' @param inda_2 Value of numeric individual covariate a in time \emph{t}.
#' @param indb_1 Value of numeric individual covariate b in time \emph{t}-1.
#' @param indb_2 Value of numeric individual covariate b in time \emph{t}.
#' @param indc_1 Value of numeric individual covariate c in time \emph{t}-1.
#' @param indc_2 Value of numeric individual covariate c in time \emph{t}.
#' @param used_dens Density value used.
#' @param zi A logical value indicating whether model coefficients refer to the
#' zero inflation portion of a model.
#' 
#' @return A single numeric value giving the sum of the products of the linear
#' coefficients and the used status values.
#' 
#' @keywords internal
#' @noRd
NULL

#' Counts Numbers of Elements in Each Random Individual Covariate Portion of
#' Model
#' 
#' Function \code{foi_counter()} counts the number of elements in each random
#' individual covariate and returns that as a vector.
#' 
#' @name foi_counter
#' 
#' @param modelproxy A list holding the contents of a model processed with
#' function \code{\link{.modelextract}()}
#' @param zi A logical value indicating whether to focus on the zero-inflation
#' parameters.
#' 
#' @return A 6 element vector holding the numbers of elements in each random
#' individual covariate in a model (either the cont portion or the zi portion).
#' 
#' @keywords internal
#' @noRd
NULL

#' Create Vector of Random Individual Covariate Terms
#' 
#' Function \code{flightoficarus()} creates vectors of random covariate
#' terms.
#' 
#' @name flightoficarus
#' 
#' @param modelproxy A model proxy list extracted with function
#' \code{\link{.modelextract}()}.
#' 
#' @return A vector of numeric values for random categorical terms. The order
#' is: 1) cov a time 2, 2) cov a time 1, 3) cov b time 2, 4) cov b time 1,
#' 5) cov c time 2, and 6) cov c time 1. Rows may vary, but must be the same
#' length for each model.
#' 
#' @keywords internal
#' @noRd
NULL

#' Create Concatenated Vector of Random Individual Covariate Term Names
#' 
#' Function \code{bootson()} creates a concatenated string vector holding all
#' covariate term names.
#' 
#' @name bootson
#' 
#' @param modelproxy A model proxy list extracted with function
#' \code{\link{.modelextract}()}.
#' 
#' @return A vector holding all covariate name terms. The order is: 1) cov a
#' time 2, 2) cov a time 1, 3) cov b time 2, 4) cov b time 1, 5) cov c time 2,
#' and 6) cov c time 1. Note that the element order is the same as in function
#' \code{\link{.flightoficarus}()}.
#' 
#' @keywords internal
#' @noRd
NULL

#' Create Vector of Random Individual Covariate Terms for Zero-Inflated Models
#' 
#' Function \code{zero_flightoficarus()} creates vectors of random covariate
#' terms from the binomial portion of a zero-inflated model.
#' 
#' @name zero_flightoficarus
#' 
#' @param modelproxy A model proxy list extracted with function
#' \code{\link{.modelextract}()}.
#' 
#' @return A vector of numeric values for random categorical terms. The order
#' is: 1) cov a time 2, 2) cov a time 1, 3) cov b time 2, 4) cov b time 1,
#' 5) cov c time 2, and 6) cov c time 1. Rows may vary, but must be the same
#' length for each model.
#' 
#' @keywords internal
#' @noRd
NULL

#' Create Concatenated Vector of Random Individual Covariate Term Names from
#' a Zero-Inflated Model
#' 
#' Function \code{zero_bootson()} creates a concatenated string vector holding
#' all covariate term names from the binomial portion of a zero-inflated model.
#' 
#' @name zero_bootson
#' 
#' @param modelproxy A model proxy list extracted with function
#' \code{\link{.modelextract}()}.
#' 
#' @return A vector holding all covariate name terms. The order is: 1) cov a
#' time 2, 2) cov a time 1, 3) cov b time 2, 4) cov b time 1, 5) cov c time 2,
#' and 6) cov c time 1. Note that the element order is the same as in function
#' \code{\link{.zero_flightoficarus}()}.
#' 
#' @keywords internal
#' @noRd
NULL

#' Create Index of Element Numbers for Random Individual Covariate Terms
#' 
#' Function \code{foi_index()} creates a matrix indexing the end points of
#' each random individual covariate in the utilized vectors.
#' 
#' @name foi_index
#' 
#' @param surv_proxy Adult survival model proxy.
#' @param obs_proxy Adult observation status model proxy.
#' @param size_proxy Adult primary size model proxy.
#' @param sizeb_proxy Adult secondary size model proxy.
#' @param sizec_proxy Adult tertiary size model proxy.
#' @param repst_proxy Adult reproductive status model proxy.
#' @param fec_proxy Adult fecundity model proxy.
#' @param jsurv_proxy Juvenile survival model proxy.
#' @param jobs_proxy Juvenile observation status model proxy.
#' @param jsize_proxy Juvenile primary size model proxy.
#' @param jsizeb_proxy Juvenile secondary size model proxy.
#' @param jsizec_proxy Juvenile tertiary size model proxy.
#' @param jrepst_proxy Juvenile reproductive status model proxy.
#' @param jmatst_proxy Juvenile maturity status model proxy.
#' 
#' @return An integer matrix with 6 rows and 20 columns. The columns contain
#' the number of elements in each random individual covariate term, with the
#' row order being: 1) cov a t2, 2) cov a t1, 3) cov b t2, 4) cov b t1,
#' 5) cov c t2, and 6) cov c t1.
#' 
#' @keywords internal
#' @noRd
NULL

#' Estimate Value for Vital Rate Based on Inputs
#' 
#' Function \code{preouterator()} calculates the value of the vital rate called
#' for by the function \code{jerzeibalowski()}..
#' 
#' @name preouterator
#' 
#' @param modelproxy A model_proxy object derived from function
#' \code{modelextract()}.
#' @param maincoefs The coefficients portion of the vital rate model proxy.
#' @param randindex An integer matrix indexing all random covariates for all
#' vital rates.
#' @param dev_terms A numeric vector containing the deviations to the linear
#' models input by the user. The order is: survival, observation status, size,
#' size_b, size_c, reproductive status, fecundity, juvenile survival, juvenile
#' observation status, juvenile size, juvenile size_b, juvenile size_c,
#' and juvenile reproductive status.
#' @param vitalyear A matrix with year coefficients for all vital rates.
#' @param vitalpatch A matrix with patch coefficients for all vital rates.
#' @param chosen_r2inda A string identifying random covariate a in time t.
#' @param chosen_r1inda A string identifying random covariate a in time t-1.
#' @param chosen_r2indb A string identifying random covariate b in time t.
#' @param chosen_r1indb A string identifying random covariate b in time t-1.
#' @param chosen_r2indc A string identifying random covariate c in time t.
#' @param chosen_r1indc A string identifying random covariate c in time t-1.
#' @param status_terms A NumericVector containing, in order: fl1_i, fl2n_i,
#' sz1_i, sz2o_i, szb1_i, szb2o_i, szc1_i, szc2o_i, aage2_i, inda_1, inda_2,
#' indb_1, indb_2, indc_1, indc_2, used_dens, sz3_i, szb3_i, szc3_i,
#' binwidth3_i, binbwidth3_i, and bincwidth3_i.
#' @param modelgroups2 A vector of group slope coefficients for time t.
#' @param modelgroups1 A vector of group slope coefficients for time t-1.
#' @param modelgroups2zi A vector of zero-inflation model group slope
#' coefficients for time t.
#' @param modelgroups1zi A vector of zero-inflation model group slope
#' coefficients for time t-1.
#' @param modelyearzi A vector of zero-inflation model time slope coefficients.
#' @param modelpatchzi A vector of zero-inflation model patch slope coefficients.
#' @param modelind A vector of individual covariate slope coefficients.
#' @param modelind_rownames A string vector with the names of the individual
#' covariate coefficients.
#' @param modelindzi A vector of individual covariate slope coefficients.
#' @param modelind_rownames_zi A string vector with the names of the individual
#' covariate coefficients.
#' @param zi A logical value indicating whether model coefficients refer to the
#' zero inflation portion of a model.
#' @param sigma The sigma term in the \code{modelproxy} object.
#' @param grp2o_i Stage group number in time \emph{t}.
#' @param grp1_i Stage group number in time \emph{t}-1.
#' @param patchnumber An integer index for pop-patch.
#' @param yearnumber An integer index for monitoring occasion in time \emph{t}.
#' @param vitaldist A parameter specifying the distribution of the vital rate.
#' Current options are: Poisson (0), negative binomial (1), Gaussian (2),
#' Gamma (3), and binomial (4).
#' @param vitalrate An integer specifying the vital rate. 1 = surv, 2 = obs,
#' 3 = size, 4 = sizeb, 5 = sizec, 6 = repst, 7 = fec, 8 = jsurv, 9 = jobs,
#' 10 = jsize, 11 = jsizeb, 12 = jsizec, 13 = jrepst, 14 = jmatst.
#' @param exp_tol A numeric value indicating the maximum limit for the
#' \code{exp()} function to be used in vital rate calculations. Defaults to
#' \code{700.0}.
#' @param theta_tol A numeric value indicating a maximum value for theta in
#' negative binomial probability density estimation. Defaults to
#' \code{100000000.0}.
#' @param ipm_cdf A logical value indicating whether to use the cumulative
#' density function to estimate size transitions in continuous distributions
#' (\code{true}), or the midpoint method (\code{false}).
#' @param matrixformat An integer representing the style of matrix to develop.
#' Options include Ehrlen-format hMPM (1), deVries-format hMPM (2), ahMPM (3),
#' and age-by-stage MPM (4).
#' @param fecmod A scalar multiplier for fecundity.
#' @param repentry_i Rep entry value for time t+1.
#' @param negfec A logical value denoting whether to change negative estimated
#' fecundity to 0.
#' @param stage2n_i Numeric index of stage in time t.
#' @param nostages The total number of stages in the stageframe.
#' @param modeltrunc An integer coding for zero-truncation status.
#' 
#' @return A class double numeric value for the vital rate being estimated.
#' 
#' @keywords internal
#' @noRd
NULL

#' Creates Matrices of Year and Patch Terms in Leslie Models
#' 
#' Function \code{revelations_leslie()} creates a matrix holding either the
#' year or patch coefficients from Leslie vital rate models. This reduces
#' memory load in function \code{\link{motherbalowski}()}.
#' 
#' @name revelations_leslie
#' 
#' @param survproxy The proxy vital rate model covering survival from the main
#' matrix estimator function.
#' @param fecproxy The proxy vital rate model covering fecundity from the main
#' matrix estimator function.
#' 
#' @return A matrix with 2 columns corresponding to the number of vital rates
#' and number of columns equal to the number of year or patches.
#' 
#' @keywords internal
#' @noRd
NULL

#' Create Index of Element Numbers for Random Individual Covariate Terms in
#' Leslie Models
#' 
#' Function \code{foi_index_leslie()} creates a matrix indexing the end points
#' of each random individual covariate in the utilized vectors. Used in
#' function \code{\link{motherbalowski}()}.
#' 
#' @name foi_index_leslie
#' 
#' @param surv_proxy Adult survival model proxy.
#' @param fec_proxy Adult fecundity model proxy.
#' 
#' @return An integer matrix with 6 rows and 3 columns. The columns contain the
#' number of elements in each random individual covariate term, with the row
#' order being: 1) cov a t2, 2) cov a t1, 3) cov b t2, 4) cov b t1,
#' 5) cov c t2, and 6) cov c t1.
#' 
#' @keywords internal
#' @noRd
NULL

#' Extract Key Components from Simple Numerical Model
#' 
#' This function creates a skeleton list needed for functions
#' \code{jerzeibalowski()} and \code{motherbalowski()}, when a vital rate model
#' is simply a scalar.
#' 
#' @name numeric_extractor
#' 
#' @param object A numerical value, typical \code{1} or \code{0}.
#' 
#' @return A list with the following elements:
#' \item{class}{The exact class of \code{object}. Will generally be
#' \code{numeric}.}
#' \item{family}{The response distribution. Here, given as \code{constant}.}
#' \item{dist}{An integer representing the response distribution. \code{0} = 
#' poisson, \code{1} = negbin, \code{2} = gaussian, \code{3} = gamma, \code{4}
#' = binomial, and \code{5} = constant.}
#' \item{zero_inflated}{A logical value indicating whether the distribution is
#' zero-inflated.}
#' \item{zero_truncated}{A logical value indicating whether the distribution is
#' zero-truncated.}
#' \item{all_vars}{A vector holding the names of each variable used by
#' \code{object}. Here, given as \code{NULL}.}
#' \item{fixed_vars}{A string vector holding the names of the fixed variables.
#' Here, given as \code{NULL}.}
#' \item{fixed_slopes}{A numeric vector holding the slope coefficients of the
#' fixed variables, in the same order as \code{fixed_vars}. Here, given as
#' \code{NULL}.}
#' \item{fixed_zi_vars}{A string vector holding the names of the zero-inflated
#' fixed variables. Not used in \code{lm}/\code{glm}/\code{negbin} objects.
#' Here, given as \code{NULL}.}
#' \item{fixed_zi_slopes}{A numeric vector holding the slope coefficients of
#' the zero-inflated fixed variables, in the same order as
#' \code{fixed_zi_vars}. Here, given as \code{NULL}.}
#' \item{random_zi_vars}{A string vector holding the names of the random
#' variables in the sero-inflation model. Here, given as \code{NULL}.}
#' \item{random_zi_slopes}{A numeric vector holding the slope coefficients of
#' the random variables in the zero-inflation model, in the same order as
#' \code{random_zi_vars}. Here, given as \code{NULL}.}
#' \item{sigma}{The residual standard deviation of the model. Defaults to
#' \code{1.0}.}
#' \item{theta}{The estimated theta, if the response is negative binomial.
#' Otherwise, will equal \code{1.0}.}
#' 
#' @keywords internal
#' @noRd
NULL

#' Extract Key Components of lm/glm/negbin Objects
#' 
#' This function extracts the components of an \code{lm}, \code{glm}, or
#' \code{negbin} (function \code{glm.nb()}) object needed for functions
#' \code{jerzeibalowski()} and \code{motherbalowski()}.
#' 
#' @name glm_extractor
#' 
#' @param object An \code{lm}, \code{glm}, or \code{negbin} object.
#' 
#' @return A list with the following elements:
#' \item{class}{The exact class of \code{object}. Will generally be either
#' \code{lm} or \code{glm}.}
#' \item{family}{The response distribution.}
#' \item{dist}{An integer representing the response distribution. \code{0} = 
#' poisson, \code{1} = negbin, \code{2} = gaussian, \code{3} = gamma, \code{4}
#' = binomial, and \code{5} = constant.}
#' \item{zero_inflated}{A logical value indicating whether the distribution is
#' zero-inflated. Not used in \code{lm}/\code{glm}/\code{negbin} objects.}
#' \item{zero_truncated}{A logical value indicating whether the distribution is
#' zero-truncated. Not used in \code{lm}/\code{glm}/\code{negbin} objects.}
#' \item{all_vars}{A vector holding the names of each variable used by
#' \code{object}.}
#' \item{fixed_vars}{A string vector holding the names of the fixed variables.}
#' \item{fixed_slopes}{A numeric vector holding the slope coefficients of the
#' fixed variables, in the same order as \code{fixed_vars}.}
#' \item{fixed_zi_vars}{A string vector holding the names of the zero-inflated
#' fixed variables. Not used in \code{lm}/\code{glm}/\code{negbin} objects.}
#' \item{fixed_zi_slopes}{A numeric vector holding the slope coefficients of
#' the zero-inflated fixed variables, in the same order as
#' \code{fixed_zi_vars}. Not used in \code{lm}/\code{glm}/\code{negbin}
#' objects.}
#' \item{random_zi_vars}{A string vector holding the names of the random
#' variables in the sero-inflation model. Not used in \code{lm}/\code{glm}/
#' \code{negbin} objects.}
#' \item{random_zi_slopes}{A numeric vector holding the slope coefficients of
#' the random variables in the zero-inflation model, in the same order as
#' \code{random_zi_vars}. Not used in \code{lm}/\code{glm}/\code{negbin}
#' objects.}
#' \item{sigma}{The residual standard deviation of the model. Defaults to
#' \code{1.0}.}
#' \item{theta}{The estimated theta, if the response is negative binomial.
#' Otherwise, will equal \code{1.0}.}
#' 
#' @section Notes:
#' Output from function \code{glm.nb()} is technically of class \code{negbin},
#' but is treated as class \code{glm} here.
#' 
#' @keywords internal
#' @noRd
NULL

#' Extract Key Components of vglm Objects
#' 
#' This function extracts the components of a \code{vglm} object needed for
#' functions \code{jerzeibalowski()} and \code{motherbalowski()}.
#' 
#' @name vglm_extractor
#' 
#' @param object A \code{vglm} object.
#' 
#' @return A list with the following elements:
#' \item{class}{The exact class of \code{object}.}
#' \item{family}{The response distribution.}
#' \item{dist}{An integer representing the response distribution. \code{0} = 
#' poisson, \code{1} = negbin, \code{2} = gaussian, \code{3} = gamma, \code{4}
#' = binomial, and \code{5} = constant.}
#' \item{zero_inflated}{A logical value indicating whether the distribution is
#' zero-inflated. Not used in \code{vglm} objects.}
#' \item{zero_truncated}{A logical value indicating whether the distribution is
#' zero-truncated. Always \code{TRUE} for \code{vglm} objects.}
#' \item{all_vars}{A vector holding the names of each variable used by
#' \code{object}.}
#' \item{fixed_vars}{A string vector holding the names of the fixed variables.}
#' \item{fixed_slopes}{A numeric vector holding the slope coefficients of the
#' fixed variables, in the same order as \code{fixed_vars}.}
#' \item{fixed_zi_vars}{A string vector holding the names of the zero-inflated
#' fixed variables. Not used in \code{vglm} objects.}
#' \item{fixed_zi_slopes}{A numeric vector holding the slope coefficients of
#' the zero-inflated fixed variables, in the same order as
#' \code{fixed_zi_vars}. Not used in \code{vglm} objects.}
#' \item{random_zi_vars}{A string vector holding the names of the random
#' variables in the sero-inflation model. Not used in \code{vglm} objects.}
#' \item{random_zi_slopes}{A numeric vector holding the slope coefficients of
#' the random variables in the zero-inflation model, in the same order as
#' \code{random_zi_vars}. Not used in \code{vglm} objects.}
#' \item{sigma}{The residual standard deviation of the model. Defaults to 1.0.}
#' \item{theta}{The estimated theta, if the response is negative binomial.
#' Otherwise, will equal \code{1.0}.}
#' 
#' @keywords internal
#' @noRd
NULL

#' Extract Key Components of zeroinfl Objects
#' 
#' This function extracts the components of a \code{zeroinfl} object needed for
#' functions \code{jerzeibalowski()} and \code{motherbalowski()} to work.
#' 
#' @name zeroinfl_extractor
#' 
#' @param object A \code{zeroinfl} object.
#' 
#' @return A list with the following elements:
#' \item{class}{The exact class of \code{object}. Will always be
#' \code{glmmTMB}.}
#' \item{family}{The response distribution.}
#' \item{dist}{An integer representing the response distribution. \code{0} = 
#' poisson, \code{1} = negbin, \code{2} = gaussian, \code{3} = gamma, \code{4}
#' = binomial, and \code{5} = constant.}
#' \item{zero_inflated}{A logical value indicating whether the distribution is
#' zero-inflated.}
#' \item{zero_truncated}{A logical value indicating whether the distribution is
#' zero-truncated. Defaults to \code{FALSE} for \code{zeroinfl} objects.}
#' \item{all_vars}{A vector holding the names of each variable used by
#' \code{object}.}
#' \item{fixed_vars}{A string vector holding the names of the fixed variables.}
#' \item{fixed_slopes}{A numeric vector holding the slope coefficients of the
#' fixed variables, in the same order as \code{fixed_vars}.}
#' \item{fixed_zi_vars}{A string vector holding the names of the zero-inflated
#' fixed variables.}
#' \item{fixed_zi_slopes}{A numeric vector holding the slope coefficients of
#' the zero-inflated fixed variables, in the same order as
#' \code{fixed_zi_vars}.}
#' \item{random_vars}{A string vector holding the names of the random
#' variables. Not used in \code{zeroinfl} objects.}
#' \item{random_slopes}{A numeric vector holding the slope coefficients of the
#' random variables, in the same order as \code{random_vars}. Not used in
#' \code{zeroinfl} objects.}
#' \item{random_zi_vars}{A string vector holding the names of the random
#' variables in the sero-inflation model. Not used in \code{zeroinfl} objects.}
#' \item{random_zi_slopes}{A numeric vector holding the slope coefficients of
#' the random variables in the zero-inflation model, in the same order as
#' \code{random_zi_vars}. Not used in \code{zeroinfl} objects.}
#' \item{sigma}{The residual standard deviation of the model. Defaults to 1.0.
#' Equivalent output to lme4's \code{sigma()} function.}
#' \item{theta}{The scale parameter theta used in the negative binomial
#' distribution. Defaults to \code{1.0}.}
#' 
#' @section Notes:
#' This function will only work in the case where random terms are given as
#' \code{(1 | ranterm)}, where \code{ranterm} is the name of the random
#' variable.
#' 
#' @keywords internal
#' @noRd
NULL

#' Extract Key Components of merMod Objects
#' 
#' This function extracts the components of a \code{merMod} object needed for
#' functions \code{jerzeibalowski()} and \code{motherbalowski()} to work.
#' 
#' @name lme4_extractor
#' 
#' @param object A \code{merMod} object.
#' 
#' @return A list with the following elements:
#' \item{class}{The exact class of \code{object}. Will generally be either
#' \code{lmerMod} or \code{glmerMod}.}
#' \item{family}{The response distribution.}
#' \item{dist}{An integer representing the response distribution. \code{0} = 
#' poisson, \code{1} = negbin, \code{2} = gaussian, \code{3} = gamma, \code{4}
#' = binomial, and \code{5} = constant.}
#' \item{zero_inflated}{A logical value indicating whether the distribution is
#' zero-inflated. Not used in lme4.}
#' \item{zero_truncated}{A logical value indicating whether the distribution is
#' zero-truncated. Not used in lme4.}
#' \item{all_vars}{A vector holding the names of each variable used by
#' \code{object}.}
#' \item{fixed_vars}{A string vector holding the names of the fixed variables.}
#' \item{fixed_slopes}{A numeric vector holding the slope coefficients of the
#' fixed variables, in the same order as \code{fixed_vars}.}
#' \item{fixed_zi_vars}{A string vector holding the names of the zero-inflated
#' fixed variables. Not used in lme4 objects.}
#' \item{fixed_zi_slopes}{A numeric vector holding the slope coefficients of
#' the zero-inflated fixed variables, in the same order as
#' \code{fixed_zi_vars}. Not used in lme4 objects.}
#' \item{random_vars}{A string vector holding the names of the random
#' variables.}
#' \item{random_slopes}{A numeric vector holding the slope coefficients of the
#' random variables, in the same order as \code{random_vars}.}
#' \item{random_zi_vars}{A string vector holding the names of the random
#' variables in the sero-inflation model. Not used in lme4.}
#' \item{random_zi_slopes}{A numeric vector holding the slope coefficients of
#' the random variables in the zero-inflation model, in the same order as
#' \code{random_zi_vars}. Not used in lme4.}
#' \item{sigma}{The residual standard deviation of the model. Defaults to 1.0.
#' Equivalent output to lme4's \code{sigma()} function.}
#' \item{theta}{Not used in lme4 output. Defaults to \code{1.0}.}
#' 
#' @section Notes:
#' This function will only work in the case where random terms are given as
#' \code{(1 | ranterm)}, where \code{ranterm} is the name of the random
#' variable.
#' 
#' @keywords internal
#' @noRd
NULL

#' Extract Key Components of glmmTMB Objects
#' 
#' This function extracts the components of a \code{glmmTMB} object needed for
#' functions \code{jerzeibalowski()} and \code{motherbalowski()} to work.
#' 
#' @name glmmTMB_extractor
#' 
#' @param object A \code{glmmTMB} object.
#' 
#' @return A list with the following elements:
#' \item{class}{The exact class of \code{object}. Will always be
#' \code{glmmTMB}.}
#' \item{family}{The response distribution.}
#' \item{dist}{An integer representing the response distribution. \code{0} = 
#' poisson, \code{1} = negbin, \code{2} = gaussian, \code{3} = gamma, \code{4}
#' = binomial, and \code{5} = constant.}
#' \item{zero_inflated}{A logical value indicating whether the distribution is
#' zero-inflated.}
#' \item{zero_truncated}{A logical value indicating whether the distribution is
#' zero-truncated.}
#' \item{all_vars}{A vector holding the names of each variable used by
#' \code{object}.}
#' \item{fixed_vars}{A string vector holding the names of the fixed variables.}
#' \item{fixed_slopes}{A numeric vector holding the slope coefficients of the
#' fixed variables, in the same order as \code{fixed_vars}.}
#' \item{fixed_zi_vars}{A string vector holding the names of the zero-inflated
#' fixed variables.}
#' \item{fixed_zi_slopes}{A numeric vector holding the slope coefficients of
#' the zero-inflated fixed variables, in the same order as
#' \code{fixed_zi_vars}.}
#' \item{random_vars}{A string vector holding the names of the random
#' variables.}
#' \item{random_slopes}{A numeric vector holding the slope coefficients of the
#' random variables, in the same order as \code{random_vars}.}
#' \item{random_zi_vars}{A string vector holding the names of the random
#' variables in the sero-inflation model.}
#' \item{random_zi_slopes}{A numeric vector holding the slope coefficients of
#' the random variables in the zero-inflation model, in the same order as
#' \code{random_zi_vars}.}
#' \item{sigma}{The residual standard deviation of the model. Defaults to 1.0.
#' Equivalent output to lme4's \code{sigma()} function.}
#' \item{theta}{The scale parameter theta used in the negative binomial
#' distribution. Defaults to \code{1.0}.}
#' 
#' @section Notes:
#' This function will only work in the case where random terms are given as
#' \code{(1 | ranterm)}, where \code{ranterm} is the name of the random
#' variable.
#' 
#' @keywords internal
#' @noRd
NULL

#' Function Extracting Core Components From S3 Vital Rate Models
#' 
#' Function \code{S3_extractor()} extracts all needed terms from S3 objects
#' used as vital rate models.
#' 
#' @name S3_extractor
#' 
#' @param object An S3 vital rate model. Currently, this should be output from
#' functions \code{lm()}, \code{glm()}, \code{glm.nb()}, \code{zeroinfl()},
#' and \code{glmmTMB()}.
#' 
#' @return A list describing the vital rate model in standard output required
#' from function \code{modelextract()} to operate. Elements currently include:
#' \item{class}{The exact class of \code{object}.}
#' \item{family}{The response distribution.}
#' \item{dist}{An integer representing the response distribution. \code{0} = 
#' poisson, \code{1} = negbin, \code{2} = gaussian, \code{3} = gamma, \code{4}
#' = binomial, and \code{5} = constant.}
#' \item{zero_inflated}{A logical value indicating whether the distribution is
#' zero-inflated.}
#' \item{zero_truncated}{A logical value indicating whether the distribution is
#' zero-truncated.}
#' \item{all_vars}{A vector holding the names of each variable used by
#' \code{object}.}
#' \item{fixed_vars}{A string vector holding the names of the fixed variables.}
#' \item{fixed_slopes}{A numeric vector holding the slope coefficients of the
#' fixed variables, in the same order as \code{fixed_vars}.}
#' \item{fixed_zi_vars}{A string vector holding the names of the zero-inflated
#' fixed variables.}
#' \item{fixed_zi_slopes}{A numeric vector holding the slope coefficients of
#' the zero-inflated fixed variables, in the same order as
#' \code{fixed_zi_vars}.}
#' \item{random_vars}{A string vector holding the names of the random
#' variables.}
#' \item{random_slopes}{A numeric vector holding the slope coefficients of the
#' random variables, in the same order as \code{random_vars}.}
#' \item{random_zi_vars}{A string vector holding the names of the random
#' variables in the sero-inflation model.}
#' \item{random_zi_slopes}{A numeric vector holding the slope coefficients of
#' the random variables in the zero-inflation model, in the same order as
#' \code{random_zi_vars}.}
#' \item{sigma}{The residual standard deviation of the model. Defaults to 1.0.
#' Equivalent output to lme4's \code{sigma()} function.}
#' \item{theta}{The scale parameter theta used in the negative binomial
#' distribution. Defaults to \code{1.0}.}
#' 
#' @section Notes:
#' This function currently handles models developed with functions \code{lm()}
#' and \code{glm()} from package \code{stats}, function \code{glm.nb()} from
#' package \code{MASS}, function \code{zeroinfl()} from package \code{pscl},
#' and function \code{glmmTMB()} from package \code{glmmTMB}.
#' 
#' @keywords internal
#' @noRd
NULL

#' Function Extracting Core Components From S4 Vital Rate Models
#' 
#' Function \code{S4_extractor()} extracts all needed terms from S4 objects
#' used as vital rate models.
#' 
#' @name S4_extractor
#' 
#' @param object An S4 vital rate model. Currently, this should be output from
#' functions \code{vglm()}, \code{lmer()}, and \code{glmer()}.
#' 
#' @return A list describing the vital rate model in standard output required
#' from function \code{modelextract()} to operate. Elements currently include:
#' \item{class}{The exact class of \code{object}.}
#' \item{family}{The response distribution.}
#' \item{dist}{An integer representing the response distribution. \code{0} = 
#' poisson, \code{1} = negbin, \code{2} = gaussian, \code{3} = gamma, \code{4}
#' = binomial, and \code{5} = constant.}
#' \item{zero_inflated}{A logical value indicating whether the distribution is
#' zero-inflated.}
#' \item{zero_truncated}{A logical value indicating whether the distribution is
#' zero-truncated.}
#' \item{all_vars}{A vector holding the names of each variable used by
#' \code{object}.}
#' \item{fixed_vars}{A string vector holding the names of the fixed variables.}
#' \item{fixed_slopes}{A numeric vector holding the slope coefficients of the
#' fixed variables, in the same order as \code{fixed_vars}.}
#' \item{fixed_zi_vars}{A string vector holding the names of the zero-inflated
#' fixed variables.}
#' \item{fixed_zi_slopes}{A numeric vector holding the slope coefficients of
#' the zero-inflated fixed variables, in the same order as
#' \code{fixed_zi_vars}.}
#' \item{random_vars}{A string vector holding the names of the random
#' variables.}
#' \item{random_slopes}{A numeric vector holding the slope coefficients of the
#' random variables, in the same order as \code{random_vars}.}
#' \item{random_zi_vars}{A string vector holding the names of the random
#' variables in the sero-inflation model.}
#' \item{random_zi_slopes}{A numeric vector holding the slope coefficients of
#' the random variables in the zero-inflation model, in the same order as
#' \code{random_zi_vars}.}
#' \item{sigma}{The residual standard deviation of the model. Defaults to 1.0.
#' Equivalent output to lme4's \code{sigma()} function.}
#' \item{theta}{The scale parameter theta used in the negative binomial
#' distribution. Defaults to \code{1.0}.}
#' 
#' @section Notes:
#' This function currently handles models developed with function \code{vglm()}
#' from package \code{VGAM}, and functions \code{lmer()} and \code{glmer()}
#' from package \code{lme4}.
#' 
#' @keywords internal
#' @noRd
NULL

#' Vectorize Matrix for Historical Mean Matrix Estimation
#' 
#' Function \code{flagrantcrap()} vectorizes core indices of matrices
#' input as list elements.
#' 
#' @name flagrantcrap
#' 
#' @param Xmat A matrix originally a part of a list object.
#' @param allindices A vector of indices to remove from the matrix
#' 
#' @return A column vector of specifically called elements from the input
#' matrix.
#' 
#' @keywords internal
#' @noRd
NULL

#' Vectorize Matrix for Ahistorical Mean Matrix Estimation
#' 
#' Function \code{moreflagrantcrap()} vectorizes matrices input as list
#' elements.
#' 
#' @name moreflagrantcrap
#' 
#' @param Xmat A matrix originally a part of a list object.
#' 
#' @return A column vector of the input matrix.
#' 
#' @keywords internal
#' @noRd
NULL

#' Calculate Logarithms of Non-Zero Elements of Sparse Matrix
#' 
#' Function \code{spmat_log} finds the non-zero elements in a sparse matrix,
#' calculates their logs, and inserts them back into the matrix and returns it.
#' Based on code developed by Coatless Professor and posted by him on
#' StackOverflow.
#' 
#' @name spmat_log
#' 
#' @param B A sparse matrix. Note that this is assumed to be a population
#' projection matrix, meaning that all values are either 0 or positive.
#' 
#' @return A sparse matrix with non-zero values as logs of the elements in the
#' input matrix.
#' 
#' @keywords internal
#' @noRd
NULL

#' Append NumericVector to the End of Another NumericVector
#' 
#' This function appends one NumericVector fully to another.
#' 
#' @name concat_dbl
#' 
#' @param A Any NumericVector.
#' @param B Any other NumericVector.
#' 
#' @return Returns a new NumericVector with elements of vector A followed by
#' elements of vector B.
#'
#' @keywords internal
#' @noRd
.concat_dbl <- function(x, y) {
    .Call('_lefko3_concat_dbl', PACKAGE = 'lefko3', x, y)
}

#' Append IntegerVector to the End of Another IntegerVector
#' 
#' Returns a new IntegerVector with elements of vector A followed by
#' elements of vector B.
#' 
#' @name concat_int
#' @param A Any IntegerVector.
#' @param B Any other IntegerVector.
#' 
#' @return Returns a new IntegerVector with elements of vector A followed by
#' elements of vector B.
#' 
#' @keywords internal
#' @noRd
.concat_int <- function(x, y) {
    .Call('_lefko3_concat_int', PACKAGE = 'lefko3', x, y)
}

#' Append StringVector to the End of Another StringVector
#' 
#' Returns a new StringVector with elements of vector A followed by
#' elements of vector B.
#' 
#' @name concat_str
#' 
#' @param A Any StringVector.
#' @param B Any other StringVector.
#' 
#' @return Returns a new StringVector with elements of vector A followed by
#' elements of vector B.
#' 
#' @keywords internal
#' @noRd
.concat_str <- function(x, y) {
    .Call('_lefko3_concat_str', PACKAGE = 'lefko3', x, y)
}

#' Create Stageframe for Population Matrix Projection Analysis
#' 
#' Function \code{sf_create()} returns a data frame describing each ahistorical
#' life history stage in the life history model. This data frame can be used as 
#' input into MPM creation functions including \code{\link{flefko3}()}, 
#' \code{\link{flefko2}()}, \code{\link{aflefko2}()}, \code{\link{rlefko3}()},
#' and \code{\link{rlefko2}()}, in which it determines how each stage is
#' treated during matrix estimation.
#' 
#' @name sf_create
#' 
#' @param sizes A numeric vector of the typical or representative size of each
#' life history stage. If making function-based MPMs, then this should be a
#' vector composed of the midpoints of each size bin. If denoting the boundary
#' of an automated size classification group, then should denote the absolute
#' minimum size of that group, or the absolute size of that group (see Notes).
#' @param stagenames A vector of stage names, in the same order as elements in
#' sizes. Can also be set to \code{ipm} for automated size classification (see
#' Notes section).
#' @param sizesb An optional numeric vector for a second size metric for each
#' life history stage. Only to be used if stages are defined by at least two
#' size metrics in all cases. Same issues apply as in \code{sizes}.
#' @param sizesc An optional numeric vector for a third size metric for each
#' life history stage. Only to be used if stages are defined by at least three
#' size metrics in all cases. Same issues apply as in \code{sizes}.
#' @param repstatus A vector denoting the binomial reproductive status of each
#' life history stage. Defaults to 1.
#' @param obsstatus A vector denoting the binomial observation status of each
#' life history stage. Defaults to 1, but may be changed for unobservable 
#' stages.
#' @param propstatus A vector denoting whether each life history stage is a 
#' propagule. Such stages are generally only used in fecundity estimation. 
#' Defaults to 0.
#' @param matstatus A vector denoting whether each stage is mature. Must be
#' composed of binomial values if given. Defaults to 1 for all stages defined 
#' in \code{sizes}.
#' @param immstatus A vector denoting whether each stage is immature. Must be
#' composed of binomial values if given. Defaults to the complement of vector
#' \code{matstatus}.
#' @param minage An optional vector denoting the minimum age at which a stage
#' can occur. Only used in age x stage matrix development. Defaults to NA.
#' @param maxage An optional vector denoting the maximum age at which a stage
#' should occur. Only used in age x stage matrix development. Defaults to NA.
#' @param indataset A vector designating which stages are found within the 
#' dataset. While \code{\link{rlefko2}()} and \code{\link{rlefko3}()} can use
#' all stages in the input dataset, \code{\link{flefko3}()} and
#' \code{\link{flefko2}()} can only handle size-classified stages with
#' non-overlapping combinations of size and status variables. Stages that do
#' not actually exist within the dataset should be marked as 0 in this vector.
#' @param binhalfwidth A numeric vector giving the half-width of size bins.
#' Required to classify individuals appropriately within size classes.
#' Defaults to 0.5 for all sizes.
#' @param binhalfwidthb A numeric vector giving the half-width of size bins
#' used for the optional second size metric. Required to classify individuals
#' appropriately with two or three size classes. Defaults to 0.5 for all sizes.
#' @param binhalfwidthc A numeric vector giving the half-width of size bins
#' used for the optional third size metric. Required to classify individuals
#' appropriately with three size classes. Defaults to 0.5 for all sizes.
#' @param group An integer vector providing information on each respective
#' stage's size classification group. If used, then function-based MPM creation
#' functions \code{\link{flefko2}()}, \code{\link{flefko3}()}, and
#' \code{\link{aflefko2}()} will estimate transitions only within these groups
#' and for allowed cross-group transitions noted within the supplement table.
#' Defaults to 0.
#' @param comments An optional vector of text entries holding useful text
#' descriptions of all stages.
#' @param roundsize This parameter sets the precision of size classification,
#' and equals the number of digits used in rounding sizes. Defaults to 5.
#' @param roundsizeb This parameter sets the precision of size classification
#' in the optional second size metric, and equals the number of digits used in
#' rounding sizes. Defaults to 5.
#' @param roundsizec This parameter sets the precision of size classification
#' in the optional third size metric, and equals the number of digits used in
#' rounding sizes. Defaults to 5.
#' @param ipmbins An integer giving the number of size bins to create using the
#' primary size classification variable. This number is in addition to any
#' stages that are not size classified. Defaults to 100, and numbers greater
#' than this yield a warning about the loss of statistical power and increasing
#' chance of matrix over-parameterization resulting from increasing numbers of
#' stages.
#' @param ipmbinsb An optional integer giving the number of size bins to create
#' using the secondary size classification variable. This number is in addition
#' to any stages that are not size classified, as well as in addition to any
#' automated size classification using the primary and tertiary size variables.
#' Defaults to NA, and must be set to a positive integer for automated size
#' classification to progress.
#' @param ipmbinsc An optional integer giving the number of size bins to create
#' using the tertiary size classification variable. This number is in addition
#' to any stages that are not size classified, as well as in addition to any
#' automated size classification using the primary and secondary size
#' variables. Defaults to NA, and must be set to a positive integer for
#' automated size classification to progress.
#' 
#' @return A data frame of class \code{stageframe}, which includes information
#' on the stage name, size, reproductive status, observation status, propagule 
#' status, immaturity status, maturity status, presence within the core dataset, 
#' stage group classification, raw bin half-width, and the minimum, 
#' center, and maximum of each size bin, as well as its width. If minimum and
#' maximum ages were specified, then these are also included. Also includes an 
#' empty string variable that can be used to describe stages meaningfully. This
#' object can be used as the \code{stageframe} input for \code{\link{flefko3}()} 
#' \code{\link{flefko2}()}, \code{\link{rlefko3}()}, and \code{\link{rlefko2}()}.
#' 
#' Variables in this data frame include the following:
#' \item{stage}{The unique names of the stages to be analyzed.}
#' \item{size}{The typical or representative size at which each stage occurs.}
#' \item{size_b}{Size at which each stage occurs in terms of a second size
#' variable, if one exists.}
#' \item{size_c}{Size at which each stage occurs in terms of a third size
#' variable, if one exists.}
#' \item{min_age}{The minimum age at which the stage may occur.}
#' \item{max_age}{The maximum age at which the stage may occur.}
#' \item{repstatus}{A binomial variable showing whether each stage is
#' reproductive.}
#' \item{obsstatus}{A binomial variable showing whether each stage is
#' observable.}
#' \item{propstatus}{A binomial variable showing whether each stage is a
#' propagule.}
#' \item{immstatus}{A binomial variable showing whether each stage can occur as
#' immature.}
#' \item{matstatus}{A binomial variable showing whether each stage occurs in
#' maturity.}
#' \item{indataset}{A binomial variable describing whether each stage occurs in
#' the input dataset.}
#' \item{binhalfwidth_raw}{The half-width of the size bin, as input.}
#' \item{sizebin_min}{The minimum size at which the stage may occur.}
#' \item{sizebin_max}{The maximum size at which the stage may occur.}
#' \item{sizebin_center}{The midpoint of the size bin at which the stage may
#' occur.}
#' \item{sizebin_width}{The width of the size bin corresponding to the stage.}
#' \item{binhalfwidthb_raw}{The half-width of the size bin of a second size
#' variable, as input.}
#' \item{sizebinb_min}{The minimum size at which the stage may occur.}
#' \item{sizebinb_max}{The maximum size at which the stage may occur.}
#' \item{sizebinb_center}{The midpoint of the size bin at which the stage may
#' occur, in terms of a second size variable.}
#' \item{sizebinb_width}{The width of the size bin corresponding to the stage,
#' in terms of a second size variable.}
#' \item{binhalfwidthc_raw}{The half-width of the size bin of a third size
#' variable, as input.}
#' \item{sizebinc_min}{The minimum size at which the stage may occur, in terms
#' of a third size variable.}
#' \item{sizebinc_max}{The maximum size at which the stage may occur, in terms
#' of a third size variable.}
#' \item{sizebinc_center}{The midpoint of the size bin at which the stage may
#' occur, in terms of a third size variable.}
#' \item{sizebinc_width}{The width of the size bin corresponding to the stage,
#' in terms of a third size variable.}
#' \item{group}{An integer denoting the size classification group that the
#' stage falls within.}
#' \item{comments}{A text field for stage descriptions.}
#' 
#' @section Notes:
#' If an IPM or function-based matrix with automated size classification is
#' desired, then two stages that occur within the dataset and represent the
#' lower and upper size limits of the IPM must be marked with \code{ipm} in
#' the stagenames vector. These stages should have all characteristics other
#' than size equal, and the size input for whichever size will be classified
#' automatically must include the minimum in one stage and the maximum in the
#' other. The actual characteristics of the first stage encountered in the
#' inputs will be used as the template for the creation of these sizes. Note
#' that \code{ipm} refers to size classification with the primary size
#' variable. To automate size classification with the secondary size variable,
#' use \code{ipmb}, and to automate size classification with the tertiary size
#' variable, use \code{ipmc}. To nest automated size classifications, use 
#' \code{ipmab} for the primary and secondary size variables, \code{ipmac} for
#' the primary and tertiary size variables, \code{ipmbc} for the secondary and
#' tertiary size variables, and \code{ipmabc} for all three size variables.
#' The primary size variable can also be set with \code{ipma}.
#' 
#' If two or more groups of stages, each with its own characteristics, are to
#' be developed for an IPM or function-based MPM, then an even number of stages
#' with two stages marking the minimum and maximum size of each group should be
#' marked with the same code as given above, with all other characteristics
#' equal within each group.
#' 
#' Stage classification groups set with the \code{group} variable create zones
#' within function-based matrices in which survival transitions are estimated.
#' These groups should not be set if transitions are possible between all
#' stages regardless of group. To denote specific transitions as estimable
#' between stage groups, use the \code{\link{supplemental}()} function.
#' 
#' @examples
#' # Lathyrus example
#' data(lathyrus)
#' 
#' sizevector <- c(0, 100, 13, 127, 3730, 3800, 0)
#' stagevector <- c("Sd", "Sdl", "VSm", "Sm", "VLa", "Flo", "Dorm")
#' repvector <- c(0, 0, 0, 0, 0, 1, 0)
#' obsvector <- c(0, 1, 1, 1, 1, 1, 0)
#' matvector <- c(0, 0, 1, 1, 1, 1, 1)
#' immvector <- c(1, 1, 0, 0, 0, 0, 0)
#' propvector <- c(1, 0, 0, 0, 0, 0, 0)
#' indataset <- c(0, 1, 1, 1, 1, 1, 1)
#' binvec <- c(0, 100, 11, 103, 3500, 3800, 0.5)
#' 
#' lathframe <- sf_create(sizes = sizevector, stagenames = stagevector,
#'   repstatus = repvector, obsstatus = obsvector, matstatus = matvector,
#'   immstatus = immvector, indataset = indataset, binhalfwidth = binvec,
#'   propstatus = propvector)
#' 
#' lathvert <- verticalize3(lathyrus, noyears = 4, firstyear = 1988,
#'   patchidcol = "SUBPLOT", individcol = "GENET", blocksize = 9,
#'   juvcol = "Seedling1988", sizeacol = "Volume88", repstracol = "FCODE88",
#'   fecacol = "Intactseed88", deadacol = "Dead1988",
#'   nonobsacol = "Dormant1988", stageassign = lathframe, stagesize = "sizea",
#'   censorcol = "Missing1988", censorkeep = NA, censor = TRUE)
#' 
#' lathsupp3 <- supplemental(stage3 = c("Sd", "Sd", "Sdl", "Sdl", "Sd", "Sdl", "mat"),
#'   stage2 = c("Sd", "Sd", "Sd", "Sd", "rep", "rep", "Sdl"),
#'   stage1 = c("Sd", "rep", "Sd", "rep", "npr", "npr", "Sd"),
#'   eststage3 = c(NA, NA, NA, NA, NA, NA, "mat"),
#'   eststage2 = c(NA, NA, NA, NA, NA, NA, "Sdl"),
#'   eststage1 = c(NA, NA, NA, NA, NA, NA, "NotAlive"),
#'   givenrate = c(0.345, 0.345, 0.054, 0.054, NA, NA, NA),
#'   multiplier = c(NA, NA, NA, NA, 0.345, 0.054, NA),
#'   type = c(1, 1, 1, 1, 3, 3, 1), type_t12 = c(1, 2, 1, 2, 1, 1, 1),
#'   stageframe = lathframe, historical = TRUE)
#' 
#' ehrlen3 <- rlefko3(data = lathvert, stageframe = lathframe, year = "all", 
#'   stages = c("stage3", "stage2", "stage1"), supplement = lathsupp3,
#'   yearcol = "year2", indivcol = "individ")
#' 
#' ehrlen3mean <- lmean(ehrlen3)
#' ehrlen3mean$A[[1]]
#' 
#' # Cypripedium example
#' data(cypdata)
#' 
#' sizevector <- c(0, 0, 0, 0, 0, 0, 1, 2.5, 4.5, 8, 17.5)
#' stagevector <- c("SD", "P1", "P2", "P3", "SL", "D", "XSm", "Sm", "Md", "Lg",
#'   "XLg")
#' repvector <- c(0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1)
#' obsvector <- c(0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1)
#' matvector <- c(0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1)
#' immvector <- c(0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0)
#' propvector <- c(1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)
#' indataset <- c(0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1)
#' binvec <- c(0, 0, 0, 0, 0, 0.5, 0.5, 1, 1, 2.5, 7)
#' 
#' cypframe_raw <- sf_create(sizes = sizevector, stagenames = stagevector,
#'   repstatus = repvector, obsstatus = obsvector, matstatus = matvector,
#'   propstatus = propvector, immstatus = immvector, indataset = indataset,
#'   binhalfwidth = binvec)
#' 
#' cypraw_v1 <- verticalize3(data = cypdata, noyears = 6, firstyear = 2004,
#'   patchidcol = "patch", individcol = "plantid", blocksize = 4,
#'   sizeacol = "Inf2.04", sizebcol = "Inf.04", sizeccol = "Veg.04",
#'   repstracol = "Inf.04", repstrbcol = "Inf2.04", fecacol = "Pod.04",
#'   stageassign = cypframe_raw, stagesize = "sizeadded", NAas0 = TRUE,
#'   NRasRep = TRUE)
#' 
#' cypsupp2r <- supplemental(stage3 = c("SD", "P1", "P2", "P3", "SL", "D", 
#'     "XSm", "Sm", "SD", "P1"),
#'   stage2 = c("SD", "SD", "P1", "P2", "P3", "SL", "SL", "SL", "rep",
#'     "rep"),
#'   eststage3 = c(NA, NA, NA, NA, NA, "D", "XSm", "Sm", NA, NA),
#'   eststage2 = c(NA, NA, NA, NA, NA, "XSm", "XSm", "XSm", NA, NA),
#'   givenrate = c(0.10, 0.20, 0.20, 0.20, 0.25, NA, NA, NA, NA, NA),
#'   multiplier = c(NA, NA, NA, NA, NA, NA, NA, NA, 0.5, 0.5),
#'   type =c(1, 1, 1, 1, 1, 1, 1, 1, 3, 3),
#'   stageframe = cypframe_raw, historical = FALSE)
#' 
#' cypmatrix2r <- rlefko2(data = cypraw_v1, stageframe = cypframe_raw, 
#'   year = "all", patch = "all", stages = c("stage3", "stage2", "stage1"),
#'   size = c("size3added", "size2added"), supplement = cypsupp2r,
#'   yearcol = "year2", patchcol = "patchid", indivcol = "individ")
#'                        
#' cyp2mean <- lmean(cypmatrix2r)
#' cyp2mean
#' 
#' @export sf_create
sf_create <- function(sizes, stagenames = NULL, sizesb = NULL, sizesc = NULL, repstatus = NULL, obsstatus = NULL, propstatus = NULL, matstatus = NULL, immstatus = NULL, minage = NULL, maxage = NULL, indataset = NULL, binhalfwidth = NULL, binhalfwidthb = NULL, binhalfwidthc = NULL, group = NULL, comments = NULL, roundsize = 5L, roundsizeb = 5L, roundsizec = 5L, ipmbins = 100L, ipmbinsb = NA_integer_, ipmbinsc = NA_integer_) {
    .Call('_lefko3_sf_create', PACKAGE = 'lefko3', sizes, stagenames, sizesb, sizesc, repstatus, obsstatus, propstatus, matstatus, immstatus, minage, maxage, indataset, binhalfwidth, binhalfwidthb, binhalfwidthc, group, comments, roundsize, roundsizeb, roundsizec, ipmbins, ipmbinsb, ipmbinsc)
}

#' Standardize Stageframe For MPM Analysis
#' 
#' Function \code{sf_reassess()} takes a stageframe as input, and uses
#' information supplied there and through the supplement, reproduction and
#' overwrite tables to rearrange this into a format usable by the matrix
#' creation functions, \code{\link{flefko3}()}, \code{\link{flefko2}()},
#' \code{\link{aflefko2}()}, \code{\link{rlefko3}()}, and
#' \code{\link{rlefko2}()}.
#' 
#' @name sf_reassess
#' 
#' @param stageframe The original stageframe.
#' @param supplement The original supplemental data input
#' (class \code{lefkoSD}). Can also equal NA.
#' @param overwrite An overwrite table.
#' @param repmatrix The original reproduction matrix. Can also equal NA or 0.
#' @param agemat A logical value indicating whether MPM is age-by-stage.
#' @param historical A logical value indicating whether MPM is historical.
#' @param format An integer indicating whether matrices will be in Ehrlen format
#' (if set to 1), or deVries format (if set to 2). Setting to deVries format
#' adds one extra stage to account for the prior status of newborns.
#' 
#' @return This function returns a list with a modified stageframe usable in MPM
#' construction, an associated reproduction matrix, and a general supplement
#' table that takes over the input supplement and overwrite tables. Note that
#' if a supplement is provided and a repmatrix is not, or if repmatrix is set
#' to 0, then it will be assumed that a repmatrix should not be used.
#' 
#' @keywords internal
#' @noRd
.sf_reassess <- function(stageframe, supplement, overwrite, repmatrix, agemat = FALSE, historical = FALSE, format = 1L) {
    .Call('_lefko3_sf_reassess', PACKAGE = 'lefko3', stageframe, supplement, overwrite, repmatrix, agemat, historical, format)
}

#' Create Stageframe for Population Matrix Projection Analysis
#' 
#' Function \code{sf_leslie()} returns a data frame describing each age in a
#' Leslie MPM in terms of ahistorical stage information. This function is
#' internal to \code{\link{rleslie}()} and \code{\link{fleslie}()}.
#' 
#' @name sf_leslie
#' 
#' @param min_age The first age to include in the matrix.
#' @param max_age The maximum age to include in the matrix.
#' @param min_fecage The first age in which reproduction is possible.
#' @param max_fecage The final age in which reproduction is possible.
#' @param cont A logical value indicating whether survival continues past the
#' last described age.
#' 
#' @return A data frame of class \code{stageframe}, which includes information
#' on the stage name, size, reproductive status, observation status, propagule 
#' status, immaturity status, maturity status, presence within the core dataset, 
#' stage group classification, raw bin half-width, and the minimum, 
#' center, and maximum of each size bin, as well as its width. If minimum and
#' maximum ages were specified, then these are also included. Also includes an 
#' empty string variable that can be used to describe stages meaningfully.
#' 
#' Variables in this data frame include the following:
#' \item{stage_id}{An unique integer representing each age, in order.}
#' \item{stage}{The unique names of the ages to be analyzed.}
#' \item{size}{The typical or representative size at which each stage occurs.
#' Since ages are not characterized by size, this is generally \code{NA}.}
#' \item{size_b}{Size at which each stage occurs in terms of a second size
#' variable, if one exists. In Leslie MPMs, generally \code{NA}.}
#' \item{size_c}{Size at which each stage occurs in terms of a third size
#' variable, if one exists. In Leslie MPMs, generally \code{NA}.}
#' \item{min_age}{The minimum age at which the stage may occur. In Leslie MPMs,
#' defaults to the current age.}
#' \item{max_age}{The maximum age at which the stage may occur. In Leslie MPMs,
#' will generally equal the current age or \code{NA}, depending on whether
#' individuals are allowed to remain at the maximum age.}
#' \item{repstatus}{A binomial variable showing whether each age is
#' reproductive.}
#' \item{obsstatus}{A binomial variable showing whether each age is
#' observable.}
#' \item{propstatus}{A binomial variable showing whether each age is a
#' propagule.}
#' \item{immstatus}{A binomial variable showing whether each age can occur as
#' immature.}
#' \item{matstatus}{A binomial variable showing whether each age occurs in
#' maturity.}
#' \item{indataset}{A binomial variable describing whether each age occurs in
#' the input dataset.}
#' \item{binhalfwidth_raw}{The half-width of the size bin, as input.}
#' \item{sizebin_min}{The minimum primary size at which the age may occur.}
#' \item{sizebin_max}{The maximum primary size at which the age may occur.}
#' \item{sizebin_center}{The midpoint of the primary size bin at which the age
#' may occur.}
#' \item{sizebin_width}{The width of the primary size bin corresponding to the
#' age.}
#' \item{binhalfwidthb_raw}{The half-width of the size bin of a second size
#' variable, as input.}
#' \item{sizebinb_min}{The minimum secondary size at which the age may occur.}
#' \item{sizebinb_max}{The maximum secondary size at which the age may occur.}
#' \item{sizebinb_center}{The midpoint of the secondary size bin at which the
#' age may occur.}
#' \item{sizebinb_width}{The width of the secondary size bin corresponding to
#' the age.}
#' \item{binhalfwidthc_raw}{The half-width of the size bin of a third size
#' variable, as input.}
#' \item{sizebinc_min}{The minimum tertiary size at which the age may occur.}
#' \item{sizebinc_max}{The maximum tertiary size at which the age may occur.}
#' \item{sizebinc_center}{The midpoint of the tertiary size bin at which the
#' age may occur.}
#' \item{sizebinc_width}{The width of the tertiary size bin corresponding to
#' the age.}
#' \item{group}{An integer denoting the size classification group that the
#' age falls within.}
#' \item{comments}{A text field for stage descriptions.}
#' \item{alive}{An integer vector denoting whether the age is alive. Defaults
#' to \code{1} for all ages.}
#' \item{almost_born}{An integer vector denoting whether the age corresponds to
#' the prior stage of a newly produced individual in a historical model. In
#' Leslie MPMs, defaults to \code{0}.}
#' 
#' @keywords internal
#' @noRd
.sf_leslie <- function(min_age, max_age, min_fecage, max_fecage, cont) {
    .Call('_lefko3_sf_leslie', PACKAGE = 'lefko3', min_age, max_age, min_fecage, max_fecage, cont)
}

#' Create Element Index for Matrix Estimation
#' 
#' Function \code{theoldpizzle()} creates a data frame object used by 
#' functions \code{\link{specialpatrolgroup}()},
#' \code{\link{normalpatrolgroup}()}, and \code{jerzeibalowski()} to estimate
#' raw and function-derived matrices.
#' 
#' @name theoldpizzle
#'
#' @param StageFrame The stageframe object identifying the life history model
#' being operationalized.
#' @param OverWrite The supplement or overwrite table used in analysis, as
#' modified by \code{.sf_reassess()}.
#' @param repmatrix The reproductive matrix used in analysis.
#' @param firstage The first age to be used in the analysis. Should typically
#' be \code{0} for pre-breeding and \code{1} for post-breeding life history
#' models. If not building age-by-stage MPMs, then should be set to \code{0}.
#' @param finalage The final age to be used in analysis. If not building
#' age-by-stage MPMs, then should be set to \code{0}.
#' @param format Indicates whether historical matrices should be in (\code{1})
#' Ehrlen or (\code{2}) deVries format.
#' @param style The style of analysis, where \code{0} is historical, \code{1}
#' is ahistorical, and \code{2} is age-by-stage.
#' @param cont Denotes whether age-by-stage matrix continues past the final
#' age.
#' @param filter An integer denoting whether to filter the DataFrame to
#' eliminate unusable rows, and if so, how to do so. Possible values: \code{0}:
#' no filtering, \code{1}: filter out rows with \code{index321 == -1}, and
#' \code{2}: filter out rows with \code{aliveandequal == -1}.
#' 
#' @return The output is a large data frame describing every element to be
#' estimated in matrices.
#' 
#' @keywords internal
#' @noRd
.theoldpizzle <- function(StageFrame, OverWrite, repmatrix, firstage, finalage, format, style, cont, filter) {
    .Call('_lefko3_theoldpizzle', PACKAGE = 'lefko3', StageFrame, OverWrite, repmatrix, firstage, finalage, format, style, cont, filter)
}

#' Estimate All Elements of Raw Historical Matrix
#' 
#' Function \code{specialpatrolgroup()} swiftly calculates matrix transitions
#' in raw historical matrices, and serves as the core workhorse function behind
#' \code{\link{rlefko3}()}.
#' 
#' @name specialpatrolgroup
#' 
#' @param sge9l The Allstages data frame developed for \code{rlefko3()}
#' covering stage pairs across times \emph{t}+1, \emph{t} and \emph{t}-1.
#' Generally termed \code{stageexpansion9}.
#' @param sge3 The data frame covering all stages in times \emph{t} and
#' \emph{t}-1. Generally termed \code{stageexpansion3}.
#' @param MainData The demographic dataset modified to hold \code{usedfec}
#' columns.
#' @param StageFrame The full stageframe for the analysis.
#' @param repmatrix The modified repmatrix used in the course of computation.
#' This is used particularly when deVries-format hMPMs are desired.
#' @param format Indicates whether to output Ehrlen-format hMPMs (\code{1}) or
#' deVries-format hMPMs (\code{2}).
#' @param err_switch If set to \code{1}, then will also output probsrates and
#' stage2fec.
#' 
#' @return List of three matrices, including the survival-transition (\code{U})
#' matrix, the fecundity matrix (\code{F}), and the sum (\code{A}) matrix, with
#' the \code{A} matrix first.
#' 
#' @keywords internal
#' @noRd
.specialpatrolgroup <- function(sge9l, sge3, MainData, StageFrame, format, err_switch) {
    .Call('_lefko3_specialpatrolgroup', PACKAGE = 'lefko3', sge9l, sge3, MainData, StageFrame, format, err_switch)
}

#' Estimate All Elements of Raw Ahistorical Population Projection Matrix
#' 
#' Function \code{normalpatrolgroup()} swiftly calculates matrix transitions
#' in raw ahistorical matrices, and serves as the core workhorse function
#' behind \code{\link{rlefko2}()}.
#' 
#' @name normalpatrolgroup
#' 
#' @param sge3 The Allstages data frame developed for \code{rlefko2()} covering
#' stage pairs across times \emph{t}+1 and \emph{t}. Generally termed
#' \code{stageexpansion3}.
#' @param sge2 The data frame covering all stages in time \emph{t}. Generally
#' termed \code{stageexpansion2}.
#' @param MainData The demographic dataset modified to hold \code{usedfec} and
#' \code{usedstage} columns.
#' @param StageFrame The full stageframe for the analysis.
#' 
#' @return List of three matrices, including the survival-transition (\code{U})
#' matrix, the fecundity matrix (\code{F}), and the sum (\code{A}) matrix, with
#' the \code{A} matrix first.
#' 
#' @keywords internal
#' @noRd
.normalpatrolgroup <- function(sge3, sge2, MainData, StageFrame) {
    .Call('_lefko3_normalpatrolgroup', PACKAGE = 'lefko3', sge3, sge2, MainData, StageFrame)
}

#' Estimate All Elements of Raw Ahistorical Population Projection Matrix
#' 
#' Function \code{minorpatrolgroup()} swiftly calculates matrix transitions
#' in raw Leslie MPMs, and is used internally in \code{\link{rleslie}()}.
#' 
#' @name minorpatrolgroup
#' 
#' @param MainData The demographic dataset modified internally to have needed
#' variables for living status, reproduction status, and fecundity.
#' @param StageFrame The full stageframe for the analysis.
#' @param fectime An integer coding to estimate fecundity using time \emph{t}
#' (\code{2}) or time \emph{t}+1 \code{(3)}.
#' @param cont Should a self-loop transition be estimated for the final age.
#' @param lastage An integer coding for the last age to use in matrix
#' construction.
#' 
#' @return List of three matrices, including the survival-transition (\code{U})
#' matrix, the fecundity matrix (\code{F}), and the sum (\code{A}) matrix, with
#' the \code{A} matrix first.
#' 
#' @keywords internal
#' @noRd
.minorpatrolgroup <- function(MainData, StageFrame, fectime, cont, fec_mod) {
    .Call('_lefko3_minorpatrolgroup', PACKAGE = 'lefko3', MainData, StageFrame, fectime, cont, fec_mod)
}

#' Estimate All Elements of Raw Age-By-Stage Population Projection Matrix
#' 
#' Function \code{.subvertedpatrolgroup()} swiftly calculates matrix
#' transitions in raw ahistorical matrices, and serves as the core workhorse
#' function behind \code{\link{arlefko2}()}.
#' 
#' @name subvertedpatrolgroup
#' 
#' @param sge3 The Allstages data frame developed for \code{rlefko2()} covering
#' stage pairs across times \emph{t}+1 and \emph{t}. Generally termed
#' \code{stageexpansion3}.
#' @param sge2 The data frame covering all stages in time \emph{t}. Generally
#' termed \code{stageexpansion2}.
#' @param MainData The demographic dataset modified to hold \code{usedfec} and
#' \code{usedstage} columns.
#' @param StageFrame The full stageframe for the analysis.
#' @param firstage The first true age to start the matrix with.
#' @param finalage The last true age to estimate.
#' @param cont A logical value indicating whether to lump survival past the
#' last age into a final age transition set on the supermatrix diagonal.
#' 
#' @return List of three matrices, including the survival-transition (\code{U})
#' matrix, the fecundity matrix (\code{F}), and the sum (\code{A}) matrix, with
#' the \code{A} matrix first.
#' 
#' @keywords internal
#' @noRd
.subvertedpatrolgroup <- function(sge3, sge2, MainData, StageFrame, firstage, finalage, cont) {
    .Call('_lefko3_subvertedpatrolgroup', PACKAGE = 'lefko3', sge3, sge2, MainData, StageFrame, firstage, finalage, cont)
}

#' Estimate All Elements of Function-based Population Projection Matrix
#' 
#' Function \code{jerzeibalowski()} swiftly calculates matrix elements in
#' function-based population projection matrices. Used in
#' \code{\link{flefko3}()}, \code{\link{flefko2}()}, and
#' \code{\link{aflefko2}()}.
#' 
#' @name jerzeibalowski
#' 
#' @param ppy A data frame showing the population, patch, and year of each
#' matrix to create, in order.
#' @param AllStages A large data frame giving all required inputs for vital
#' rate estimation other than the vital rate model coefficients themselves.
#' Contains a row for each ultimate matrix element.
#' @param stageframe The modified stageframe used in matrix calculations.
#' @param matrixformat An integer representing the style of matrix to develop.
#' Options include Ehrlen-format hMPM (1), deVries-format hMPM (2), ahMPM (3),
#' and age-by-stage MPM (4).
#' @param survproxy List of coefficients estimated in model of survival.
#' @param obsproxy List of coefficients estimated in model of observation.
#' @param sizeproxy List of coefficients estimated in model of size.
#' @param repstproxy List of coefficients estimated in model of reproductive 
#' status.
#' @param fecproxy List of coefficients estimated in model of fecundity.
#' @param jsurvproxy List of coefficients estimated in model of juvenile
#' survival.
#' @param jobsproxy List of coefficients estimated in model of juvenile
#' observation.
#' @param jsizeproxy List of coefficients estimated in model of juvenile size.
#' @param jrepstproxy List of coefficients estimated in model of juvenile
#' reproductive status.
#' @param jmatstproxy List of coefficients estimated in model of juvenile
#' maturity probability.
#' @param f2_inda A numeric vector of length equal to the number of years,
#' holding values equal to the mean value of individual covariate \code{a} at
#' each time \emph{t} to be used in analysis.
#' @param f1_inda A numeric vector of length equal to the number of years,
#' holding values equal to the mean value of individual covariate \code{a} at
#' each time \emph{t}-1 to be used in analysis.
#' @param f2_indb A numeric vector of length equal to the number of years,
#' holding values equal to the mean value of individual covariate \code{b} at
#' each time \emph{t} to be used in analysis.
#' @param f1_indb A numeric vector of length equal to the number of years,
#' holding values equal to the mean value of individual covariate \code{b} at
#' each time \emph{t}-1 to be used in analysis.
#' @param f2_indc A numeric vector of length equal to the number of years,
#' holding values equal to the mean value of individual covariate \code{c} at
#' each time \emph{t} to be used in analysis.
#' @param f1_indc A numeric vector of length equal to the number of years,
#' holding values equal to the mean value of individual covariate \code{c} at
#' each time \emph{t}-1 to be used in analysis.
#' @param r2_inda A numeric vector of length equal to the number of years,
#' holding values equal to the mean value of individual random covariate
#' \code{a} at each time \emph{t} to be used in analysis.
#' @param r1_inda A numeric vector of length equal to the number of years,
#' holding values equal to the mean value of individual random covariate
#' \code{a} at each time \emph{t}-1 to be used in analysis.
#' @param r2_indb A numeric vector of length equal to the number of years,
#' holding values equal to the mean value of individual random covariate
#' \code{b} at each time \emph{t} to be used in analysis.
#' @param r1_indb A numeric vector of length equal to the number of years,
#' holding values equal to the mean value of individual random covariate
#' \code{b} at each time \emph{t}-1 to be used in analysis.
#' @param r2_indc A numeric vector of length equal to the number of years,
#' holding values equal to the mean value of individual random covariate
#' \code{c} at each time \emph{t} to be used in analysis.
#' @param r1_indc A numeric vector of length equal to the number of years,
#' holding values equal to the mean value of individual random covariate
#' \code{c} at each time \emph{t}-1 to be used in analysis.
#' @param dev_terms A numeric vector containing the deviations to the linear
#' models input by the user. The order is: survival, observation status, size,
#' size_b, size_c, reproductive status, fecundity, juvenile survival, juvenile
#' observation status, juvenile size, juvenile size_b, juvenile size_c,
#' juvenile reproductive status, and juvenile maturity status.
#' @param dens_vr A logical value indicating whether any vital rates are
#' density dependent.
#' @param dvr_yn A logical vector indicating whether each vital rate is density
#' dependent.
#' @param dvr_style An integer vector indicating the style of density
#' dependence for each vital rate.
#' @param dvr_alpha A numeric vector indicating the value of alpha to use in
#' density dependence for each vital rate.
#' @param dvr_beta A numeric vector indicating the value of beta to use in
#' density dependence for each vital rate.
#' @param dens_n A numeric vector corresponding to the population size to use
#' in vital rate density dependence calculations.
#' @param dens A numeric value equal to the spatial density to be used in
#' calculations.
#' @param fecmod A scalar multiplier for fecundity.
#' @param maxsize The maximum primary size to be used in element estimation.
#' @param maxsizeb The maximum secondary size to be used in element estimation.
#' @param maxsizec The maximum tertiary size to be used in element estimation.
#' @param firstage The first age to be included in age-by-stage MPM estimation.
#' @param finalage The final age to be included in age-by-stage MPM estimation.
#' @param negfec A logical value denoting whether to change negative estimated
#' fecundity to 0.
#' @param yearnumber An integer specifying which time at time \emph{t} to
#' develop matrices for. Must be in reference to the \code{listofyears} object
#' developed in the \code{R} matrix estimator function.
#' @param patchnumber An integer specifying which patch to develop matrices
#' for. Must be in reference to the \code{listofyears} object developed in the
#' \code{R} matrix estimator function.
#' @param exp_tol A numeric value indicating the maximum limit for the
#' \code{exp()} function to be used in vital rate calculations. Defaults to
#' \code{700.0}.
#' @param theta_tol A numeric value indicating a maximum value for theta in
#' negative binomial probability density estimation. Defaults to
#' \code{100000000.0}.
#' @param ipm_method A string indicating which method should be used to
#' estimate size transitions in cases with continuous distributions. Options
#' include \code{"midpoint"}, which uses the midpoint method, and \code{"cdf"},
#' which uses the cumulative density function.
#' @param err_check A logical value indicating whether to export a matrix of
#' conditional probabilities used to develop the \code{U} matrix. Defaults to
#' \code{FALSE}.
#' @param simplicity A logical value indicating whether to output all three
#' matrices (\code{FALSE}), and just matrices \code{U} and \code{F}
#' (\code{TRUE}). Defaults to \code{FALSE}.
#' 
#' @return A list with 2, 3, or 4 elements. If \code{simplicity} is set to
#' \code{FALSE}, then the first 3 elements are matrices, including the main MPM
#' (A), the survival-transition matrix (U), and a fecundity matrix (F). If
#' simplicity is set to \code{TRUE}, then only the survival-transition matrix
#' (U) and fecundity matrix (F) are output. If \code{err_check} is set to
#' \code{TRUE}, then another element is added, which is a 7 column matrix
#' showing survival probability, observation probability, reproduction
#' probability, sizea transition probability, sizeb transition probability,
#' sizec transition probability, and juvenile transition probability to
#' maturity for each element of the final MPM. It is possible that, due to
#' evolving development strategy, further columns are output, as well.
#' 
#' @section Notes:
#' The data frame AllStages introduces variables used in size and fecundity
#' calculations. This DataFrame is broken up into long vectors composed of
#' input sizes and related variables for these calculations. The "model" Lists
#' bring in the vital rate models, and include random coefficients where
#' needed. We also have a number of extra variables, that include such info as
#' whether to use the Poisson, negative binomial, Gamma, or Gaussian
#' distributions for size and fecundity calculations. If \code{sizedist},
#' \code{sizebdist}, \code{sizecdist}, or \code{fecdist} equals 0, 1, 2, or 3,
#' then the Poisson, negative binomial, Gaussian, or Gamma is used,
#' respectively.
#' 
#' @keywords internal
#' @noRd
.jerzeibalowski <- function(AllStages, stageframe, matrixformat, survproxy, obsproxy, sizeproxy, sizebproxy, sizecproxy, repstproxy, fecproxy, jsurvproxy, jobsproxy, jsizeproxy, jsizebproxy, jsizecproxy, jrepstproxy, jmatstproxy, f2_inda, f1_inda, f2_indb, f1_indb, f2_indc, f1_indc, r2_inda, r1_inda, r2_indb, r1_indb, r2_indc, r1_indc, dev_terms, dens_vr, dvr_yn, dvr_style, dvr_alpha, dvr_beta, dens_n, dens, fecmod, maxsize, maxsizeb, maxsizec, firstage, finalage, negfec, yearnumber, patchnumber, exp_tol = 700.0, theta_tol = 100000000.0, ipm_method = "cdf", err_check = FALSE, simplicity = FALSE) {
    .Call('_lefko3_jerzeibalowski', PACKAGE = 'lefko3', AllStages, stageframe, matrixformat, survproxy, obsproxy, sizeproxy, sizebproxy, sizecproxy, repstproxy, fecproxy, jsurvproxy, jobsproxy, jsizeproxy, jsizebproxy, jsizecproxy, jrepstproxy, jmatstproxy, f2_inda, f1_inda, f2_indb, f1_indb, f2_indc, f1_indc, r2_inda, r1_inda, r2_indb, r1_indb, r2_indc, r1_indc, dev_terms, dens_vr, dvr_yn, dvr_style, dvr_alpha, dvr_beta, dens_n, dens, fecmod, maxsize, maxsizeb, maxsizec, firstage, finalage, negfec, yearnumber, patchnumber, exp_tol, theta_tol, ipm_method, err_check, simplicity)
}

#' Estimate All Elements of Function-based Population Projection Sparse Matrix
#' 
#' Function \code{jerzeibalowsk_sp()} swiftly calculates matrix elements in
#' function-based population projection matrices. Used in
#' \code{f_projection3()}.
#' 
#' @name jerzeibalowsk_sp
#' 
#' @param ppy A data frame showing the population, patch, and year of each
#' matrix to create, in order.
#' @param AllStages A large data frame giving all required inputs for vital
#' rate estimation other than the vital rate model coefficients themselves.
#' Contains a row for each ultimate matrix element.
#' @param stageframe The modified stageframe used in matrix calculations.
#' @param matrixformat An integer representing the style of matrix to develop.
#' Options include Ehrlen-format hMPM (1), deVries-format hMPM (2), ahMPM (3),
#' and age-by-stage MPM (4).
#' @param survproxy List of coefficients estimated in model of survival.
#' @param obsproxy List of coefficients estimated in model of observation.
#' @param sizeproxy List of coefficients estimated in model of size.
#' @param repstproxy List of coefficients estimated in model of reproductive 
#' status.
#' @param fecproxy List of coefficients estimated in model of fecundity.
#' @param jsurvproxy List of coefficients estimated in model of juvenile
#' survival.
#' @param jobsproxy List of coefficients estimated in model of juvenile
#' observation.
#' @param jsizeproxy List of coefficients estimated in model of juvenile size.
#' @param jrepstproxy List of coefficients estimated in model of juvenile
#' reproductive status.
#' @param jmatstproxy List of coefficients estimated in model of juvenile
#' maturity probability.
#' @param f2_inda A numeric vector of length equal to the number of years,
#' holding values equal to the mean value of individual covariate \code{a} at
#' each time \emph{t} to be used in analysis.
#' @param f1_inda A numeric vector of length equal to the number of years,
#' holding values equal to the mean value of individual covariate \code{a} at
#' each time \emph{t}-1 to be used in analysis.
#' @param f2_indb A numeric vector of length equal to the number of years,
#' holding values equal to the mean value of individual covariate \code{b} at
#' each time \emph{t} to be used in analysis.
#' @param f1_indb A numeric vector of length equal to the number of years,
#' holding values equal to the mean value of individual covariate \code{b} at
#' each time \emph{t}-1 to be used in analysis.
#' @param f2_indc A numeric vector of length equal to the number of years,
#' holding values equal to the mean value of individual covariate \code{c} at
#' each time \emph{t} to be used in analysis.
#' @param f1_indc A numeric vector of length equal to the number of years,
#' holding values equal to the mean value of individual covariate \code{c} at
#' each time \emph{t}-1 to be used in analysis.
#' @param r2_inda A numeric vector of length equal to the number of years,
#' holding values equal to the mean value of individual random covariate
#' \code{a} at each time \emph{t} to be used in analysis.
#' @param r1_inda A numeric vector of length equal to the number of years,
#' holding values equal to the mean value of individual random covariate
#' \code{a} at each time \emph{t}-1 to be used in analysis.
#' @param r2_indb A numeric vector of length equal to the number of years,
#' holding values equal to the mean value of individual random covariate
#' \code{b} at each time \emph{t} to be used in analysis.
#' @param r1_indb A numeric vector of length equal to the number of years,
#' holding values equal to the mean value of individual random covariate
#' \code{b} at each time \emph{t}-1 to be used in analysis.
#' @param r2_indc A numeric vector of length equal to the number of years,
#' holding values equal to the mean value of individual random covariate
#' \code{c} at each time \emph{t} to be used in analysis.
#' @param r1_indc A numeric vector of length equal to the number of years,
#' holding values equal to the mean value of individual random covariate
#' \code{c} at each time \emph{t}-1 to be used in analysis.
#' @param dev_terms A numeric vector containing the deviations to the linear
#' models input by the user. The order is: survival, observation status, size,
#' size_b, size_c, reproductive status, fecundity, juvenile survival, juvenile
#' observation status, juvenile size, juvenile size_b, juvenile size_c,
#' juvenile reproductive status, and juvenile maturity status.
#' @param dens_vr A logical value indicating whether any vital rates are
#' density dependent.
#' @param dvr_yn A logical vector indicating whether each vital rate is density
#' dependent.
#' @param dvr_style An integer vector indicating the style of density
#' dependence for each vital rate.
#' @param dvr_alpha A numeric vector indicating the value of alpha to use in
#' density dependence for each vital rate.
#' @param dvr_beta A numeric vector indicating the value of beta to use in
#' density dependence for each vital rate.
#' @param dens_n A numeric vector corresponding to the population size to use
#' in vital rate density dependence calculations.
#' @param dens A numeric value equal to the spatial density to be used in
#' calculations.
#' @param fecmod A scalar multiplier for fecundity.
#' @param maxsize The maximum primary size to be used in element estimation.
#' @param maxsizeb The maximum secondary size to be used in element estimation.
#' @param maxsizec The maximum tertiary size to be used in element estimation.
#' @param firstage The first age to be included in age-by-stage MPM estimation.
#' @param finalage The final age to be included in age-by-stage MPM estimation.
#' @param negfec A logical value denoting whether to change negative estimated
#' fecundity to 0.
#' @param yearnumber An integer specifying which time at time \emph{t} to
#' develop matrices for. Must be in reference to the \code{listofyears} object
#' developed in the \code{R} matrix estimator function.
#' @param patchnumber An integer specifying which patch to develop matrices
#' for. Must be in reference to the \code{listofyears} object developed in the
#' \code{R} matrix estimator function.
#' @param exp_tol A numeric value indicating the maximum limit for the
#' \code{exp()} function to be used in vital rate calculations. Defaults to
#' \code{700.0}.
#' @param theta_tol A numeric value indicating a maximum value for theta in
#' negative binomial probability density estimation. Defaults to
#' \code{100000000.0}.
#' @param ipm_method A string indicating which method should be used to
#' estimate size transitions in cases with continuous distributions. Options
#' include \code{"midpoint"}, which uses the midpoint method, and \code{"cdf"},
#' which uses the cumulative density function.
#' @param err_check A logical value indicating whether to export a matrix of
#' conditional probabilities used to develop the \code{U} matrix. Defaults to
#' \code{FALSE}.
#' @param simplicity A logical value indicating whether to output all three
#' matrices (\code{FALSE}), and just matrices \code{U} and \code{F}
#' (\code{TRUE}). Defaults to \code{FALSE}.
#' 
#' @return A list with 2, 3, or 4 elements. If \code{simplicity} is set to
#' \code{FALSE}, then the first 3 elements are matrices, including the main MPM
#' (A), the survival-transition matrix (U), and a fecundity matrix (F). If
#' simplicity is set to \code{TRUE}, then only the survival-transition matrix
#' (U) and fecundity matrix (F) are output. If \code{err_check} is set to
#' \code{TRUE}, then another element is added, which is a 7 column matrix
#' showing survival probability, observation probability, reproduction
#' probability, sizea transition probability, sizeb transition probability,
#' sizec transition probability, and juvenile transition probability to
#' maturity for each element of the final MPM. It is possible that, due to
#' evolving development strategy, further columns are output, as well. All
#' output matrices are sparse matrices.
#' 
#' @section Notes:
#' The data frame AllStages introduces variables used in size and fecundity
#' calculations. This DataFrame is broken up into long vectors composed of
#' input sizes and related variables for these calculations. The "model" Lists
#' bring in the vital rate models, and include random coefficients where
#' needed. We also have a number of extra variables, that include such info as
#' whether to use the Poisson, negative binomial, Gamma, or Gaussian
#' distributions for size and fecundity calculations. If \code{sizedist},
#' \code{sizebdist}, \code{sizecdist}, or \code{fecdist} equals 0, 1, 2, or 3,
#' then the Poisson, negative binomial, Gaussian, or Gamma is used,
#' respectively.
#' 
#' @keywords internal
#' @noRd
.jerzeibalowski_sp <- function(AllStages, stageframe, matrixformat, survproxy, obsproxy, sizeproxy, sizebproxy, sizecproxy, repstproxy, fecproxy, jsurvproxy, jobsproxy, jsizeproxy, jsizebproxy, jsizecproxy, jrepstproxy, jmatstproxy, f2_inda, f1_inda, f2_indb, f1_indb, f2_indc, f1_indc, r2_inda, r1_inda, r2_indb, r1_indb, r2_indc, r1_indc, dev_terms, dens_vr, dvr_yn, dvr_style, dvr_alpha, dvr_beta, dens_n, dens, fecmod, maxsize, maxsizeb, maxsizec, firstage, finalage, negfec, yearnumber, patchnumber, exp_tol = 700.0, theta_tol = 100000000.0, ipm_method = "cdf", err_check = FALSE, simplicity = FALSE) {
    .Call('_lefko3_jerzeibalowski_sp', PACKAGE = 'lefko3', AllStages, stageframe, matrixformat, survproxy, obsproxy, sizeproxy, sizebproxy, sizecproxy, repstproxy, fecproxy, jsurvproxy, jobsproxy, jsizeproxy, jsizebproxy, jsizecproxy, jrepstproxy, jmatstproxy, f2_inda, f1_inda, f2_indb, f1_indb, f2_indc, f1_indc, r2_inda, r1_inda, r2_indb, r1_indb, r2_indc, r1_indc, dev_terms, dens_vr, dvr_yn, dvr_style, dvr_alpha, dvr_beta, dens_n, dens, fecmod, maxsize, maxsizeb, maxsizec, firstage, finalage, negfec, yearnumber, patchnumber, exp_tol, theta_tol, ipm_method, err_check, simplicity)
}

#' Create Historically Structured Version of ahMPM
#' 
#' Function \code{.thefifthhousemate()} takes an ahistorical MPM as input, and
#' uses the \code{allstages} index to create a historically structured version
#' of it.
#' 
#' @name thefifthhousemate
#' 
#' @param mpm The original ahMPM, supplied as a \code{lefkoMat} object.
#' @param allstages The index dataframe developed by
#' \code{\link{.simplepizzle}()}.
#' @param stageframe The ahistorical stageframe supplied by
#' \code{\link{.simplepizzle}()}.
#' @param format Integer indicating whether historical matrices should be in
#' (1) Ehrlen or (2) deVries format.
#' 
#' @return This will return a list of lists. The first list is composed of all
#' new \code{A} matrices. The second list is composed of all new \code{U}
#' matrices. The third list is composed of all new \code{F} matrices.
#' 
#' @keywords internal
#' @noRd
.thefifthhousemate <- function(mpm, allstages, stageframe, format) {
    .Call('_lefko3_thefifthhousemate', PACKAGE = 'lefko3', mpm, allstages, stageframe, format)
}

#' Estimate All Elements of Function-based Population Projection Matrix
#' 
#' Function \code{motherbalowski()} swiftly calculates matrix elements in
#' function-based Leslie population projection matrices. Used in
#' \code{\link{fleslie}()}.
#' 
#' @name motherbalowski
#' 
#' @param actualages An integer vector of all actual ages to be included in the
#' matrices, in order.
#' @param ageframe The modified stageframe used in matrix calculations.
#' @param survproxy List of coefficients estimated in model of survival.
#' @param fecproxy List of coefficients estimated in model of fecundity.
#' @param f2_inda A numeric vector of length equal to the number of years,
#' holding values equal to the mean value of individual covariate \code{a} at
#' each time \emph{t} to be used in analysis.
#' @param f1_inda A numeric vector of length equal to the number of years,
#' holding values equal to the mean value of individual covariate \code{a} at
#' each time \emph{t}-1 to be used in analysis.
#' @param f2_indb A numeric vector of length equal to the number of years,
#' holding values equal to the mean value of individual covariate \code{b} at
#' each time \emph{t} to be used in analysis.
#' @param f1_indb A numeric vector of length equal to the number of years,
#' holding values equal to the mean value of individual covariate \code{b} at
#' each time \emph{t}-1 to be used in analysis.
#' @param f2_indc A numeric vector of length equal to the number of years,
#' holding values equal to the mean value of individual covariate \code{c} at
#' each time \emph{t} to be used in analysis.
#' @param f1_indc A numeric vector of length equal to the number of years,
#' holding values equal to the mean value of individual covariate \code{c} at
#' each time \emph{t}-1 to be used in analysis.
#' @param r2_inda A numeric vector of length equal to the number of years,
#' holding values equal to the mean value of individual random covariate
#' \code{a} at each time \emph{t} to be used in analysis.
#' @param r1_inda A numeric vector of length equal to the number of years,
#' holding values equal to the mean value of individual random covariate
#' \code{a} at each time \emph{t}-1 to be used in analysis.
#' @param r2_indb A numeric vector of length equal to the number of years,
#' holding values equal to the mean value of individual random covariate
#' \code{b} at each time \emph{t} to be used in analysis.
#' @param r1_indb A numeric vector of length equal to the number of years,
#' holding values equal to the mean value of individual random covariate
#' \code{b} at each time \emph{t}-1 to be used in analysis.
#' @param r2_indc A numeric vector of length equal to the number of years,
#' holding values equal to the mean value of individual random covariate
#' \code{c} at each time \emph{t} to be used in analysis.
#' @param r1_indc A numeric vector of length equal to the number of years,
#' holding values equal to the mean value of individual random covariate
#' \code{c} at each time \emph{t}-1 to be used in analysis.
#' @param surv_dev A numeric value indicating the deviation to the linear
#' model of survival input by the user.
#' @param fec_dev A numeric value indicating the deviation to the linear
#' model of fecundity input by the user.
#' @param dens A numeric value equal to the density to be used in calculations.
#' @param fecmod A scalar multiplier for fecundity.
#' @param finalage The final age to be included in Leslie MPM estimation.
#' @param negfec A logical value denoting whether to change negative estimated
#' fecundity to \code{0}.
#' @param yearnumber An integer specifying which time at time \emph{t} to
#' develop matrices for. Must be in reference to the \code{listofyears} object
#' developed in the \code{R} matrix estimator function.
#' @param patchnumber An integer specifying which patch to develop matrices
#' for. Must be in reference to the \code{listofyears} object developed in the
#' \code{R} matrix estimator function.
#' @param dens_vr A logical value indicating whether any vital rates are
#' density dependent.
#' @param dvr_yn A logical vector indicating whether each vital rate is density
#' dependent.
#' @param dvr_style An integer vector indicating the style of density
#' dependence for each vital rate.
#' @param dvr_alpha A numeric vector indicating the value of alpha to use in
#' density dependence for each vital rate.
#' @param dvr_beta A numeric vector indicating the value of beta to use in
#' density dependence for each vital rate.
#' @param dens_n A numeric vector corresponding to the population size to use
#' in vital rate density dependence calculations.
#' @param exp_tol A numeric value indicating the maximum limit for the
#' \code{exp()} function to be used in vital rate calculations. Defaults to
#' \code{700.0}.
#' @param theta_tol A numeric value indicating a maximum value for theta in
#' negative binomial probability density estimation. Defaults to
#' \code{100000000.0}.
#' @param simplicity If \code{TRUE}, then only outputs matrices \code{U} and
#' \code{F}, rather than also outputting matrix \code{A}. Defaults to
#' \code{FALSE}.
#' 
#' @return A list of 3 matrices, including the main MPM (A), the survival-
#' transition matrix (U), and a fecundity matrix (F).
#' 
#' @keywords internal
#' @noRd
.motherbalowski <- function(actualages, ageframe, survproxy, fecproxy, f2_inda, f1_inda, f2_indb, f1_indb, f2_indc, f1_indc, r2_inda, r1_inda, r2_indb, r1_indb, r2_indc, r1_indc, surv_dev, fec_dev, dens, fecmod, finalage, negfec, yearnumber, patchnumber, dens_vr, dvr_yn, dvr_style, dvr_alpha, dvr_beta, dens_n, exp_tol = 700.0, theta_tol = 100000000.0, simplicity = FALSE) {
    .Call('_lefko3_motherbalowski', PACKAGE = 'lefko3', actualages, ageframe, survproxy, fecproxy, f2_inda, f1_inda, f2_indb, f1_indb, f2_indc, f1_indc, r2_inda, r1_inda, r2_indb, r1_indb, r2_indc, r1_indc, surv_dev, fec_dev, dens, fecmod, finalage, negfec, yearnumber, patchnumber, dens_vr, dvr_yn, dvr_style, dvr_alpha, dvr_beta, dens_n, exp_tol, theta_tol, simplicity)
}

#' Extract Coefficients From Linear Vital Rate Models
#' 
#' Function \code{modelextract()} extracts coefficient values from linear
#' models estimated through various linear modeling functions in R, to estimate
#' vital rates in \code{lefko3}. Used to supply coefficients to
#' \code{\link{flefko3}()}, \code{\link{flefko2}()}, \code{\link{fleslie()}},
#' and \code{\link{aflefko2}()}.
#' 
#' @param object A linear model estimated through one of the methods used in
#' function \code{\link{modelsearch}()}.
#' @param paramnames Data frame giving the names of standard coefficients
#' required by matrix creation functions.
#' @param mainyears A vector of the names of the monitoring occasions.
#' @param mainpatches A vector of the names of the patches. Should be \code{NA}
#' if no patches specified.
#' @param maingroups A vector of the names of all stage groups.
#' @param mainindcova A vector denoting values of individual covariate
#' \code{a}, when that individual covariate is categorical.
#' @param mainindcovb A vector denoting values of individual covariate
#' \code{b}, when that individual covariate is categorical.
#' @param mainindcovc A vector denoting values of individual covariate
#' \code{c}, when that individual covariate is categorical.
#' 
#' @return This function returns a list with the following elements:
#' \item{coefficients}{Vector of fixed effect coefficients.}
#' \item{years}{Vector of occasion coefficients, typically random.}
#' \item{zeroyear}{Vector of zero-inflated occasion coefficients, typically
#' random.}
#' \item{patches}{Vector of patch coefficients, typically random.}
#' \item{zeropatch}{Vector of zero-inflated patch coefficients, typically
#' random.}
#' \item{groups2}{Vector of group coefficients for time t.}
#' \item{groups1}{Vector of group coefficients for time t-1.}
#' \item{zerogroups2}{Vector of zero-inflated group coefficients for time t.}
#' \item{zerogroups1}{Vector of zero-inflated group coefficients for time t-1.}
#' \item{indcova2s}{Vector of individual covariate \code{a} values for time t.}
#' \item{indcova1s}{Vector of individual covariate \code{a} values for time t-1.}
#' \item{indcovb2s}{Vector of individual covariate \code{b} values for time t.}
#' \item{indcovb1s}{Vector of individual covariate \code{b} values for time t-1.}
#' \item{indcovc2s}{Vector of individual covariate \code{c} values for time t.}
#' \item{indcovc1s}{Vector of individual covariate \code{c} values for time t-1.}
#' \item{zeroindcova2s}{Vector of zero-inflated individual covariate \code{a}
#' values for time t.}
#' \item{zeroindcova1s}{Vector of zero-inflated individual covariate \code{a}
#' values for time t-1.}
#' \item{zeroindcovb2s}{Vector of zero-inflated individual covariate \code{b}
#' values for time t.}
#' \item{zeroindcovb1s}{Vector of zero-inflated individual covariate \code{b}
#' values for time t-1.}
#' \item{zeroindcovc2s}{Vector of zero-inflated individual covariate \code{c}
#' values for time t.}
#' \item{zeroindcovc1s}{Vector of zero-inflated individual covariate \code{c}
#' values for time t-1.}
#' \item{class}{The R class of the vital rate model.}
#' \item{family}{The response distribution.}
#' \item{dist}{An integer representing the response distribution. \code{0} = 
#' poisson, \code{1} = negbin, \code{2} = gaussian, \code{3} = gamma, \code{4}
#' = binomial, and \code{5} = constant.}
#' \item{zero_inflated}{A logical value indicating whether the distribution is
#' zero-inflated.}
#' \item{zero_truncated}{A logical value indicating whether the distribution is
#' zero-truncated.}
#' \item{sigma}{The residual standard deviation of the model. Defaults to
#' \code{1.0}. Equivalent output to package lme4's \code{sigma()} function.}
#' \item{theta}{The scale parameter theta used in the negative binomial
#' distribution. Defaults to \code{1.0}.}
#' 
#' @keywords internal
#' @noRd
.modelextract <- function(object, paramnames, mainyears, mainpatches, maingroups, mainindcova, mainindcovb, mainindcovc) {
    .Call('_lefko3_modelextract', PACKAGE = 'lefko3', object, paramnames, mainyears, mainpatches, maingroups, mainindcova, mainindcovb, mainindcovc)
}

#' Key Function Passing Models and Other Parameters to Matrix Estimators
#' 
#' Function \code{raymccooney()} takes the various vital rate models and other
#' parameters and coordinates them as input into the function-based matrix
#' estimation functions.
#' 
#' @name raymccooney
#' 
#' @param listofyears A data frame where the rows designate the exact order of
#' years and patches to produce matrices for.
#' @param modelsuite An object of class \code{lefkoMod}, or a similarly
#' structured list object. All 14 vital rate models and the \code{paramnames}
#' data frame are required.
#' @param mainyears A numeric vector of all times at time \emph{t}.
#' @param mainpatches A string vector of patch names.
#' @param maingroups A string vector of stage group names.
#' @param mainindcova Typically a string vector of individual covariate
#' category names.
#' @param mainindcovb Typically a string vector of individual covariate
#' category names.
#' @param mainindcovc Typically a string vector of individual covariate
#' category names.
#' @param StageFrame The stageframe object identifying the life history model
#' being operationalized.
#' @param OverWrite The overwrite table used in analysis, as modified by 
#' \code{.overwrite_reassess}. Must be processed via \code{.overwrite_reassess}
#' rather than being a raw overwrite or supplement table.
#' @param repmatrix The reproductive matrix used in analysis.
#' @param f2_inda A numeric vector of length equal to the number of years,
#' holding values equal to the mean value of individual covariate \code{a} at
#' each time \emph{t} to be used in analysis.
#' @param f1_inda A numeric vector of length equal to the number of years,
#' holding values equal to the mean value of individual covariate \code{a} at
#' each time \emph{t}-1 to be used in analysis.
#' @param f2_indb A numeric vector of length equal to the number of years,
#' holding values equal to the mean value of individual covariate \code{b} at
#' each time \emph{t} to be used in analysis.
#' @param f1_indb A numeric vector of length equal to the number of years,
#' holding values equal to the mean value of individual covariate \code{b} at
#' each time \emph{t}-1 to be used in analysis.
#' @param f2_indc A numeric vector of length equal to the number of years,
#' holding values equal to the mean value of individual covariate \code{c} at
#' each time \emph{t} to be used in analysis.
#' @param f1_indc A numeric vector of length equal to the number of years,
#' holding values equal to the mean value of individual covariate \code{c} at
#' each time \emph{t}-1 to be used in analysis.
#' @param r2_inda A numeric vector of length equal to the number of years,
#' holding values equal to the mean value of individual random covariate
#' \code{a} at each time \emph{t} to be used in analysis.
#' @param r1_inda A numeric vector of length equal to the number of years,
#' holding values equal to the mean value of individual random covariate
#' \code{a} at each time \emph{t}-1 to be used in analysis.
#' @param r2_indb A numeric vector of length equal to the number of years,
#' holding values equal to the mean value of individual random covariate
#' \code{b} at each time \emph{t} to be used in analysis.
#' @param r1_indb A numeric vector of length equal to the number of years,
#' holding values equal to the mean value of individual random covariate
#' \code{b} at each time \emph{t}-1 to be used in analysis.
#' @param r2_indc A numeric vector of length equal to the number of years,
#' holding values equal to the mean value of individual random covariate
#' \code{c} at each time \emph{t} to be used in analysis.
#' @param r1_indc A numeric vector of length equal to the number of years,
#' holding values equal to the mean value of individual random covariate
#' \code{c} at each time \emph{t}-1 to be used in analysis.
#' @param dev_terms A numeric vector containing the deviations to the linear
#' models input by the user. The order is: survival, observation status, size,
#' size_b, size_c, reproductive status, fecundity, juvenile survival, juvenile
#' observation status, juvenile size, juvenile size_b, juvenile size_c,
#' juvenile reproductive status, and juvenile maturity status.
#' @param dens A numeric value equal to the density to be used in calculations.
#' @param fecmod A scalar multiplier for fecundity.
#' @param firstage The first age to be used in the analysis. Should typically
#' be \code{0} for pre-breeding and \code{1} for post-breeding life history
#' models. If not building age-by-stage MPMs, then should be set to \code{0}.
#' @param finalage The final age to be used in analysis. If not building
#' age-by-stage MPMs, then should be set to \code{0}.
#' @param format Indicates whether historical matrices should be in (1) Ehrlen
#' or (2) deVries format.
#' @param style The style of analysis, where 0 is historical, 1 is ahistorical,
#' and 2 is age-by-stage.
#' @param cont Denotes whether age-by-stage matrix continues past the final
#' age.
#' @param filter An integer denoting whether to filter the DataFrame to
#' eliminate unusable rows, and if so, how to do so. Possible values: \code{0}:
#' no filtering, \code{1}: filter out rows with \code{index321 == -1}, and
#' \code{2}: filter out rows with \code{aliveandequal == -1}.
#' @param negfec A logical value denoting whether to change negative estimated
#' fecundity to 0.
#' @param exp_tol A numeric value indicating the maximum limit for the
#' \code{exp()} function to be used in vital rate calculations. Defaults to
#' \code{700.0}.
#' @param theta_tol A numeric value indicating a maximum value for theta in
#' negative binomial probability density estimation. Defaults to
#' \code{100000000.0}.
#' @param ipm_method A string indicating which method should be used to
#' estimate size transitions in cases with continuous distributions. Options
#' include \code{"midpoint"}, which uses the midpoint method, and \code{"cdf"},
#' which uses the cumulative density function.
#' @param err_check If \code{TRUE}, then also output objects \code{prob_out}
#' and \code{allstages} for error checking purposes.
#' @param simplicity If \code{TRUE}, then only outputs matrices \code{U} and
#' \code{F}, rather than also outputting matrix \code{A}. Defaults to
#' \code{FALSE}.
#' 
#' @return A list with with up to 5 elements. In order: \code{A}: a list of A
#' matrices, or a list of \code{NULL} values if \code{simplicity = TRUE};
#' \code{U}: a list of U matrices, in the same order as \code{A}; \code{F}:
#' a list of F matrices, in the same order as \code{A}; \code{prob_out}: a list
#' of error-checking conditional probability matrices, or a list of \code{NULL}
#' values if \code{err_check = FALSE}; and \code{allstages}: a data frame
#' showing the used values of all variables used in transition calculations.
#' 
#' @keywords internal
#' @noRd
.raymccooney <- function(listofyears, modelsuite, mainyears, mainpatches, maingroups, mainindcova, mainindcovb, mainindcovc, StageFrame, OverWrite, repmatrix, f2_inda, f1_inda, f2_indb, f1_indb, f2_indc, f1_indc, r2_inda, r1_inda, r2_indb, r1_indb, r2_indc, r1_indc, dev_terms, dens, fecmod, firstage, finalage, format, style, cont, filter, negfec, exp_tol = 700.0, theta_tol = 100000000.0, ipm_method = "cdf", err_check = FALSE, simplicity = FALSE) {
    .Call('_lefko3_raymccooney', PACKAGE = 'lefko3', listofyears, modelsuite, mainyears, mainpatches, maingroups, mainindcova, mainindcovb, mainindcovc, StageFrame, OverWrite, repmatrix, f2_inda, f1_inda, f2_indb, f1_indb, f2_indc, f1_indc, r2_inda, r1_inda, r2_indb, r1_indb, r2_indc, r1_indc, dev_terms, dens, fecmod, firstage, finalage, format, style, cont, filter, negfec, exp_tol, theta_tol, ipm_method, err_check, simplicity)
}

#' Function Passing Models and Other Parameters to Leslie Matrix Estimator
#' 
#' This function takes the various vital rate models and other parameters and
#' coordinates them as input into function \code{fleslie()}.
#' 
#' @name mothermccooney
#' 
#' @param listofyears A data frame where the rows designate the exact order of
#' years and patches to produce matrices for.
#' @param modelsuite An object of class \code{lefkoMod}, or a similarly
#' structured list object. Survival model, fecundity model, and the
#' \code{paramnames} data frame are required.
#' @param actualages An integer vector of all actual ages to be included in the
#' matrices, in order.
#' @param mainyears A numeric vector of all times at time \emph{t}.
#' @param mainpatches A string vector of patch names.
#' @param maingroups A string vector of stage group names.
#' @param mainindcova Typically a string vector of individual covariate
#' category names.
#' @param mainindcovb Typically a string vector of individual covariate
#' category names.
#' @param mainindcovc Typically a string vector of individual covariate
#' category names.
#' @param ageframe The modified stageframe used in matrix calculations.
#' @param f2_inda A numeric vector of length equal to the number of years,
#' holding values equal to the mean value of individual covariate \code{a} at
#' each time \emph{t} to be used in analysis.
#' @param f1_inda A numeric vector of length equal to the number of years,
#' holding values equal to the mean value of individual covariate \code{a} at
#' each time \emph{t}-1 to be used in analysis.
#' @param f2_indb A numeric vector of length equal to the number of years,
#' holding values equal to the mean value of individual covariate \code{b} at
#' each time \emph{t} to be used in analysis.
#' @param f1_indb A numeric vector of length equal to the number of years,
#' holding values equal to the mean value of individual covariate \code{b} at
#' each time \emph{t}-1 to be used in analysis.
#' @param f2_indc A numeric vector of length equal to the number of years,
#' holding values equal to the mean value of individual covariate \code{c} at
#' each time \emph{t} to be used in analysis.
#' @param f1_indc A numeric vector of length equal to the number of years,
#' holding values equal to the mean value of individual covariate \code{c} at
#' each time \emph{t}-1 to be used in analysis.
#' @param r2_inda A numeric vector of length equal to the number of years,
#' holding values equal to the mean value of individual random covariate
#' \code{a} at each time \emph{t} to be used in analysis.
#' @param r1_inda A numeric vector of length equal to the number of years,
#' holding values equal to the mean value of individual random covariate
#' \code{a} at each time \emph{t}-1 to be used in analysis.
#' @param r2_indb A numeric vector of length equal to the number of years,
#' holding values equal to the mean value of individual random covariate
#' \code{b} at each time \emph{t} to be used in analysis.
#' @param r1_indb A numeric vector of length equal to the number of years,
#' holding values equal to the mean value of individual random covariate
#' \code{b} at each time \emph{t}-1 to be used in analysis.
#' @param r2_indc A numeric vector of length equal to the number of years,
#' holding values equal to the mean value of individual random covariate
#' \code{c} at each time \emph{t} to be used in analysis.
#' @param r1_indc A numeric vector of length equal to the number of years,
#' holding values equal to the mean value of individual random covariate
#' \code{c} at each time \emph{t}-1 to be used in analysis.
#' @param dev_terms A numeric vector containing the deviations to the linear
#' models input by the user. The order is: survival, and fecundity.
#' @param dens A numeric value equal to the density to be used in calculations.
#' @param fecmod A scalar multiplier for fecundity.
#' @param finalage The final age to be used in analysis.
#' @param cont Denotes whether age-by-stage matrix continues past the final
#' age.
#' @param negfec A logical value denoting whether to change negative estimated
#' fecundity to 0.
#' @param exp_tol A numeric value indicating the maximum limit for the
#' \code{exp()} function to be used in vital rate calculations. Defaults to
#' \code{700.0}.
#' @param simplicity If \code{TRUE}, then only outputs matrices \code{U} and
#' \code{F}, rather than also outputting matrix \code{A}. Defaults to
#' \code{FALSE}.
#' 
#' @return A list with with up to 5 elements. In order: \code{A}: a list of A
#' matrices, or a list of \code{NULL} values if \code{simplicity = TRUE};
#' \code{U}: a list of U matrices, in the same order as \code{A}; \code{F}:
#' a list of F matrices, in the same order as \code{A}; \code{prob_out}: a list
#' of error-checking conditional probability matrices, or a list of \code{NULL}
#' values if \code{err_check = FALSE}; and \code{allstages}: a data frame
#' showing the used values of all variables used in transition calculations.
#' 
#' @keywords internal
#' @noRd
.mothermccooney <- function(listofyears, modelsuite, actualages, mainyears, mainpatches, maingroups, mainindcova, mainindcovb, mainindcovc, ageframe, f2_inda, f1_inda, f2_indb, f1_indb, f2_indc, f1_indc, r2_inda, r1_inda, r2_indb, r1_indb, r2_indc, r1_indc, dev_terms, dens, fecmod, finalage, cont, negfec, exp_tol = 700.0, theta_tol = 100000000.0, err_check = FALSE, simplicity = FALSE) {
    .Call('_lefko3_mothermccooney', PACKAGE = 'lefko3', listofyears, modelsuite, actualages, mainyears, mainpatches, maingroups, mainindcova, mainindcovb, mainindcovc, ageframe, f2_inda, f1_inda, f2_indb, f1_indb, f2_indc, f1_indc, r2_inda, r1_inda, r2_indb, r1_indb, r2_indc, r1_indc, dev_terms, dens, fecmod, finalage, cont, negfec, exp_tol, theta_tol, err_check, simplicity)
}

#' Project Function-based Matrix Projection Model
#' 
#' Function \code{f_projection3()} develops and projects function-based matrix
#' models. Unlike \code{\link{projection3}()}, which uses matrices provided as
#' input via already created \code{lefkoMat} objects, function
#' \code{f_projection3()} creates matrices at each time step from vital rate
#' models and parameter inputs provided. Projections may be deterministic or
#' stochastic, and may be density dependent in either case. Replicates may also
#' be produced.
#' 
#' @name f_projection3
#' 
#' @param data The historical vertical demographic data frame used to estimate
#' vital rates (class \code{hfvdata}), which is required to initialize times and
#' patches properly. Variable names should correspond to the naming conventions
#' in \code{\link{verticalize3}()} and \code{\link{historicalize3}()}.
#' @param format An integer indicating the kind of function-based MPM to create.
#' Possible choices include: \code{1}, Ehrlen-format historical MPM; \code{2},
#' deVries-format historical MPM; \code{3}, ahistorical MPM; \code{4},
#' age-by-stage MPM; and \code{5}, Leslie (age-based) MPM.
#' @param prebreeding A logical value indicating whether the life history model
#' is a pre-breeding model. Only used in Leslie and age-by-stage MPMs. Defaults
#' to \code{TRUE}.
#' @param start_age The age from which to start the matrix. Defaults to
#' \code{NA}, in which case age \code{1} is used if \code{prebreeding = TRUE},
#' and age \code{0} is used if \code{prebreeding = FALSE}.
#' @param last_age The final age to use in the matrix. Defaults to \code{NA}, in
#' which case the highest age in the dataset is used.
#' @param fecage_min The minimum age at which reproduction is possible. Defaults
#' to \code{NA}, which is interpreted to mean that fecundity should be assessed
#' starting in the minimum age observed in the dataset.
#' @param fecage_max The maximum age at which reproduction is possible. Defaults
#' to \code{NA}, which is interpreted to mean that fecundity should be assessed
#' until the final observed age.
#' @param cont A logical value designating whether to allow continued survival
#' of individuals past the final age noted in the stageframe, using the 
#' demographic characteristics of the final age. Defaults to \code{TRUE}.
#' @param stochastic A logical value denoting whether to conduct a stochastic
#' projection or a deterministic / cyclical projection.
#' @param standardize A logical value denoting whether to re-standardize the
#' population size to \code{1.0} at each occasion. Used in density-independent
#' simulations in which it is more important to know the general trend in
#' population growth than the explicit growth rate. Defaults to \code{FALSE}.
#' @param growthonly A logical value indicating whether to produce only the
#' projected population size at each occasion (\code{TRUE}), or also to produce
#' vectors showing the stage distribution at each occasion (\code{FALSE}).
#' Defaults to \code{TRUE}.
#' @param repvalue A logical value indicating whether to calculate reproductive
#' value vectors at each time step. Can only be set to \code{TRUE} if 
#' \code{growthonly = FALSE}. Setting to \code{TRUE} may dramatically increase
#' the duration of calculations. Defaults to \code{FALSE}.
#' @param integeronly A logical value indicating whether to round the number of
#' individuals projected in each stage at each occasion to the nearest
#' integer. Defaults to \code{FALSE}.
#' @param substoch An integer value indicating whether to force survival-
#' transition matrices to be substochastic in density dependent and density
#' independent simulations. Defaults to \code{0}, which does not enforce
#' substochasticity. Alternatively, \code{1} forces all survival-transition
#' elements to range from 0.0 to 1.0, and forces fecundity to be non-negative;
#' and \code{2} forces all column rows in the survival-transition matrices to
#' total no more than 1.0, in addition to the actions outlined for option
#' \code{1}. Both settings \code{1} and \code{2} change negative fecundity
#' elements to \code{0.0}.
#' @param ipm_method A string indicating what method to use to estimate size
#' transition probabilities, if size is treated as continuous. Options include:
#' \code{"midpoint"}, which utilizes the midpoint method; and \code{"CDF"},
#' which uses the cumulative distribution function. Defaults to \code{"CDF"}.
#' @param nreps The number of replicate projections. Defaults to \code{1}.
#' @param times Number of occasions to iterate per replicate. Defaults to
#' \code{10000}.
#' @param repmod A scalar multiplier of fecundity. Defaults to \code{1}.
#' @param exp_tol A numeric value used to indicate a maximum value to set
#' exponents to in the core kernel to prevent numerical overflow. Defaults to
#' \code{700}.
#' @param theta_tol A numeric value used to indicate a maximum value to theta as
#' used in the negative binomial probability density kernel. Defaults to
#' \code{100000000}, but can be reset to other values during error checking.
#' @param random_inda A logical value denoting whether to treat individual
#' covariate \code{a} as a random, categorical variable. Otherwise is treated as
#' a fixed, numeric variable. Defaults to \code{FALSE}.
#' @param random_indb A logical value denoting whether to treat individual
#' covariate \code{b} as a random, categorical variable. Otherwise is treated as
#' a fixed, numeric variable. Defaults to \code{FALSE}.
#' @param random_indc A logical value denoting whether to treat individual
#' covariate \code{c} as a random, categorical variable. Otherwise is treated as
#' a fixed, numeric variable. Defaults to \code{FALSE}.
#' @param err_check A logical value indicating whether to append extra output
#' for debugging purposes. Defaults to \code{FALSE}.
#' @param quiet A logical value indicating whether warning messages should be
#' suppressed. Defaults to \code{FALSE}.
#' @param stageframe An object of class \code{stageframe}. These objects are
#' generated by function \code{\link{sf_create}()}, and include information on
#' the size, observation status, propagule status, reproduction status,
#' immaturity status, maturity status, stage group, size bin widths, and other
#' key characteristics of each ahistorical stage. Required for all MPM formats
#' except Leslie MPMs.
#' @param supplement An optional data frame of class \code{lefkoSD} that
#' provides supplemental data that should be incorporated into the MPM. Three
#' kinds of data may be integrated this way: transitions to be estimated via the
#' use of proxy transitions, transition overwrites from the literature or
#' supplemental studies, and transition multipliers for survival and fecundity.
#' This data frame should be produced using the \code{\link{supplemental}()}
#' function. Can be used in place of or in addition to an overwrite table (see 
#' \code{overwrite} below) and a reproduction matrix (see \code{repmatrix}
#' below).
#' @param repmatrix An optional reproduction matrix. This matrix is composed
#' mostly of \code{0}s, with non-zero entries acting as element identifiers and
#' multipliers for fecundity (with \code{1} equaling full fecundity). If left
#' blank, and no \code{supplement} is provided, then \code{flefko3()} will
#' assume that all stages marked as reproductive produce offspring at 1x that of
#' estimated fecundity, and that offspring production will yield the first stage
#' noted as propagule or immature. May be the dimensions of either a historical
#' or an ahistorical matrix. If the latter, then all stages will be used in
#' occasion \emph{t}-1 for each suggested ahistorical transition.
#' @param overwrite An optional data frame developed with the
#' \code{\link{overwrite}()} function describing transitions to be overwritten
#' either with given values or with other estimated transitions. Note that this
#' function supplements overwrite data provided in \code{supplement}.
#' @param modelsuite A \code{lefkoMod} object, at minimum with all required
#' best-fit vital rate models and a \code{paramnames} data frame, and following
#' the naming conventions used in this package. If given, then
#' \code{surv_model}, \code{obs_model}, \code{size_model}, \code{sizeb_model},
#' \code{sizec_model}, \code{repst_model}, \code{fec_model}, \code{jsurv_model},
#' \code{jobs_model}, \code{jsize_model}, \code{jsizeb_model},
#' \code{jsizec_model}, \code{jrepst_model}, \code{jmatst_model},
#' \code{paramnames}, \code{yearcol}, and \code{patchcol} are not required.
#' Although this is optional input, it is recommended, and without it separate
#' vital rate model inputs (named \code{XX_model}) are required.
#' @param paramnames A data frame with three columns, the first describing all
#' terms used in linear modeling, the second (must be called \code{mainparams})
#' giving the general model terms that will be used in matrix creation, and the
#' third showing the equivalent terms used in modeling (must be named
#' \code{modelparams}). Function \code{\link{create_pm}()} can be used to
#' create a skeleton \code{paramnames} object, which can then be edited. Only
#' required if \code{modelsuite} is not supplied.
#' @param year Either a single integer value corresponding to the year to
#' project, or a vector of \code{times} elements with the year to use at each
#' time step. Defaults to \code{NA}, in which the first year in the set of years
#' in the dataset is projected. If a vector shorter than \code{times} is
#' supplied, then this vector will be cycled.
#' @param patch A value of \code{NA}, a single string value corresponding to the
#' patch to project, or a vector of \code{times} elements with the patch to use
#' at each time step. If a vector shorter than \code{times} is supplied, then
#' this vector will be cycled. Note that this function currently does not
#' handle multiple projections for different patches in the same run.
#' @param sp_density Either a single numeric value of spatial density to use in
#' vital rate models in all time steps, or a vector of \code{times} elements of
#' such numeric values. Defaults to \code{NA}.
#' @param ind_terms An optional data frame with 3 columns and \code{times} rows
#' giving the values of individual covariates a, b, and c, respectively, for
#' each projected time. Unused terms must be set to \code{0} (use of \code{NA}
#' will produce errors.)
#' @param dev_terms An optional data frame with 14 columns and \code{times}
#' rows showing the values of the deviation terms to be added to each linear
#' vital rate. The column order should be: 1: survival, 2: observation, 3:
#' primary size, 4: secondary size, 5: tertiary size, 6: reproduction, 7:
#' fecundity, 8: juvenile survival, 9: juvenile observation, 10: juvenile
#' primary size, 11: juvenile secondary size, 12: juvenile tertiary size, 13:
#' juvenile reproduction, and 14: juvenile maturity transition.  Unused terms
#' must be set to \code{0} (use of \code{NA} will produce errors.)
#' @param surv_model A linear model predicting survival probability. This can 
#' be a model of class \code{glm} or \code{glmer}, and requires a predicted
#' binomial variable under a logit link. Ignored if \code{modelsuite} is
#' provided. This model must have been developed in a modeling exercise testing
#' the impacts of occasions \emph{t} and \emph{t}-1.
#' @param obs_model A linear model predicting sprouting or observation
#' probability. This can be a model of class \code{glm} or \code{glmer}, and
#' requires a predicted binomial variable under a logit link. Ignored if
#' \code{modelsuite} is provided. This model must have been developed in a
#' modeling exercise testing the impacts of occasions \emph{t} and \emph{t}-1.
#' @param size_model A linear model predicting primary size. This can be a model
#' of class \code{glm}, \code{glmer}, \code{glmmTMB}, \code{zeroinfl},
#' \code{vglm}, \code{lm}, or \code{lmer}. Ignored if \code{modelsuite} is
#' provided. This model must have been developed in a modeling exercise testing
#' the impacts of occasions \emph{t} and \emph{t}-1.
#' @param sizeb_model A linear model predicting secondary size. This can be a
#' model of class \code{glm}, \code{glmer}, \code{glmmTMB}, \code{zeroinfl},
#' \code{vglm}, \code{lm}, or \code{lmer}. Ignored if \code{modelsuite} is
#' provided. This model must have been developed in a modeling exercise testing
#' the impacts of occasions \emph{t} and \emph{t}-1.
#' @param sizec_model A linear model predicting tertiary size. This can be a
#' model of class \code{glm}, \code{glmer}, \code{glmmTMB}, \code{zeroinfl},
#' \code{vglm}, \code{lm}, or \code{lmer}. Ignored if \code{modelsuite} is
#' provided. This model must have been developed in a modeling exercise testing
#' the impacts of occasions \emph{t} and \emph{t}-1.
#' @param repst_model A linear model predicting reproduction probability. This 
#' can be a model of class \code{glm} or \code{glmer}, and requires a predicted
#' binomial variable under a logit link. Ignored if \code{modelsuite} is
#' provided. This model must have been developed in a modeling exercise testing
#' the impacts of occasions \emph{t} and \emph{t}-1.
#' @param fec_model A linear model predicting fecundity. This can be a model of
#' class \code{glm}, \code{glmer}, \code{glmmTMB}, \code{zeroinfl}, \code{vglm},
#' \code{lm}, or \code{lmer}. Ignored if \code{modelsuite} is provided. This
#' model must have been developed in a modeling exercise testing the impacts of
#' occasions \emph{t} and \emph{t}-1.
#' @param jsurv_model A linear model predicting juvenile survival probability.
#' This can be a model of class \code{glm} or \code{glmer}, and requires a
#' predicted binomial variable under a logit link. Ignored if \code{modelsuite}
#' is provided. This model must have been developed in a modeling exercise
#' testing the impacts of occasions \emph{t} and \emph{t}-1.
#' @param jobs_model A linear model predicting juvenile sprouting or observation
#' probability. This can be a model of class \code{glm} or \code{glmer}, and
#' requires a predicted binomial variable under a logit link. Ignored if
#' \code{modelsuite} is provided. This model must have been developed in a
#' modeling exercise testing the impacts of occasions \emph{t} and \emph{t}-1.
#' @param jsize_model A linear model predicting juvenile primary size. This
#' can be a model of class \code{glm}, \code{glmer}, \code{glmmTMB},
#' \code{zeroinfl}, \code{vglm}, \code{lm}, or \code{lmer}. Ignored if
#' \code{modelsuite} is provided. This model must have been developed in a
#' modeling exercise testing the impacts of occasions \emph{t} and \emph{t}-1.
#' @param jsizeb_model A linear model predicting juvenile secondary size. This
#' can be a model of class \code{glm}, \code{glmer}, \code{glmmTMB},
#' \code{zeroinfl}, \code{vglm}, \code{lm}, or \code{lmer}. Ignored if
#' \code{modelsuite} is provided. This model must have been developed in a
#' modeling exercise testing the impacts of occasions \emph{t} and \emph{t}-1.
#' @param jsizec_model A linear model predicting juvenile tertiary size. This
#' can be a model of class \code{glm}, \code{glmer}, \code{glmmTMB},
#' \code{zeroinfl}, \code{vglm}, \code{lm}, or \code{lmer}. Ignored if
#' \code{modelsuite} is provided. This model must have been developed in a
#' modeling exercise testing the impacts of occasions \emph{t} and \emph{t}-1.
#' @param jrepst_model A linear model predicting reproduction probability of a 
#' mature individual that was immature in time \emph{t}. This can be a model
#' of class \code{glm} or \code{glmer}, and requires a predicted binomial
#' variable under a logit link. Ignored if \code{modelsuite} is provided. This
#' model must have been developed in a modeling exercise testing the impacts of
#' occasions \emph{t} and \emph{t}-1.
#' @param jmatst_model A linear model predicting maturity probability of an 
#' individual that was immature in time \emph{t}. This can be a model of class
#' \code{glm} or \code{glmer}, and requires a predicted binomial variable under
#' a logit link. Ignored if \code{modelsuite} is provided. This model must have
#' been developed in a modeling exercise testing the impacts of occasions
#' \emph{t} and \emph{t}-1.
#' @param start_vec An optional numeric vector denoting the starting stage
#' distribution for the projection. Defaults to a single individual of each
#' stage.
#' @param start_frame An optional data frame characterizing stages, age-stages,
#' or stage-pairs that should be set to non-zero values in the starting vector,
#' and what those values should be. Can only be used with \code{lefkoMat}
#' objects.
#' @param tweights An optional numeric vector denoting the probabilistic
#' weightings of year terms. Defaults to equal weighting among occasions.
#' @param density An optional data frame describing the matrix elements that
#' will be subject to density dependence, and the exact kind of density
#' dependence that they will be subject to. The data frame used should be an
#' object of class \code{lefkoDens}, which is the output from function
#' \code{\link{density_input}()}.
#' @param density_vr An optional data frame describing density dependence
#' relationships in vital rates, if such relationships are to be assumed. The
#' data frame must be of class \code{lefkoDensVR}, which is the output from the
#' function \code{\link{density_vr}()}.
#' 
#' @return A list of class \code{lefkoProj}, which always includes the first
#' three elements of the following, and also includes the remaining elements
#' below when a \code{lefkoMat} object is used as input:
#' \item{projection}{A list of lists of matrices showing the total number of
#' individuals per stage per occasion. The first list corresponds to each
#' pop-patch followed by each population (this top-level list is a single
#' element in \code{f_projection3()}). The inner list corresponds to
#' replicates within each pop-patch or population.}
#' \item{stage_dist}{A list of lists of the actual stage distribution in each
#' occasion in each replicate in each pop-patch or population. The list
#' structure is the same as in \code{\link{projection3}()}.}
#' \item{rep_value}{A list of lists of the actual reproductive value in each
#' occasion in each replicate in each pop-patch or population. The list
#' structure is the same as in \code{\link{projection3}()}.}
#' \item{pop_size}{A list of matrices showing the total population size in each
#' occasion per replicate (row within data frame) per pop-patch or population
#' (list element). Only a single pop-patch or population is allowed in
#' \code{f_projection3()}}
#' \item{labels}{A data frame showing the order of populations and patches in
#' item \code{projection}.}
#' \item{ahstages}{The original stageframe used in the study.}
#' \item{hstages}{A data frame showing the order of historical stage pairs.}
#' \item{agestages}{A data frame showing the order of age-stage pairs.}
#' \item{labels}{A short data frame indicating the population (always \code{1},
#' and patch (either the numeric index of the single chosen patch, or \code{1}
#' in all other cases).)}
#' \item{control}{A short vector indicating the number of replicates and the
#' number of occasions projected per replicate.}
#' \item{density}{The data frame input under the density option. Only provided
#' if input by the user.}
#' \item{density_vr}{The data frame input under the density_vr option. Only
#' provided if input by the user.}
#' 
#' @section Notes:
#' Population projection can be a very time-consuming activity, and it is most
#' time-consuming when matrices need to be created at each time step. We have
#' created this function to be as quick as possible, but some options will slow
#' the analysis down. First, the \code{err_check} option should always be set
#' to \code{FALSE}, as the added created output will not only slow the analysis
#' down but also potentially crash the memory if matrices are large enough.
#' Second, the \code{repvalue} option should be set to \code{FALSE} unless
#' reproductive values are genuinely needed, since this step requires
#' concurrent backward projection and so in some cases may double total run
#' time. Finally, if the only needed data is the total population size and
#' actual age/stage structure at each time step, then setting \code{growthonly
#' = TRUE} will yield the quickest possible run time.
#' 
#' Projections with large matrices may take a long time to run. To assess the
#' likely running time, try using a low number of iterations on a single
#' replicate first. For example, set \code{nreps = 1} and \code{times = 10} for
#' a trial run. If a full run is set and takes too long, press the STOP button
#' in RStudio to cancel the projection run, or click \code{esc}.
#' 
#' This function currently allows three forms of density dependence. The first
#' modifies matrix elements on the basis of the input provided in option
#' \code{density}, and so alters matrix elements once the matrix has already
#' been created. The second form alters the vital rates estimated, and so
#' estimates matrix elements using vital rate values already modified by
#' density. This second form uses the input provided in option
#' \code{density_vr}. These two forms of density dependence utilize the
#' projected population size at some time to make these alterations. The third
#' form of density dependence also alters the vital rates, but using spatial
#' density supplied via option \code{sp_density} and only in vital rates in
#' which spatial density is included as a fixed factor in the associated
#' vital rate model.
#' 
#' Consistently positive population growth can quickly lead to population size
#' numbers larger than can be handled computationally. In that circumstance, a
#' continuously rising population size will suddenly become \code{NaN} for the
#' remainder of the projection.
#' 
#' This function does not reduce the dimensionality of matrices developed for
#' projection.
#' 
#' @seealso \code{\link{projection3}()}
#' @seealso \code{\link{flefko3}()}
#' @seealso \code{\link{flefko2}()}
#' @seealso \code{\link{aflefko2}()}
#' @seealso \code{\link{fleslie}()}
#' 
#' @examples
#' \donttest{
#' # Lathyrus projection example with historical matrices
#' data(lathyrus)
#' 
#' sizevector <- c(0, 4.6, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 1, 2, 3, 4, 5, 6, 7, 8,
#'   9)
#' stagevector <- c("Sd", "Sdl", "Dorm", "Sz1nr", "Sz2nr", "Sz3nr", "Sz4nr",
#'   "Sz5nr", "Sz6nr", "Sz7nr", "Sz8nr", "Sz9nr", "Sz1r", "Sz2r", "Sz3r", 
#'   "Sz4r", "Sz5r", "Sz6r", "Sz7r", "Sz8r", "Sz9r")
#' repvector <- c(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1)
#' obsvector <- c(0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1)
#' matvector <- c(0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1)
#' immvector <- c(1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)
#' propvector <- c(1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
#'   0)
#' indataset <- c(0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1)
#' binvec <- c(0, 4.6, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 
#'   0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5)
#' 
#' lathframeln <- sf_create(sizes = sizevector, stagenames = stagevector, 
#'   repstatus = repvector, obsstatus = obsvector, matstatus = matvector, 
#'   immstatus = immvector, indataset = indataset, binhalfwidth = binvec, 
#'   propstatus = propvector)
#' 
#' lathvertln <- verticalize3(lathyrus, noyears = 4, firstyear = 1988,
#'   patchidcol = "SUBPLOT", individcol = "GENET", blocksize = 9, 
#'   juvcol = "Seedling1988", sizeacol = "lnVol88", repstracol = "Intactseed88",
#'   fecacol = "Intactseed88", deadacol = "Dead1988", 
#'   nonobsacol = "Dormant1988", stageassign = lathframeln, stagesize = "sizea",
#'   censorcol = "Missing1988", censorkeep = NA, NAas0 = TRUE, censor = TRUE)
#' 
#' lathvertln$feca2 <- round(lathvertln$feca2)
#' lathvertln$feca1 <- round(lathvertln$feca1)
#' lathvertln$feca3 <- round(lathvertln$feca3)
#' 
#' lathmodelsln3 <- modelsearch(lathvertln, historical = TRUE, 
#'   approach = "mixed", suite = "main", 
#'   vitalrates = c("surv", "obs", "size", "repst", "fec"), juvestimate = "Sdl",
#'   bestfit = "AICc&k", sizedist = "gaussian", fecdist = "poisson", 
#'   indiv = "individ", patch = "patchid", year = "year2", year.as.random = TRUE,
#'   patch.as.random = TRUE, show.model.tables = TRUE, quiet = TRUE)
#' 
#' lathsupp3 <- supplemental(stage3 = c("Sd", "Sd", "Sdl", "Sdl", "mat", "Sd", "Sdl"), 
#'   stage2 = c("Sd", "Sd", "Sd", "Sd", "Sdl", "rep", "rep"),
#'   stage1 = c("Sd", "rep", "Sd", "rep", "Sd", "mat", "mat"),
#'   eststage3 = c(NA, NA, NA, NA, "mat", NA, NA),
#'   eststage2 = c(NA, NA, NA, NA, "Sdl", NA, NA),
#'   eststage1 = c(NA, NA, NA, NA, "Sdl", NA, NA),
#'   givenrate = c(0.345, 0.345, 0.054, 0.054, NA, NA, NA),
#'   multiplier = c(NA, NA, NA, NA, NA, 0.345, 0.054),
#'   type = c(1, 1, 1, 1, 1, 3, 3), type_t12 = c(1, 2, 1, 2, 1, 1, 1),
#'   stageframe = lathframeln, historical = TRUE)
#' 
#' # While we do not use MPMs to initialize f_projections3(), we do use MPMs to
#' # initialize functions start_input() and density_input().
#' lathmat3ln <- flefko3(year = "all", patch = "all", stageframe = lathframeln, 
#'   modelsuite = lathmodelsln3, data = lathvertln, supplement = lathsupp3, 
#'   reduce = FALSE)
#' 
#' e3m_sv <- start_input(lathmat3ln, stage2 = "Sd", stage1 = "Sd", value = 1000)
#' 
#' e3d <- density_input(lathmat3ln, stage3 = c("Sd", "Sdl"),
#'   stage2 = c("rep", "rep"), stage1 = c("all", "all"), style = 1,
#'   time_delay = 1, alpha = 1, beta = 0, type = c(2, 2), type_t12 = c(1, 1))
#' 
#' trial7 <- f_projection3(format = 1, data = lathvertln,
#'   modelsuite = lathmodelsln3, stageframe = lathframeln, nreps = 2,
#'   times = 1000, stochastic = TRUE, standardize = FALSE, growthonly = TRUE,
#'   integeronly = FALSE, substoch = 0)
#' summary(trial7)
#' 
#' # Now with density dependence and a set start vector
#' trial7a <- f_projection3(format = 1, data = lathvertln,
#'   modelsuite = lathmodelsln3, stageframe = lathframeln, nreps = 2,
#'   times = 1000, stochastic = TRUE, standardize = FALSE, growthonly = TRUE,
#'   integeronly = FALSE, substoch = 0, sp_density = 0, start_frame = e3m_sv,
#'   density = e3d)
#' summary(trial7a)
#' }
#' 
#' @export f_projection3
f_projection3 <- function(data, format, prebreeding = TRUE, start_age = NA_integer_, last_age = NA_integer_, fecage_min = NA_integer_, fecage_max = NA_integer_, cont = TRUE, stochastic = FALSE, standardize = FALSE, growthonly = TRUE, repvalue = FALSE, integeronly = FALSE, substoch = 0L, ipm_method = "CDF", nreps = 1L, times = 10000L, repmod = 1.0, exp_tol = 700.0, theta_tol = 100000000.0, random_inda = FALSE, random_indb = FALSE, random_indc = FALSE, err_check = FALSE, quiet = FALSE, stageframe = NULL, supplement = NULL, repmatrix = NULL, overwrite = NULL, modelsuite = NULL, paramnames = NULL, year = NULL, patch = NULL, sp_density = NULL, ind_terms = NULL, dev_terms = NULL, surv_model = NULL, obs_model = NULL, size_model = NULL, sizeb_model = NULL, sizec_model = NULL, repst_model = NULL, fec_model = NULL, jsurv_model = NULL, jobs_model = NULL, jsize_model = NULL, jsizeb_model = NULL, jsizec_model = NULL, jrepst_model = NULL, jmatst_model = NULL, start_vec = NULL, start_frame = NULL, tweights = NULL, density = NULL, density_vr = NULL) {
    .Call('_lefko3_f_projection3', PACKAGE = 'lefko3', data, format, prebreeding, start_age, last_age, fecage_min, fecage_max, cont, stochastic, standardize, growthonly, repvalue, integeronly, substoch, ipm_method, nreps, times, repmod, exp_tol, theta_tol, random_inda, random_indb, random_indc, err_check, quiet, stageframe, supplement, repmatrix, overwrite, modelsuite, paramnames, year, patch, sp_density, ind_terms, dev_terms, surv_model, obs_model, size_model, sizeb_model, sizec_model, repst_model, fec_model, jsurv_model, jobs_model, jsize_model, jsizeb_model, jsizec_model, jrepst_model, jmatst_model, start_vec, start_frame, tweights, density, density_vr)
}

#' Estimates Mean LefkoMat Object for Historical MPM
#' 
#' Function \code{turbogeodiesel()} estimates mean historical population
#' projection matrices, treating the mean as element-wise arithmetic.
#' 
#' @name turbogeodiesel
#' 
#' @param loy A data frame denoting the population, patch, and occasion
#' designation for each matrix. Includes a total of 9 variables.
#' @param Umats A matrix with all U matrices turned into columns.
#' @param Fmats A matrix with all F matrices turned into columns.
#' @param hstages This is the \code{hstages} object held by \code{mats}.
#' @param agestages This is the \code{agestages} object held by \code{mats}.
#' @param stages This is the core stageframe held by \code{mats}, equivalent to
#' \code{ahstages}.
#' @param patchmats A logical value stating whether to estimate patch-level
#' means.
#' @param popmats A logical value stating whether to estimate population-level
#' means.
#' 
#' @return A list using the structure of a lefkoMat object.
#' 
#' @keywords internal
#' @noRd
.turbogeodiesel <- function(loy, Umats, Fmats, hstages, agestages, stages, patchmats, popmats) {
    .Call('_lefko3_turbogeodiesel', PACKAGE = 'lefko3', loy, Umats, Fmats, hstages, agestages, stages, patchmats, popmats)
}

#' Estimates Mean LefkoMat Object for Ahistorical MPM
#' 
#' Function \code{geodiesel()} estimates mean ahistorical population
#' projection matrices, treating the mean as element-wise arithmetic. The
#' function can handle both normal ahistorical MPMs and age x stage ahistorical
#' MPMs.
#' 
#' @name geodiesel
#' 
#' @param loy A data frame denoting the population, patch, and occasion
#' designation of each matrix. Includes a total of 9 variables.
#' @param Umats A matrix with all U matrices turned into columns.
#' @param Fmats A matrix with all F matrices turned into columns.
#' @param agestages This is the \code{agestages} object held by \code{mats}.
#' @param stages This is the core stageframe held by \code{mats}, equivalent to
#' \code{ahstages}.
#' @param patchmats A logical value stating whether to estimate patch-level
#' means.
#' @param popmats A logical value stating whether to estimate population-level
#' means.
#' 
#' @return A list using the structure of a LefkoMat object.
#' 
#' @keywords internal
#' @noRd
.geodiesel <- function(loy, Umats, Fmats, agestages, stages, patchmats, popmats) {
    .Call('_lefko3_geodiesel', PACKAGE = 'lefko3', loy, Umats, Fmats, agestages, stages, patchmats, popmats)
}

#' Full Eigen Analysis of a Single Dense Matrix
#' 
#' Function \code{decomp3()} returns all eigenvalues, right eigenvectors, and
#' left eigenvectors estimated for a matrix by the \code{eig_gen}() function
#' in the C++ Armadillo library. Works with dense matrices.
#' 
#' @name decomp3
#' 
#' @param Amat A population projection matrix of class \code{matrix}.
#'
#' @return This function returns all estimated eigenvalues, right
#' eigenvectors, and left eigenvectors of a single matrix. This output is
#' provided as a list with three parts, named appropriately.
#' 
#' @keywords internal
#' @noRd
.decomp3 <- function(Amat) {
    .Call('_lefko3_decomp3', PACKAGE = 'lefko3', Amat)
}

#' Full Eigen Analysis of a Single Sparse Matrix
#' 
#' Function \code{decomp3sp()} returns all eigenvalues, right eigenvectors, and
#' left eigenvectors estimated for a matrix by the \code{eigs_gen}() function
#' in the C++ Armadillo library. Works with sparse matrices.
#' 
#' @name decomp3sp
#' 
#' @param Amat A population projection matrix of class \code{matrix}.
#'
#' @return This function returns all estimated eigenvalues, right
#' eigenvectors, and left eigenvectors of a single matrix. This output is
#' provided as a list with three parts, named appropriately.
#' 
#' @keywords internal
#' @noRd
.decomp3sp <- function(Amat) {
    .Call('_lefko3_decomp3sp', PACKAGE = 'lefko3', Amat)
}

#' Full Eigen Analysis of a Single Sparse Matrix, with Sparse Input
#' 
#' \code{decomp3sp_inp()} returns all eigenvalues, right eigenvectors, and left
#' eigenvectors estimated for a matrix by the \code{eigs_gen}() function
#' in the C++ Armadillo library. Works with sparse matrices.
#' 
#' @name decomp3sp_inp
#' 
#' @param Amat A population projection matrix of class \code{matrix}.
#'
#' @return This function returns all estimated eigenvalues, right
#' eigenvectors, and left eigenvectors of a single matrix. This output is
#' provided as a list with three parts, named appropriately.
#' 
#' @section Notes:
#' This function works slightly differently from function \code{decomp3sp()} in
#' that the latter function requires a sparse matrix provided in dense format,
#' while this function requires a sparse matrix in sparse format.
#' 
#' @keywords internal
#' @noRd
.decomp3sp_inp <- function(spAmat) {
    .Call('_lefko3_decomp3sp_inp', PACKAGE = 'lefko3', spAmat)
}

#' Estimate Deterministic Population Growth Rate of Any Matrix
#' 
#' \code{lambda3matrix()} returns the dominant eigenvalue of a single
#' dense or sparse projection matrix, provided in dense matrix format.
#' 
#' @name lambda3matrix
#' 
#' @param Amat A population projection matrix of class \code{matrix}.
#' @param sparse A logical value indicating whether to use sparse matrix
#' format.
#'
#' @return This function returns the dominant eigenvalue of the matrix. This
#' is given as the largest real part of all eigenvalues estimated via the 
#' \code{eig_gen}() and \code{eigs_gen}() functions in the C++ Armadillo
#' library.
#' 
#' @keywords internal
#' @noRd
.lambda3matrix <- function(Amat, sparse) {
    .Call('_lefko3_lambda3matrix', PACKAGE = 'lefko3', Amat, sparse)
}

#' Estimate Stable Stage Distribution of Any Population Matrix
#' 
#' \code{ss3matrix()} returns the stable stage distribution for a 
#' dense or sparse population matrix.
#' 
#' @name ss3matrix
#' 
#' @param Amat A population projection matrix of class \code{matrix}.
#' @param sparse A logical value indicating whether to use sparse or dense
#' format in matrix calculations.
#' 
#' @return This function returns the stable stage distribution corresponding to
#' the input matrix.
#' 
#' @seealso \code{\link{stablestage3}()}
#' @seealso \code{\link{stablestage3.lefkoMat}()}
#' 
#' @keywords internal
#' @noRd
.ss3matrix <- function(Amat, sparse) {
    .Call('_lefko3_ss3matrix', PACKAGE = 'lefko3', Amat, sparse)
}

#' Estimate Reproductive Value of Any Population Matrix
#' 
#' \code{rv3matrix()} returns the reproductive values for stages in a
#' dense or sparse population matrix (both provided in dense matrix format).
#' The function provides standard reproductive values, meaning that the overall
#' reproductive values of basic life history stages in a historical matrix are
#' not provided (the \code{\link{repvalue3.lefkoMat}()} function estimates
#' these on the basis of stage description information provided in the
#' \code{lefkoMat} object used as input in that function).
#' 
#' @name rv3matrix
#' 
#' @param Amat A population projection matrix of class \code{matrix}.
#' @param sparse A logical value indicating whether to use sparse or dense
#' format in matrix calculations.
#' 
#' @return This function returns a vector characterizing the reproductive
#' values for stages of a population projection matrix.
#' 
#' @seealso \code{\link{repvalue3}()}
#' @seealso \code{\link{repvalue3.lefkoMat}()}
#' 
#' @keywords internal
#' @noRd
.rv3matrix <- function(Amat, sparse) {
    .Call('_lefko3_rv3matrix', PACKAGE = 'lefko3', Amat, sparse)
}

#' Estimate Deterministic Sensitivities of Any Population Matrix
#' 
#' \code{sens3matrix()} returns the sensitivity of lambda with respect
#' to each element in a dense or sparse matrix (provided in dense matrix
#' format). This is accomplished via the \code{eig_gen}() and \code{eigs_gen}()
#' functions in the C++ Armadillo library.
#' 
#' @name sens3matrix
#' 
#' @param Amat A population projection matrix of class \code{matrix}.
#' @param sparse A logical value indicating whether to use sparse or dense
#' format in matrix calculations.
#' 
#' @return This function returns a matrix of deterministic sensitivities. 
#' 
#' @keywords internal
#' @noRd
.sens3matrix <- function(Amat, sparse) {
    .Call('_lefko3_sens3matrix', PACKAGE = 'lefko3', Amat, sparse)
}

#' Estimate Deterministic Sensitivities of A Spars Matrixe
#' 
#' \code{sens3sp_matrix()} returns the sensitivity of lambda with respect
#' to each element in a sparse matrix, provided in sparse matrix format. This
#' is accomplished via the \code{eigs_gen}() function in the C++ Armadillo
#' library.
#' 
#' @name sens3sp_matrix
#' 
#' @param Aspmat A population projection matrix in sparse matrix format.
#' @param refmat A sparse matrix used for reference to create associated 0s in
#' the sensitivity matrix.
#' 
#' @return This function returns a sparse matrix of deterministic
#' sensitivities. Zeroes are derived from the reference matrix, and replace
#' non-zero entries that will be zeroed out in the following math. Currently
#' used in LTRE estimation.
#' 
#' @keywords internal
#' @noRd
.sens3sp_matrix <- function(Aspmat, refmat) {
    .Call('_lefko3_sens3sp_matrix', PACKAGE = 'lefko3', Aspmat, refmat)
}

#' Estimate Deterministic Sensitivities of a Historical LefkoMat Object
#' 
#' \code{sens3hlefko()} returns the sensitivity of lambda with respect
#' to each historical stage-pair in the matrix, and the associated
#' sensitivity for each life history stage. This is accomplished via the 
#' \code{eigs_gen}() function in the C++ Armadillo library.
#' 
#' @name sens3hlefko
#' 
#' @param Amat A population projection matrix of class \code{matrix}.
#' @param ahstages An integar vector of unique ahistorical stages.
#' @param hstages An integar vector of unique historical stage pairs.
#' 
#' @return This function returns a list with two deterministic sensitivity
#' matrices:
#' \item{h_smat}{Matrix of sensitivities corresponding to the historical
#' matrix.}
#' \item{ah_smat}{Matrix of sensitivities corresponding to the ahistorical
#' matrix.}
#' 
#' @keywords internal
#' @noRd
.sens3hlefko <- function(Amat, ahstages, hstages) {
    .Call('_lefko3_sens3hlefko', PACKAGE = 'lefko3', Amat, ahstages, hstages)
}

#' Estimate Deterministic Elasticities of Any Population Matrix
#' 
#' \code{elas3matrix()} returns the elasticity of lambda with respect
#' to each element in a dense or sparse matrix, both provided in dense matrix
#' format. This is accomplished via the \code{eig_gen}() and \code{eigs_gen}()
#' functions in the C++ Armadillo library.
#' 
#' @name elas3matrix
#' 
#' @param Amat A population projection matrix of class \code{matrix}.
#' @param sparse A logical value indicating whether to use sparse or dense
#' format in matrix calculations.
#' 
#' @return This function returns a matrix of deterministic elasticities. 
#' 
#' @keywords internal
#' @noRd
.elas3matrix <- function(Amat, sparse) {
    .Call('_lefko3_elas3matrix', PACKAGE = 'lefko3', Amat, sparse)
}

#' Estimate Deterministic Elasticities of a Historical LefkoMat Object
#' 
#' \code{elas3hlefko()} returns the elasticity of lambda with respect
#' to each historical stage-pair in the matrix, and the summed elasticities
#' for each life history stage. This is accomplished via the \code{eigs_gen}()
#' function in the C++ Armadillo library.
#' 
#' @name elas3hlefko
#' 
#' @param Amat A population projection matrix.
#' @param ahstages An integar vector of unique ahistorical stages.
#' @param hstages An integar vector of unique historical stage pairs.
#' 
#' @return This function returns a list with two deterministic elasticity
#' matrices:
#' \item{h_emat}{Matrix of elasticities corresponding to the historical matrix.}
#' \item{ah_emat}{Matrix of elasticities corresponding to the ahistorical
#' matrix, but using summed historical elasticities as the basis of estimation.}
#' 
#' @keywords internal
#' @noRd
.elas3hlefko <- function(Amat, ahstages, hstages) {
    .Call('_lefko3_elas3hlefko', PACKAGE = 'lefko3', Amat, ahstages, hstages)
}

#' Core Time-based Population Matrix Projection Function
#' 
#' Function \code{proj3()} runs the matrix projections used in other functions
#' in package \code{lefko3}.
#' 
#' @name proj3
#' 
#' @param start_vec The starting population vector for the projection.
#' @param core_list A list of full projection matrices, corresponding to the 
#' \code{$A} list within a \code{lefkoMat} object.
#' @param mat_order A vector giving the order of matrices to use at each occasion.
#' @param standardize A logical value stating whether to standardize population
#' size vector to sum to 1 at each estimated occasion.
#' @param growthonly A logical value stating whether to output only a matrix
#' showing the change in population size from one year to the next for use in
#' stochastic population growth rate estimation (TRUE), or a larger matrix also
#' containing the w and v projections for stochastic perturbation analysis,
#' stage distribution estimation, and reproductive value estimation.
#' @param integeronly A logical value indicating whether to round all projected
#' numbers of individuals to the nearest integer.
#' 
#' @return A matrix in which, if \code{growthonly = TRUE}, each row is the
#' population vector at each projected occasion, and if \code{growthonly =
#' FALSE}, the top third of the matrix is the actual number of individuals in
#' each stage across time, the second third is the w projection (stage
#' distribution), and the bottom third is the v projection (reproductive
#' values) for use in estimation of stochastic sensitivities and elasticities
#' (in addition, a further row is appended to the bottom, corresponding to the
#' \emph{R} vector, which is the sum of the unstandardized \emph{w} vector
#' resulting from each occasion's projection).
#' 
#' @keywords internal
#' @noRd
.proj3 <- function(start_vec, core_list, mat_order, standardize, growthonly, integeronly) {
    .Call('_lefko3_proj3', PACKAGE = 'lefko3', start_vec, core_list, mat_order, standardize, growthonly, integeronly)
}

#' Slimmed-down Time-based Population Sparse Matrix Projection Function
#' 
#' Function \code{proj3sp()} runs the matrix projections used in some other
#' functions in package \code{lefko3}, but only when the input is sparse. This
#' is a slimmed down version of function \code{proj3()}
#' 
#' @name proj3sp
#' 
#' @param start_vec The starting population vector for the projection.
#' @param core_list A list of full projection matrices, corresponding to
#' the \code{$A} list within a \code{lefkoMat} object. Matrices must be in
#' \code{arma::sp_mat} format.
#' @param mat_order A vector giving the order of matrices to use at each occasion.
#' @param standardize A logical value stating whether to standardize population
#' size vector to sum to 1 at each estimated occasion.
#' @param growthonly A logical value stating whether to output only a matrix
#' showing the change in population size from one year to the next for use in
#' stochastic population growth rate estimation (TRUE), or a larger matrix also
#' containing the w and v projections for stochastic perturbation analysis,
#' stage distribution estimation, and reproductive value estimation.
#' @param integeronly A logical value indicating whether to round all projected
#' numbers of individuals to the nearest integer.
#' 
#' @return A matrix in which, if \code{growthonly = TRUE}, each row is the
#' population vector at each projected occasion, and if \code{growthonly =
#' FALSE}, the top third of the matrix is the actual number of individuals in
#' each stage across time, the second third is the w projection (stage
#' distribution), and the bottom third is the v projection (reproductive
#' values) for use in estimation of stochastic sensitivities and elasticities
#' (in addition, a further row is appended to the bottom, corresponding to the
#' \emph{R} vector, which is the sum of the unstandardized \emph{w} vector
#' resulting from each occasion's projection).
#' 
#' @keywords internal
#' @noRd
.proj3sp <- function(start_vec, core_list, mat_order, standardize, growthonly, integeronly) {
    .Call('_lefko3_proj3sp', PACKAGE = 'lefko3', start_vec, core_list, mat_order, standardize, growthonly, integeronly)
}

#' Core Time-based Density-Dependent Population Matrix Projection Function
#' 
#' Function \code{proj3dens()} runs density-dependent matrix projections.
#' 
#' @name proj3dens
#' 
#' @param start_vec The starting population vector for the projection.
#' @param core_list A list of full projection matrices, corresponding to the 
#' \code{A} list within a \code{lefkoMat} object.
#' @param mat_order A vector giving the order of matrices to use at each occasion.
#' @param growthonly A logical value stating whether to output only a matrix
#' showing the change in population size from one year to the next for use in
#' stochastic population growth rate estimation (TRUE), or a larger matrix also
#' containing the w and v projections for stochastic perturbation analysis,
#' stage distribution estimation, and reproductive value estimation.
#' @param integeronly A logical value indicating whether to round all projected
#' numbers of individuals to the nearest integer.
#' @param substoch An integer value indicating whether to force survival-
#' transition matrices to be substochastic in density dependent simulations.
#' Defaults to \code{0}, which does not force substochasticity. Alternatively,
#' \code{1} forces all survival-transition elements to range from 0.0 to 1.0
#' and fecundity to be non-negative, and \code{2} forces all column rows to
#' total no more than 1.0.
#' @param dens_input The original \code{lefkoDens} data frame supplied through
#' the \code{\link{density_input}()} function.
#' @param dens_index A list giving the indices of elements in object
#' \code{dens_input}.
#' @param allow_warnings A logical value indicating whether the function should
#' send warnings if estimated values fall outside of the realm of possibility.
#' 
#' @return A matrix in which, if \code{growthonly = TRUE}, each row is the
#' population vector at each projected occasion, and if \code{growthonly =
#' FALSE}, the top third of the matrix is the actual number of individuals in
#' each stage across time, the second third is the w projection (stage
#' distribution), and the bottom third is the v projection (reproductive
#' values) for use in estimation of stochastic sensitivities and elasticities
#' (in addition, a further row is appended to the bottom, corresponding to the
#' \emph{R} vector, which is the sum of the unstandardized \emph{w} vector
#' resulting from each occasion's projection).
#' 
#' @section Notes:
#' There is no option to standardize population vectors here, because density
#' dependence requires the full population size to be tracked.
#' 
#' @keywords internal
#' @noRd
.proj3dens <- function(start_vec, core_list, mat_order, growthonly, integeronly, substoch, dens_input, dens_index, allow_warnings = FALSE) {
    .Call('_lefko3_proj3dens', PACKAGE = 'lefko3', start_vec, core_list, mat_order, growthonly, integeronly, substoch, dens_input, dens_index, allow_warnings)
}

#' Conduct Population Projection Simulations
#' 
#' Function \code{projection3()} runs projection simulations. It projects the
#' population and patches forward in time by a user-defined number of
#' occasions. A given set of matrices is utilized and not recreated, although
#' elements may be altered if density dependence is set. Projections may be
#' deterministic or stochastic, and may be density dependent in either case. If
#' deterministic, then projections will be cyclical if matrices exist covering
#' multiple occasions for each population or patch. If stochastic, then annual
#' matrices will be shuffled within patches and populations. Also produces
#' replicates if set.
#' 
#' @name projection3
#' 
#' @param mpm A matrix projection model of class \code{lefkoMat}, or a list of
#' full matrix projection matrices.
#' @param nreps The number of replicate projections.
#' @param times Number of occasions to iterate per replicate. Defaults to
#' 10,000.
#' @param historical An optional logical value only used if object \code{mpm}
#' is a list of matrices, rather than a \code{lefkoMat} object. Defaults to
#' \code{FALSE} for the former case, and overridden by information supplied in
#' the \code{lefkoMat} object for the latter case.
#' @param stochastic A logical value denoting whether to conduct a stochastic
#' projection or a deterministic / cyclical projection.
#' @param standardize A logical value denoting whether to re-standardize the
#' population size to 1.0 at each occasion. Defaults to \code{FALSE}.
#' @param growthonly A logical value indicating whether to produce only the
#' projected population size at each occasion, or a vector showing the stage
#' distribution followed by the reproductive value vector followed by the full
#' population size at each occasion. Defaults to \code{TRUE}.
#' @param integeronly A logical value indicating whether to round the number of
#' individuals projected in each stage at each occasion to the nearest
#' integer. Defaults to \code{FALSE}.
#' @param substoch An integer value indicating whether to force survival-
#' transition matrices to be substochastic in density dependent simulations.
#' Defaults to \code{0}, which does not force substochasticity. Alternatively,
#' \code{1} forces all survival-transition elements to range from 0.0 to 1.0,
#' and forces fecundity to be non-negative; and \code{2} forces all column rows
#' in the survival-transition matrices to total no more than 1.0, in addition
#' to the actions outlined for option \code{1}.
#' @param sub_warnings A logical value indicating whether to warn the user if
#' density dependence yields matrix values outside of the realm of possibility.
#' Generally, this means that survival-transition elements altered to values
#' outside of the interval [0, 1], and negative fecundity values, will both
#' yield warnings. Defaults to \code{TRUE}, but becomes \code{FALSE} if
#' \code{quiet = TRUE}.
#' @param quiet A logical value indicating whether to suppress warnings.
#' Defaults to \code{FALSE}.
#' @param year Either a single integer value corresponding to the year to
#' project, or a vector of \code{times} elements with the year to use at each
#' time step. If a vector shorter than \code{times} is supplied, then this
#' vector will be cycled. If not provided, then all annual matrices will be
#' cycled within patches or populations.
#' @param start_vec An optional numeric vector denoting the starting stage
#' distribution for the projection. Defaults to a single individual of each
#' stage.
#' @param start_frame An optional data frame characterizing stages, age-stages,
#' or stage-pairs that should be set to non-zero values in the starting vector,
#' and what those values should be. Can only be used with \code{lefkoMat}
#' objects.
#' @param tweights An optional numeric vector denoting the probabilistic
#' weightings of annual matrices. Defaults to equal weighting among occasions.
#' @param density An optional data frame describing the matrix elements that
#' will be subject to density dependence, and the exact kind of density
#' dependence that they will be subject to. The data frame used should be an
#' object of class \code{lefkoDens}, which is the output from function
#' \code{\link{density_input}()}.
#' 
#' @return A list of class \code{lefkoProj}, which always includes the first
#' three elements of the following, and also includes the remaining elements
#' below when a \code{lefkoMat} object is used as input:
#' \item{projection}{A list of lists of matrices showing the total number of
#' individuals per stage per occasion. The first list corresponds to each
#' pop-patch followed by each population. The inner list corresponds to
#' replicates within each pop-patch or population.}
#' \item{stage_dist}{A list of lists of the actual stage distribution in each
#' occasion in each replicate in each pop-patch or population. The list order
#' is the same as in \code{projection}.}
#' \item{rep_value}{A list of lists of the actual reproductive value in each
#' occasion in each replicate in each pop-patch or population. The list order
#' is the same as in \code{projection}.}
#' \item{pop_size}{A list of data frames showing the total population size in
#' each occasion per replicate (row within data frame) per pop-patch or
#' population (list element).}
#' \item{labels}{A data frame showing the order of populations and patches in
#' item \code{projection}.}
#' \item{ahstages}{The original stageframe used in the study.}
#' \item{hstages}{A data frame showing the order of historical stage pairs.}
#' \item{agestages}{A data frame showing the order of age-stage pairs.}
#' \item{control}{A short vector indicating the number of replicates and the
#' number of occasions projected per replicate.}
#' \item{density}{The data frame input under the density option. Only provided
#' if input by the user.}
#' 
#' @section Notes:
#' Projections are run both at the patch level and at the population level.
#' Population level estimates will be noted at the end of the
#' data frame with 0 entries for patch designation.
#' 
#' Weightings given in \code{tweights} do not need to sum to 1. Final
#' weightings used will be based on the proportion per element of the sum of
#' elements in the user-supplied vector.
#' 
#' Starting vectors can be input in one of two ways: 1) as \code{start_vec}
#' input, which is a vector of numbers of the numbers of individuals in each
#' stage, stage pair, or age-stage, with the length of the vector necessarily
#' as long as there are rows in the matrices of the MPM; or 2) as
#' \code{start_frame} input, which is a data frame showing only those stages,
#' stage pairs, or age-stages that should begin with more than 0 individuals,
#' and the numbers of individuals that those stages should start with (this
#' object is created using the \code{\link{start_input}()} function). If both
#' are provided, then \code{start_frame} takes precedence and \code{start_vec}
#' is ignored. If neither is provided, then \code{projection3()} automatically
#' assumes that each stage, stage pair, or age-stage begins with a single
#' individual. Importantly, if a \code{lefkoMat} object is not used, and a list
#' of matrices is provided instead, then \code{start_frame} cannot be utilized
#' and a full \code{start_vec} must be provided to conduct a simulation with
#' starting numbers of individuals other than 1 per stage.
#' 
#' The resulting data frames in element \code{projection} are separated by
#' pop-patch according to the order provided in element \code{labels}, but the
#' matrices for each element of \code{projection} have the result of each
#' replicate stacked in order on top of one another without any break or
#' indication. Results for each replicate must be separated using the
#' information provided in elements \code{control} and the 3 stage
#' descriptor elements.
#' 
#' Density dependent projections are automatically set up if object
#' \code{density} is input. If this object is not included, then density
#' independent projections will be set up. Note that currently, density
#' dependent projections can only be performed with \code{lefkoMat} objects.
#' 
#' The stage distributions and reproductive values produced are not the
#' asymptotic values as would be given by the standardized right and left
#' eigenvectors associated with the dominant eigenvalue of a matrix, but are
#' vectors describing these values at the specific points in time projected.
#' See equations 14.86 and 14.88 and section 14.4 on Sensitivity and Elasticity
#' Analysis under Environmental Stochasticity in Caswell (2001, Matrix
#' Population Models, Sinauer Associates) for more details.
#' 
#' Consistently positive population growth can quickly lead to population size
#' numbers larger than can be handled computationally. In that circumstance, a
#' continuously rising population size will suddenly become \code{NaN} for the
#' remainder of the projection.
#' 
#' Users wishing to run a projection of a single patch in a \code{lefkoMat}
#' object with multiple patches should subset the MPM first to contain only
#' the patch needed. This can be accomplished with the
#' \code{\link{subset_lM}()} function.
#' 
#' @seealso \code{\link{start_input}()}
#' @seealso \code{\link{density_input}()}
#' @seealso \code{\link{f_projection3}()}
#' 
#' @examples
#' # Lathyrus example
#' data(lathyrus)
#' 
#' sizevector <- c(0, 100, 13, 127, 3730, 3800, 0)
#' stagevector <- c("Sd", "Sdl", "VSm", "Sm", "VLa", "Flo", "Dorm")
#' repvector <- c(0, 0, 0, 0, 0, 1, 0)
#' obsvector <- c(0, 1, 1, 1, 1, 1, 0)
#' matvector <- c(0, 0, 1, 1, 1, 1, 1)
#' immvector <- c(1, 1, 0, 0, 0, 0, 0)
#' propvector <- c(1, 0, 0, 0, 0, 0, 0)
#' indataset <- c(0, 1, 1, 1, 1, 1, 1)
#' binvec <- c(0, 100, 11, 103, 3500, 3800, 0.5)
#' 
#' lathframe <- sf_create(sizes = sizevector, stagenames = stagevector,
#'   repstatus = repvector, obsstatus = obsvector, matstatus = matvector,
#'   immstatus = immvector, indataset = indataset, binhalfwidth = binvec,
#'   propstatus = propvector)
#' 
#' lathvert <- verticalize3(lathyrus, noyears = 4, firstyear = 1988,
#'   patchidcol = "SUBPLOT", individcol = "GENET", blocksize = 9,
#'   juvcol = "Seedling1988", sizeacol = "Volume88", repstracol = "FCODE88",
#'   fecacol = "Intactseed88", deadacol = "Dead1988",
#'   nonobsacol = "Dormant1988", stageassign = lathframe, stagesize = "sizea",
#'   censorcol = "Missing1988", censorkeep = NA, censor = TRUE)
#' 
#' lathsupp3 <- supplemental(stage3 = c("Sd", "Sd", "Sdl", "Sdl", "Sd", "Sdl"), 
#'   stage2 = c("Sd", "Sd", "Sd", "Sd", "rep", "rep"),
#'   stage1 = c("Sd", "rep", "Sd", "rep", "all", "all"), 
#'   givenrate = c(0.345, 0.345, 0.054, 0.054, NA, NA),
#'   multiplier = c(NA, NA, NA, NA, 0.345, 0.054),
#'   type = c(1, 1, 1, 1, 3, 3), type_t12 = c(1, 2, 1, 2, 1, 1),
#'   stageframe = lathframe, historical = TRUE)
#' 
#' ehrlen3 <- rlefko3(data = lathvert, stageframe = lathframe,
#'   year = c(1989, 1990), stages = c("stage3", "stage2", "stage1"),
#'   supplement = lathsupp3, yearcol = "year2", indivcol = "individ")
#' 
#' lathproj <- projection3(ehrlen3, nreps = 5, stochastic = TRUE)
#' 
#' # Cypripedium example
#' data(cypdata)
#'  
#' sizevector <- c(0, 0, 0, 0, 0, 0, 1, 2.5, 4.5, 8, 17.5)
#' stagevector <- c("SD", "P1", "P2", "P3", "SL", "D", "XSm", "Sm", "Md", "Lg",
#'   "XLg")
#' repvector <- c(0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1)
#' obsvector <- c(0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1)
#' matvector <- c(0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1)
#' immvector <- c(0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0)
#' propvector <- c(1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)
#' indataset <- c(0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1)
#' binvec <- c(0, 0, 0, 0, 0, 0.5, 0.5, 1, 1, 2.5, 7)
#' 
#' cypframe_raw <- sf_create(sizes = sizevector, stagenames = stagevector,
#'   repstatus = repvector, obsstatus = obsvector, matstatus = matvector, 
#'   propstatus = propvector, immstatus = immvector, indataset = indataset,
#'   binhalfwidth = binvec)
#' 
#' cypraw_v1 <- verticalize3(data = cypdata, noyears = 6, firstyear = 2004,
#'   patchidcol = "patch", individcol = "plantid", blocksize = 4, 
#'   sizeacol = "Inf2.04", sizebcol = "Inf.04", sizeccol = "Veg.04", 
#'   repstracol = "Inf.04", repstrbcol = "Inf2.04", fecacol = "Pod.04",
#'   stageassign = cypframe_raw, stagesize = "sizeadded", NAas0 = TRUE, 
#'   NRasRep = TRUE)
#' 
#' cypsupp3r <- supplemental(stage3 = c("SD", "SD", "P1", "P1", "P2", "P3", "SL",
#'     "D", "XSm", "Sm", "D", "XSm", "Sm", "mat", "mat", "mat", "SD", "P1"),
#'   stage2 = c("SD", "SD", "SD", "SD", "P1", "P2", "P3", "SL", "SL", "SL", "SL",
#'     "SL", "SL", "D", "XSm", "Sm", "rep", "rep"),
#'   stage1 = c("SD", "rep", "SD", "rep", "SD", "P1", "P2", "P3", "P3", "P3",
#'     "SL", "SL", "SL", "SL", "SL", "SL", "mat", "mat"),
#'   eststage3 = c(NA, NA, NA, NA, NA, NA, NA, "D", "XSm", "Sm", "D", "XSm", "Sm",
#'     "mat", "mat", "mat", NA, NA),
#'   eststage2 = c(NA, NA, NA, NA, NA, NA, NA, "XSm", "XSm", "XSm", "XSm", "XSm",
#'     "XSm", "D", "XSm", "Sm", NA, NA),
#'   eststage1 = c(NA, NA, NA, NA, NA, NA, NA, "XSm", "XSm", "XSm", "XSm", "XSm",
#'     "XSm", "XSm", "XSm", "XSm", NA, NA),
#'   givenrate = c(0.1, 0.1, 0.2, 0.2, 0.2, 0.2, 0.25, NA, NA, NA, NA, NA, NA,
#'     NA, NA, NA, NA, NA),
#'   multiplier = c(NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
#'     NA, 0.5, 0.5),
#'   type = c(1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3),
#'   type_t12 = c(1, 2, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1),
#'   stageframe = cypframe_raw, historical = TRUE)
#' 
#' cypmatrix3r <- rlefko3(data = cypraw_v1, stageframe = cypframe_raw, 
#'   year = "all", patch = "all", stages = c("stage3", "stage2", "stage1"),
#'   size = c("size3added", "size2added", "size1added"), 
#'   supplement = cypsupp3r, yearcol = "year2", 
#'   patchcol = "patchid", indivcol = "individ")
#' 
#' cypstoch <- projection3(cypmatrix3r, nreps = 5, stochastic = TRUE)
#' 
#' @export projection3
projection3 <- function(mpm, nreps = 1L, times = 10000L, historical = FALSE, stochastic = FALSE, standardize = FALSE, growthonly = TRUE, integeronly = FALSE, substoch = 0L, sub_warnings = TRUE, quiet = FALSE, year = NULL, start_vec = NULL, start_frame = NULL, tweights = NULL, density = NULL) {
    .Call('_lefko3_projection3', PACKAGE = 'lefko3', mpm, nreps, times, historical, stochastic, standardize, growthonly, integeronly, substoch, sub_warnings, quiet, year, start_vec, start_frame, tweights, density)
}

#' Estimate Stochastic Population Growth Rate
#' 
#' Function \code{slambda3()} estimates the stochastic population growth rate,
#' \eqn{a}, defined as the long-term arithmetic mean of the log population 
#' growth rate estimated per simulated occasion. This function can handle both
#' lefkoMat objects and lists of full A matrices as input. 
#' 
#' @name slambda3
#' 
#' @param mpm A matrix projection model of class \code{lefkoMat}, or a list of
#' full matrix projection matrices.
#' @param times Number of occasions to iterate. Defaults to \code{10000}.
#' @param historical An optional logical value only used if object \code{mpm}
#' is a list of matrices, rather than a \code{lefkoMat} object. Defaults to
#' \code{FALSE} for the former case, and overridden by information supplied in
#' the \code{lefkoMat} object for the latter case.
#' @param dense_only A logical value indicating whether to force matrices to be
#' run in dense format. Defaults to \code{FALSE}, and should only be used if
#' errors occur when running under default conditions.
#' @param tweights Numeric vector denoting the probabilistic weightings of
#' annual matrices. Defaults to equal weighting among occasions.
#' 
#' @return A data frame with the following variables:
#' 
#' \item{pop}{The identity of the population.}
#' \item{patch}{The identity of the patch.}
#' \item{a}{Estimate of stochastic growth rate, estimated as the arithmetic
#' mean of the log population growth rate across simulated occasions.}
#' \item{var}{The estimated variance of a.}
#' \item{sd}{The standard deviation of a.}
#' \item{se}{The standard error of a.}
#'
#' @section Notes:
#' The log stochastic population growth rate, \eqn{a}, is as given in equation
#' 2 of Tuljapurkar, Horvitz, and Pascarella 2003. This term is estimated via
#' projection of randomly sampled matrices, similarly to the procedure outlined
#' in Box 7.4 of Morris and Doak (2002).
#'  
#' Stochastic growth rate is estimated both at the patch level and at the
#' population level. Population level estimates will be noted at the end of the
#' data frame with 0 entries for patch designation.
#' 
#' Weightings given in \code{tweights} do not need to sum to 1. Final
#' weightings used will be based on the proportion per element of the sum of
#' elements in the user-supplied vector.
#'
#' @examples
#' # Lathyrus example
#' data(lathyrus)
#' 
#' sizevector <- c(0, 100, 13, 127, 3730, 3800, 0)
#' stagevector <- c("Sd", "Sdl", "VSm", "Sm", "VLa", "Flo", "Dorm")
#' repvector <- c(0, 0, 0, 0, 0, 1, 0)
#' obsvector <- c(0, 1, 1, 1, 1, 1, 0)
#' matvector <- c(0, 0, 1, 1, 1, 1, 1)
#' immvector <- c(1, 1, 0, 0, 0, 0, 0)
#' propvector <- c(1, 0, 0, 0, 0, 0, 0)
#' indataset <- c(0, 1, 1, 1, 1, 1, 1)
#' binvec <- c(0, 100, 11, 103, 3500, 3800, 0.5)
#' 
#' lathframe <- sf_create(sizes = sizevector, stagenames = stagevector,
#'   repstatus = repvector, obsstatus = obsvector, matstatus = matvector,
#'   immstatus = immvector, indataset = indataset, binhalfwidth = binvec,
#'   propstatus = propvector)
#' 
#' lathvert <- verticalize3(lathyrus, noyears = 4, firstyear = 1988,
#'   patchidcol = "SUBPLOT", individcol = "GENET", blocksize = 9,
#'   juvcol = "Seedling1988", sizeacol = "Volume88", repstracol = "FCODE88",
#'   fecacol = "Intactseed88", deadacol = "Dead1988",
#'   nonobsacol = "Dormant1988", stageassign = lathframe, stagesize = "sizea",
#'   censorcol = "Missing1988", censorkeep = NA, censor = TRUE)
#' 
#' lathsupp3 <- supplemental(stage3 = c("Sd", "Sd", "Sdl", "Sdl", "Sd", "Sdl"), 
#'   stage2 = c("Sd", "Sd", "Sd", "Sd", "rep", "rep"),
#'   stage1 = c("Sd", "rep", "Sd", "rep", "all", "all"), 
#'   givenrate = c(0.345, 0.345, 0.054, 0.054, NA, NA),
#'   multiplier = c(NA, NA, NA, NA, 0.345, 0.054),
#'   type = c(1, 1, 1, 1, 3, 3), type_t12 = c(1, 2, 1, 2, 1, 1),
#'   stageframe = lathframe, historical = TRUE)
#' 
#' ehrlen3 <- rlefko3(data = lathvert, stageframe = lathframe,
#'   year = c(1989, 1990), stages = c("stage3", "stage2", "stage1"),
#'   supplement = lathsupp3, yearcol = "year2", indivcol = "individ")
#' 
#' slambda3(ehrlen3)
#' 
#' # Cypripedium example
#' data(cypdata)
#'  
#' sizevector <- c(0, 0, 0, 0, 0, 0, 1, 2.5, 4.5, 8, 17.5)
#' stagevector <- c("SD", "P1", "P2", "P3", "SL", "D", "XSm", "Sm", "Md", "Lg",
#'   "XLg")
#' repvector <- c(0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1)
#' obsvector <- c(0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1)
#' matvector <- c(0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1)
#' immvector <- c(0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0)
#' propvector <- c(1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)
#' indataset <- c(0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1)
#' binvec <- c(0, 0, 0, 0, 0, 0.5, 0.5, 1, 1, 2.5, 7)
#' 
#' cypframe_raw <- sf_create(sizes = sizevector, stagenames = stagevector,
#'   repstatus = repvector, obsstatus = obsvector, matstatus = matvector, 
#'   propstatus = propvector, immstatus = immvector, indataset = indataset,
#'   binhalfwidth = binvec)
#' 
#' cypraw_v1 <- verticalize3(data = cypdata, noyears = 6, firstyear = 2004,
#'   patchidcol = "patch", individcol = "plantid", blocksize = 4, 
#'   sizeacol = "Inf2.04", sizebcol = "Inf.04", sizeccol = "Veg.04", 
#'   repstracol = "Inf.04", repstrbcol = "Inf2.04", fecacol = "Pod.04",
#'   stageassign = cypframe_raw, stagesize = "sizeadded", NAas0 = TRUE, 
#'   NRasRep = TRUE)
#' 
#' cypsupp3r <- supplemental(stage3 = c("SD", "SD", "P1", "P1", "P2", "P3", "SL",
#'     "D", "XSm", "Sm", "D", "XSm", "Sm", "mat", "mat", "mat", "SD", "P1"),
#'   stage2 = c("SD", "SD", "SD", "SD", "P1", "P2", "P3", "SL", "SL", "SL", "SL",
#'     "SL", "SL", "D", "XSm", "Sm", "rep", "rep"),
#'   stage1 = c("SD", "rep", "SD", "rep", "SD", "P1", "P2", "P3", "P3", "P3",
#'     "SL", "SL", "SL", "SL", "SL", "SL", "mat", "mat"),
#'   eststage3 = c(NA, NA, NA, NA, NA, NA, NA, "D", "XSm", "Sm", "D", "XSm", "Sm",
#'     "mat", "mat", "mat", NA, NA),
#'   eststage2 = c(NA, NA, NA, NA, NA, NA, NA, "XSm", "XSm", "XSm", "XSm", "XSm",
#'     "XSm", "D", "XSm", "Sm", NA, NA),
#'   eststage1 = c(NA, NA, NA, NA, NA, NA, NA, "XSm", "XSm", "XSm", "XSm", "XSm",
#'     "XSm", "XSm", "XSm", "XSm", NA, NA),
#'   givenrate = c(0.1, 0.1, 0.2, 0.2, 0.2, 0.2, 0.25, NA, NA, NA, NA, NA, NA,
#'     NA, NA, NA, NA, NA),
#'   multiplier = c(NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
#'     NA, 0.5, 0.5),
#'   type = c(1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3),
#'   type_t12 = c(1, 2, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1),
#'   stageframe = cypframe_raw, historical = TRUE)
#' 
#' cypmatrix3r <- rlefko3(data = cypraw_v1, stageframe = cypframe_raw, 
#'   year = "all", patch = "all", stages = c("stage3", "stage2", "stage1"),
#'   size = c("size3added", "size2added", "size1added"), 
#'   supplement = cypsupp3r, yearcol = "year2", 
#'   patchcol = "patchid", indivcol = "individ")
#' 
#' cypstoch <- slambda3(cypmatrix3r, dense_only = TRUE)
#' cypstoch
#' 
#' @export slambda3
slambda3 <- function(mpm, times = 10000L, historical = FALSE, dense_only = FALSE, tweights = NULL) {
    .Call('_lefko3_slambda3', PACKAGE = 'lefko3', mpm, times, historical, dense_only, tweights)
}

#' Estimate Stochastic Sensitivity or Elasticity of Matrix Set
#' 
#' Function \code{stoch_senselas()} estimates the sensitivity and elasticity to
#' matrix elements of \eqn{a}, defined as the long-term arithmetic mean of the
#' log population growth estimated per simulated occasion (as given in equation 2
#' in Tuljapurkar, Horvitz, and Pascarella 2003). 
#' 
#' @name stoch_senselas
#' 
#' @param mpm A matrix projection model of class \code{lefkoMat}, or a list of
#' full matrix projection matrices.
#' @param times Number of occasions to iterate. Defaults to 10,000.
#' @param historical An optional logical value only used if object \code{mpm}
#' is a list of matrices, rather than a \code{lefkoMat} object. Defaults to
#' \code{FALSE} for the former case, and overridden by information supplied in
#' the \code{lefkoMat} object for the latter case.
#' @param style An integer designating whether to estimate sensitivity matrices
#' (\code{1}) or elasticity matrices (\code{2}). Defaults to \code{1}.
#' @param tweights Numeric vector denoting the probabilistic weightings of
#' annual matrices. Defaults to equal weighting among occasions.
#' 
#' @return A list of one or two cubes (3d array) where each slice corresponds
#' to a sensitivity or elasticity matrix for a specific pop-patch, followed by
#' the sensitivity or elasticity matrices of all populations (only if multiple
#' pop-patches occur in the input). Two such cubes are only provided when a
#' historical lefkoMat object is used as input, in which case the first
#' element is the historical sensitivity/elasticity matrix, and the second is
#' the ahistorical sensitivity/elasticity matrix.
#' 
#' @section Notes:
#' Weightings given in \code{tweights} do not need to sum to 1. Final
#' weightings used will be based on the proportion per element of the sum of
#' elements in the user-supplied vector.
#' 
#' This function currently requires all patches to have the same occasions, if
#' a \code{lefkoMat} object is used as input. Asymmetry in the number of
#' occasions across patches and/or populations will likely cause errors.
#'
#' @keywords internal
#' @noRd
.stoch_senselas <- function(mpm, times = 10000L, historical = FALSE, style = 1L, tweights = NULL) {
    .Call('_lefko3_stoch_senselas', PACKAGE = 'lefko3', mpm, times, historical, style, tweights)
}

#' Creates Size Index for Elasticity Summaries of hMPMs
#' 
#' Function \code{bambi3()} creates an index of estimable elements in
#' historical matrices, and details the kind of transition that it is.
#' 
#' @name bambi3
#' 
#' @param stages This is the core stageframe held by \code{mats}, equivalent to
#' \code{ahstages}.
#' @param hstages This is the \code{hstages} object held by \code{mats}.
#' 
#' @return A data frame with the following elements:
#' \item{index}{Vector index of matrix element in C++ terms.}
#' \item{transition}{Category of transition.}
#' \item{size3}{Size in occasion \emph{t}+1.}
#' \item{repstatus3}{Reproductive status in occasion \emph{t}+1.}
#' \item{entrystatus3}{Entry status in occasion \emph{t}+1.}
#' \item{size2}{Size in occasion \emph{t}.}
#' \item{repstatus2}{Reproductive status in occasion \emph{t}.}
#' \item{entrystatus2}{Entry status in occasion \emph{t}.}
#' \item{size1}{Size in occasion \emph{t}-1.}
#' \item{repstatus1}{Reproductive status in occasion \emph{t}11.}
#' \item{entrystatus1}{Entry status in occasion \emph{t}-1.}
#'
#' The kind of transitions conforms to the following code: \code{10}: full
#' stasis, \code{11}: stasis to growth, \code{12}: full growth, \code{13}:
#' growth to stasis, \code{14}: stasis to shrinkage, \code{15}: full shrinkage,
#' \code{16}: shrinkage to stasis, \code{17}: growth to shrinkage, \code{18}:
#' shrinkage to growth, \code{20}: stasis to fecundity, \code{21}: growth to
#' fecundity, \code{22}: shrinkage to fecundity, \code{23}: fecundity to
#' stasis, \code{24}: fecundity to growth, \code{25}: fecundity to shrinkage,
#' \code{26}: fecundity to fecundity.
#' 
#' @keywords internal
#' @noRd
.bambi3 <- function(stages, hstages) {
    .Call('_lefko3_bambi3', PACKAGE = 'lefko3', stages, hstages)
}

#' Creates Size Index for Elasticity Summaries of ahMPMs
#' 
#' Function \code{bambi2()} creates an index of estimable elements in
#' ahistorical matrices, and details the kind of transition that it is.
#' 
#' @name bambi2
#' 
#' @param stages This is the core stageframe held by \code{mats}, equivalent to
#' \code{ahstages}.
#' 
#' @return A data frame with the following elements:
#' \item{index}{Vector index of matrix element in C++ terms.}
#' \item{transition}{Category of transition.}
#' \item{stage3}{Stage in occasion \emph{t}+1.}
#' \item{size3}{Size in occasion \emph{t}+1.}
#' \item{repstatus3}{Reproductive status in occasion \emph{t}+1.}
#' \item{entrystatus3}{Entry status in occasion \emph{t}+1.}
#' \item{stage2}{Stage in occasion \emph{t}.}
#' \item{size2}{Size in occasion \emph{t}.}
#' \item{repstatus2}{Reproductive status in occasion \emph{t}.}
#' \item{entrystatus2}{Entry status in occasion \emph{t}.}
#'
#' The kind of transitions conforms to the following code: \code{1}: stasis, 
#' \code{2}: growth, \code{3}: shrinkage, \code{4}: fecundity.
#' 
#' @keywords internal
#' @noRd
.bambi2 <- function(stages) {
    .Call('_lefko3_bambi2', PACKAGE = 'lefko3', stages)
}

#' Creates Summary Data for Elasticity Matrix Inputs
#' 
#' Function \code{demolition3()} sums elasticity values from elasticity
#' matrices, and LTRE contributions from LTRE and sLTRE matrices, according to
#' the categories developed by functions \code{bambi2()} and \code{bambi3()}.
#' 
#' @name demolition3
#' 
#' @param e_amat A single elasticity, LTRE, or sLTRE matrix.
#' @param bambesque This is the output from \code{bambi2()} or \code{bambi3()}
#' corresponding to the current lefkoMat object. The format is a data frame
#' giving the indices and characteristics of all predicted potential non-zero
#' elements in the supplied matrix.
#' @param amat_ The A matrix corresponding to \code{e_amat}. If not supplied,
#' then only \code{bambesque} is used to determine transition categories. If
#' provided, then fecundity transitions may be split between fecundity and
#' survival portions.
#' @param fmat_ The F matrix corresponding to \code{e_amat}. If not supplied,
#' then only \code{bambesque} is used to determine transition categories. If
#' provided, then fecundity transitions may be split between fecundity and
#' survival portions.
#' 
#' @return A list with two data frames, one showing the summed elasticities for
#' the historical matrix supplied (if supplied), and the other showing the
#' ahistorical summary of the historical matrix or the summed elasticities of
#' a supplied ahistorical elasticity matrix. Also includes sums of only the
#' positive elements and only the negative elements, in all cases.
#' 
#' @section Notes:
#' If the original matrices are provided, then this function was made to split
#' co-occurring survival-fecundity elasticities according to the ratio of the
#' fecundity portion of the element to the survival portion of that element.
#' However, this transition splitting capability developed using the original
#' matrices does not currently work properly, and so it is better to use this
#' function without objects \code{amat_} and \code{fmat_}, forcing co-occurring
#' survival-fecundity transitions to be treated as fecundity only.
#' 
#' @keywords internal
#' @noRd
.demolition3 <- function(e_amat, bambesque, amat_ = NULL, fmat_ = NULL) {
    .Call('_lefko3_demolition3', PACKAGE = 'lefko3', e_amat, bambesque, amat_, fmat_)
}

#' Estimate LTRE of Any Population Matrix
#' 
#' \code{ltre3matrix()} returns the one-way fixed deterministic LTRE matrix of
#' a dense or sparse set of input matrices.
#' 
#' @name ltre3matrix
#' 
#' @param Amats A list of population projection matrices (not an entire
#' \code{lefkoMat} object.
#' @param refnum An integer vector giving the numbers of the matrices to use as
#' reference from_ \code{refmats}.
#' @param refmats_ A list of reference population projection matrices.
#' @param mean A logical value indicating whether to use the element-wise mean
#' matrix as the reference.
#' @param sparse A logical value indicating whether to use sparse or dense
#' format in matrix calculations.
#' 
#' @return This function returns a cube of LTRE contributions, with each slice
#' corresponding to each input matrix in Amats. 
#' 
#' @keywords internal
#' @noRd
.ltre3matrix <- function(Amats, refnum, refmats_ = NULL, mean = TRUE, sparse = FALSE) {
    .Call('_lefko3_ltre3matrix', PACKAGE = 'lefko3', Amats, refnum, refmats_, mean, sparse)
}

#' Estimate sLTRE of Any Population Matrix
#' 
#' \code{sltre3matrix()} returns the one-way stochastic LTRE matrix of
#' a dense or sparse set of input matrices.
#' 
#' @name sltre3matrix
#' 
#' @param Amats A list of population projection matrices (not an entire
#' \code{lefkoMat} object).
#' @param loy A data frame showing the order of populations, patches, and
#' occasions of the matrices provided in object \code{Amats}.
#' @param refnum An integer vector giving the numbers of the matrices to use as
#' reference from \code{refmats}.
#' @param refmats_ A list of reference population projection matrices.
#' @param tweights_ Numeric vector denoting the probabilistic weightings of
#' annual matrices. Defaults to equal weighting among occasions.
#' @param steps The number of occasions to project the stochastic simulation
#' forward, if performing an sLTRE. Defaults to \code{10000}. Note that the
#' total number of occasions projected equals this number plus the number given
#' in object \code{burnin}.
#' @param burnin The number of initial occasions to project the population
#' without calculating population metrics. Defaults to 3000.
#' @param sparse A logical value indicating whether to use sparse or dense
#' format in matrix calculations.
#' 
#' @return This function returns a list of two lists of matrices. The first,
#' \code{cont_mean}, holds the sLTRE contributions of shifts in mean elements.
#' The second, \code{cont_sd}, holds the sLTRE contributions of shifts in
#' temporal standard deviations of matrix elements.
#' 
#' @section Notes:
#' This function uses the simulation approach developed in Davison et al.
#' (2010), which is a good approximation though not an analytical solution.
#' 
#' @keywords internal
#' @noRd
.sltre3matrix <- function(Amats, loy, refnum, refmats_ = NULL, tweights_ = NULL, steps = 10000L, burnin = 3000L, sparse = FALSE) {
    .Call('_lefko3_sltre3matrix', PACKAGE = 'lefko3', Amats, loy, refnum, refmats_, tweights_, steps, burnin, sparse)
}

