% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_lcp.R
\name{create_lcp}
\alias{create_lcp}
\title{create_lcp}
\usage{
create_lcp(cost_surface, origin, destination, directional = FALSE)
}
\arguments{
\item{cost_surface}{\code{TransitionLayer} object (gdistance package). Cost surface to be used in Least Cost Path calculation.}

\item{origin}{\code{SpatialPoints} location from which the Least Cost Path is calculated. Only the first row is taken into account.}

\item{destination}{\code{SpatialPoints} location to which the Least Cost Path is calculated. Only the first row is taken into account.}

\item{directional}{if TRUE Least Cost Path calculated from origin to destination only. If FALSE Least Cost Path calculated from origin to destination and destination to origin. Default is FALSE.}
}
\value{
\code{SpatialLines} (sp package) or \code{list} of \code{SpatialLines} dependent on directional argument. The resultant object is the shortest route (i.e. least cost) between origin and destination using the supplied \code{TransitionLayer}.
}
\description{
Calculates Least Cost Path
}
\details{
Calculates the Least Cost Path from an origin location to a destination location. See details for more.
}
\examples{
r <- raster::raster(system.file('external/maungawhau.grd', package = 'gdistance'))

slope_cs <- create_slope_cs(r, cost_function = 'tobler')

traverse_cs <- create_traversal_cs(r, neighbours = 16)

final_cost_cs <- slope_cs * traverse_cs

loc1 = cbind(2667670, 6479000)
loc1 = sp::SpatialPoints(loc1)

loc2 = cbind(2667800, 6479400)
loc2 = sp::SpatialPoints(loc2)

lcps <- create_lcp(cost_surface = final_cost_cs, origin = loc1,
destination = loc2, directional = FALSE)
}
\author{
Joseph Lewis
}
